/*
 * Decompiled with CFR 0.152.
 */
package edu.upc.dama.dex.io;

import edu.upc.dama.dex.core.Graph;
import edu.upc.dama.dex.core.Objects;
import edu.upc.dama.dex.core.Value;
import edu.upc.dama.dex.io.ExporterListener;
import edu.upc.dama.dex.io.RowWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Set;

public class Exporter {
    private RowWriter rowWriter;
    private int objectType;
    private Graph graph;
    private static final int DEFAULT_FREQ = 100000;
    private int frequency;
    private ArrayList<ExporterListener> listeners;
    private boolean namesOnTop;
    private Long[] exportAttr;
    protected int headPos;
    protected int tailPos;
    protected long headAttr;
    protected long tailAttr;

    public Exporter(RowWriter rowWriter, Graph graph, int objectType, Long[] exportAttr) {
        Set<Long> allAttributes = graph.getAttributesFromType(objectType);
        for (int i = 0; i < exportAttr.length; ++i) {
            if (allAttributes.contains(exportAttr[i])) continue;
            throw new IllegalArgumentException();
        }
        this.rowWriter = rowWriter;
        this.graph = graph;
        this.objectType = objectType;
        this.exportAttr = exportAttr;
        this.frequency = 100000;
        this.namesOnTop = false;
        this.listeners = new ArrayList();
        this.headPos = -1;
        this.tailPos = -1;
        this.headAttr = 0L;
        this.tailAttr = 0L;
    }

    public Exporter(RowWriter rowWriter, Graph graph, int objectType) {
        this(rowWriter, graph, objectType, graph.getAttributesFromType(objectType).toArray(new Long[0]));
    }

    public void registerUnloaderListener(ExporterListener ul) {
        this.listeners.add(ul);
    }

    public void setFrequency(int frequency) {
        this.frequency = frequency;
    }

    public int getFrequency() {
        return this.frequency;
    }

    public void setNamesOnTop(boolean b) {
        this.namesOnTop = b;
    }

    public boolean getNamesOnTop() {
        return this.namesOnTop;
    }

    private void callListeners(ExporterEvent le) {
        ExporterEvent copy = new ExporterEvent(le);
        Iterator<ExporterListener> it = this.listeners.iterator();
        while (it.hasNext()) {
            it.next().exportProgress(copy);
        }
    }

    public void run() throws IOException {
        boolean node = this.graph.isTypeNode(this.objectType);
        String[] wc = null;
        wc = node ? new String[this.exportAttr.length] : new String[this.exportAttr.length + 2];
        int aux = 0;
        if (this.namesOnTop) {
            if (!node) {
                Graph.AttributeData attrd = this.graph.getAttributeData(this.tailAttr);
                Graph.TypeData tdata = this.graph.getTypeData(attrd.getType());
                wc[this.tailPos] = "tail_" + tdata.getName() + "." + attrd.getName();
                attrd = this.graph.getAttributeData(this.headAttr);
                tdata = this.graph.getTypeData(attrd.getType());
                wc[this.headPos] = "head_" + tdata.getName() + "." + attrd.getName();
            }
            int i = 0;
            while (i < this.exportAttr.length) {
                while (aux == this.headPos || aux == this.tailPos) {
                    ++aux;
                }
                Graph.AttributeData attrd = this.graph.getAttributeData(this.exportAttr[i]);
                wc[aux] = attrd.getName();
                ++i;
                ++aux;
            }
            this.rowWriter.writeNext(wc);
        }
        Objects ob = this.graph.select(this.objectType);
        Objects.Iterator it = ob.iterator();
        ExporterEvent ue = new ExporterEvent();
        ue.total = ob.size();
        ue.objectType = this.objectType;
        ue.graph = this.graph;
        Value v = null;
        while (it.hasNext()) {
            long oid = (Long)it.next();
            if (!node) {
                long[] noid = this.graph.getEdge(oid);
                wc[this.tailPos] = this.graph.getAttribute(noid[0], this.tailAttr).toString();
                wc[this.headPos] = this.graph.getAttribute(noid[1], this.headAttr).toString();
            }
            aux = 0;
            int i = 0;
            while (i < this.exportAttr.length) {
                while (aux == this.headPos || aux == this.tailPos) {
                    ++aux;
                }
                v = this.graph.getAttribute(oid, this.exportAttr[i]);
                wc[aux] = !v.isNull() ? v.toString() : null;
                ++i;
                ++aux;
            }
            this.rowWriter.writeNext(wc);
            if (ue.count % (long)this.frequency == 0L) {
                this.callListeners(ue);
            }
            ++ue.count;
        }
        if (ue.count % (long)this.frequency != 0L) {
            this.callListeners(ue);
        }
        ob.close();
        this.rowWriter.close();
    }

    public class ExporterEvent {
        public int objectType;
        public long count;
        public long total;
        public Graph graph;

        ExporterEvent() {
        }

        ExporterEvent(ExporterEvent exporterEvent) {
            this.count = exporterEvent.count;
            this.objectType = exporterEvent.objectType;
            this.total = exporterEvent.total;
            this.graph = exporterEvent.graph;
        }
    }
}

