/*
 * Decompiled with CFR 0.152.
 */
package edu.upc.dama.dex.io;

import edu.upc.dama.dex.core.Graph;
import edu.upc.dama.dex.core.TextStream;
import edu.upc.dama.dex.core.Value;
import edu.upc.dama.dex.io.CSVReader;
import edu.upc.dama.dex.io.CSVWriter;
import edu.upc.dama.dex.io.LoaderListener;
import edu.upc.dama.dex.io.RowReader;
import edu.upc.dama.dex.io.RowWriter;
import edu.upc.dama.dex.utils.StringLib;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.NoSuchElementException;

public abstract class Loader {
    private RowReader rowReader;
    private static final int DEFAULT_FREQ = 1000000;
    private int frequency = 1000000;
    private ArrayList<LoaderListener> listeners = new ArrayList();
    private Graph graph;
    private String dateformat = "yyyy-MM-dd hh:mm:ss";
    public static final String DEFAULT_DATEFORMAT = "yyyy-MM-dd hh:mm:ss";
    private int partitions = 1;
    private ArrayList<Integer> attrArrayPos = new ArrayList();
    private ArrayList<Long> attr = new ArrayList();
    private File logFile;
    private BufferedWriter logWriter;
    private boolean deleteTemp = true;
    private boolean logCreated;
    private int objectType;
    protected int tailPos;
    protected int headPos;
    protected long headAttr;
    protected long tailAttr;
    protected int tailType;
    protected int headType;

    protected Loader(RowReader rowReader, Graph graph, int objectType) {
        this.graph = graph;
        this.objectType = objectType;
        this.rowReader = rowReader;
        this.headAttr = 0L;
        this.headPos = 0;
        this.tailAttr = 0L;
        this.tailPos = 0;
        this.logFile = null;
        this.logWriter = null;
        this.logCreated = false;
    }

    public void registerLoaderListener(LoaderListener ll) {
        this.listeners.add(ll);
    }

    public void setFrequency(int frequency) {
        this.frequency = frequency;
    }

    public int getFrequency() {
        return this.frequency;
    }

    public void setDateFormat(String dateformat) {
        this.dateformat = dateformat;
    }

    public void setAttribute(long attributeId, int column) {
        this.attr.add(attributeId);
        this.attrArrayPos.add(column);
    }

    public void setDeleteTemporalFiles(boolean delete) {
        this.deleteTemp = delete;
    }

    public void setLogFile(File file) throws IOException {
        this.logFile = file;
    }

    public File getLogFile() {
        return this.logFile;
    }

    private void callListeners(LoaderEvent le) {
        LoaderEvent copy = new LoaderEvent(le);
        Iterator<LoaderListener> it = this.listeners.iterator();
        while (it.hasNext()) {
            it.next().loadProgress(copy);
        }
    }

    private Value getValueFromString(int type, String value) throws ParseException, IOException {
        Value val = new Value();
        switch (type) {
            case 4: {
                val.setBool(Boolean.valueOf(value));
                break;
            }
            case 3: {
                val.setDouble(Double.parseDouble(value));
                break;
            }
            case 1: {
                val.setInt(Integer.parseInt(value));
                break;
            }
            case 6: {
                val.setLong(Long.parseLong(value));
                break;
            }
            case 0: {
                val.setNull();
                break;
            }
            case 2: {
                val.setString(value);
                break;
            }
            case 7: {
                TextStream tstrm = new TextStream();
                val.setTextStream(tstrm);
                break;
            }
            case 5: {
                val.setNull();
                SimpleDateFormat df = new SimpleDateFormat(this.dateformat);
                Date d1 = df.parse(value);
                GregorianCalendar cal = new GregorianCalendar();
                cal.setTime(d1);
                val.setTimestamp(cal);
                break;
            }
            default: {
                val.setNull();
            }
        }
        return val;
    }

    private long getNode(long attr, int type, String value) throws ParseException, IOException {
        Value val = this.getValueFromString(type, value);
        return this.graph.findObj(attr, val);
    }

    public void run(Mode phases, int partitions) throws IOException {
        int max;
        this.partitions = phases == Mode.N_PHASES ? partitions : 1;
        try {
            max = Collections.max(this.attrArrayPos) + 1;
        }
        catch (NoSuchElementException ex) {
            max = 0;
        }
        ArrayList<Long> loadA = new ArrayList<Long>();
        ArrayList<Boolean> tmpA = new ArrayList<Boolean>();
        Long[] load = new Long[]{};
        Boolean[] tmp = new Boolean[]{};
        for (int i = 0; i < max; ++i) {
            tmpA.add(false);
            loadA.add(0L);
        }
        LoaderEvent le = new LoaderEvent();
        le.objects = 0L;
        le.graph = this.graph;
        le.phase = 1;
        le.partition = 1;
        le.partitions = 1;
        le.objectType = this.objectType;
        switch (phases) {
            case ONE_PHASE: {
                for (int i = 0; i < this.attrArrayPos.size(); ++i) {
                    loadA.set(this.attrArrayPos.get(i), this.attr.get(i));
                }
                load = loadA.toArray(load);
                tmp = tmpA.toArray(tmp);
                le.phases = 1;
                this.loadProcess(this.rowReader, true, load, tmp, le, max + 1, 0);
                break;
            }
            case TWO_PHASES: 
            case N_PHASES: {
                int total;
                for (int i = 0; i < this.attrArrayPos.size(); ++i) {
                    tmpA.set(this.attrArrayPos.get(i), true);
                }
                if (phases == Mode.TWO_PHASES) {
                    le.phases = 2;
                    total = 2;
                } else {
                    le.phases = total = this.attrArrayPos.size() + 1;
                }
                load = loadA.toArray(load);
                tmp = tmpA.toArray(tmp);
                File tmpFile = this.loadProcess(this.rowReader, true, load, tmp, le, max + 1, 0);
                if (tmpFile == null) break;
                CSVReader rr = new CSVReader(tmpFile);
                for (int j = 0; j < this.attrArrayPos.size(); ++j) {
                    loadA.set(this.attrArrayPos.get(j), this.attr.get(j));
                    tmpA.set(this.attrArrayPos.get(j), false);
                }
                Long[] aux = new Long[]{};
                aux = loadA.toArray(aux);
                tmp = tmpA.toArray(tmp);
                int j = 0;
                if (phases == Mode.N_PHASES) {
                    le.partitions = this.partitions;
                }
                for (int i = 1; i < total; ++i) {
                    le.phase = i + 1;
                    if (phases == Mode.TWO_PHASES) {
                        this.loadProcess(rr, false, aux, tmp, le, max + 1, 0);
                        continue;
                    }
                    while (aux[j] == 0L) {
                        ++j;
                    }
                    load[j] = aux[j];
                    short typecolumn = this.graph.getAttributeData(load[j]).getDatatype();
                    if (typecolumn == 7) {
                        this.loadProcess(rr, false, load, tmp, le, max + 1, 0);
                    } else {
                        this.loadProcess(rr, false, load, tmp, le, max + 1, j);
                    }
                    load[j] = 0L;
                    ++j;
                }
                if (!this.deleteTemp) break;
                tmpFile.delete();
            }
        }
        if (this.logCreated) {
            this.logWriter.flush();
            this.logWriter.close();
        }
    }

    private File loadProcess(RowReader rr, boolean create, Long[] load, Boolean[] tmp, LoaderEvent e, int aux, int partitionColumn) throws IOException {
        File tmpFile = null;
        RowWriter rw = null;
        FileWriter fw = null;
        boolean node = this.graph.isTypeNode(this.objectType);
        e.partition = 0;
        int[] dataType = new int[load.length];
        for (int i = 0; i < load.length; ++i) {
            if (load[i] == 0L) continue;
            dataType[i] = this.graph.getAttributeData(load[i]).getDatatype();
        }
        boolean createTmpFile = false;
        for (int i = 0; i < tmp.length; ++i) {
            if (!tmp[i].booleanValue()) continue;
            createTmpFile = true;
            tmpFile = File.createTempFile("tempattr", ".tmp", new File("."));
            fw = new FileWriter(tmpFile);
            rw = new CSVWriter(fw);
            break;
        }
        String[] wvs = tmp.length + 1 >= aux ? new String[tmp.length + 2] : new String[aux + 1];
        for (int j = 0; j < e.partitions; ++j) {
            String[] vs;
            rr.reset();
            ++e.partition;
            e.steps = 0;
            while ((vs = rr.readNext()) != null) {
                if (vs.length <= 0) continue;
                ++e.steps;
                long obj = 0L;
                try {
                    if (e.partitions == 1 || Math.abs(this.getValueFromString(dataType[partitionColumn], vs[partitionColumn]).hashCode() % e.partitions) == j) {
                        if (create) {
                            obj = node ? this.graph.newNode(this.objectType) : this.graph.newEdge(this.tailAttr, this.getValueFromString(this.tailType, vs[this.tailPos]), this.headAttr, this.getValueFromString(this.headType, vs[this.headPos]), this.objectType);
                            e.objects = e.objects + (long)(obj == 0L ? 0 : 1);
                        } else {
                            obj = Long.parseLong(vs[aux]);
                        }
                        wvs[aux] = Long.toString(obj);
                        for (int i = 0; i < load.length && i < vs.length; ++i) {
                            try {
                                if (vs[i].length() == 0) continue;
                                if (load[i] != 0L) {
                                    Value v = this.getValueFromString(dataType[i], vs[i]);
                                    this.graph.setAttribute(obj, load[i], v);
                                    if (dataType[i] == 7) {
                                        TextStream tstrm = v.getTextStream();
                                        tstrm.write(vs[i].toCharArray(), 0, vs[i].length());
                                        tstrm.close();
                                    }
                                }
                                if (!tmp[i].booleanValue()) continue;
                                wvs[i] = vs[i];
                                continue;
                            }
                            catch (Exception ex) {
                                throw new Exception("[Column " + i + ", attribute \"" + this.graph.getAttributeData(load[i]).getName() + "\"] " + ex.getMessage());
                            }
                        }
                        if (createTmpFile) {
                            rw.writeNext(wvs);
                        }
                    }
                }
                catch (Exception we) {
                    if (create && obj != 0L) {
                        this.graph.drop(obj);
                        --e.objects;
                    }
                    String msg = "Exception loading row " + rr.getRow() + ": ";
                    msg = msg + StringLib.toString(vs, ", ");
                    if (this.logFile != null) {
                        if (!this.logCreated) {
                            this.logWriter = new BufferedWriter(new FileWriter(this.logFile));
                            this.logCreated = true;
                        }
                        this.logWriter.write(msg + "\n");
                        this.logWriter.write("::Message: " + we.getMessage() + "\n");
                        this.logWriter.flush();
                    }
                    throw new IOException(msg);
                }
                if (e.steps % this.frequency != 0) continue;
                this.callListeners(e);
            }
            if (e.steps % this.frequency == 0) continue;
            this.callListeners(e);
        }
        if (createTmpFile) {
            rw.close();
            fw.close();
        }
        return tmpFile;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Mode {
        ONE_PHASE,
        TWO_PHASES,
        N_PHASES;

    }

    public class LoaderEvent {
        public int objectType;
        public long objects;
        public Graph graph;
        public int phase;
        public int phases;
        public int partition;
        public int partitions;
        public int steps;

        public LoaderEvent() {
        }

        public LoaderEvent(LoaderEvent loaderEvent) {
            this.objectType = loaderEvent.objectType;
            this.objects = loaderEvent.objects;
            this.graph = loaderEvent.graph;
            this.phase = loaderEvent.phase;
            this.phases = loaderEvent.phases;
            this.partition = loaderEvent.partition;
            this.partitions = loaderEvent.partitions;
            this.steps = loaderEvent.steps;
        }
    }
}

