/*
 * Decompiled with CFR 0.152.
 */
package edu.upc.dama.dex.algorithms;

import edu.upc.dama.dex.core.Graph;
import edu.upc.dama.dex.core.Objects;
import edu.upc.dama.dex.core.Value;

public class ConnectedComponents {
    private Graph gr;
    private String name_attr;
    private long attr_component;

    public ConnectedComponents(Graph graph, String materializedattribute) {
        if (graph == null) {
            throw new NullPointerException("The graph can not be null.");
        }
        if (!graph.isOpen()) {
            throw new IllegalStateException("The graph has not been opened  yet.");
        }
        this.gr = graph;
        this.setMaterializedAttribute(materializedattribute);
    }

    public long getConnectedComponent(long idNode) {
        this.assertNode(idNode);
        Value result = this.gr.getAttribute(idNode, this.attr_component);
        if (result.isNull()) {
            throw new NullPointerException("There is no information about connected components associated with this node identifier.");
        }
        return result.getLong();
    }

    public long getCount() {
        Graph.AttributeData attr_data = this.gr.getAttributeData(this.attr_component);
        return attr_data.getSize();
    }

    public Objects getNodes(long idConnectedComponent) {
        Objects nodes = this.gr.select(this.attr_component, (short)3, new Value(idConnectedComponent));
        if (nodes.size() == 0) {
            throw new IllegalArgumentException("There is no connected component with the given identifer " + idConnectedComponent + ".");
        }
        return nodes;
    }

    public long getSize(long idConnectedComponent) {
        Objects nodes = this.getNodes(idConnectedComponent);
        long sizeCC = nodes.size();
        nodes.close();
        return sizeCC;
    }

    private void setMaterializedAttribute(String materializedattribute) {
        this.name_attr = materializedattribute;
        this.attr_component = this.gr.findAttribute(1, materializedattribute);
        if (this.attr_component == 0L) {
            throw new IllegalArgumentException("The given attribute identifier is not associated with any persistent result related to connected components");
        }
    }

    private void assertNode(long idNode) {
        if (!this.gr.existsNode(idNode)) {
            throw new IllegalArgumentException("The given node identifier " + idNode + "does not exist in " + "the graph.");
        }
    }
}

