/*
 * Decompiled with CFR 0.152.
 */
package edu.upc.dama.dex.algorithms;

import edu.upc.dama.dex.algorithms.Algorithm;
import edu.upc.dama.dex.algorithms.ConnectedComponents;
import edu.upc.dama.dex.core.Graph;
import edu.upc.dama.dex.core.Objects;
import edu.upc.dama.dex.core.Value;
import edu.upc.dama.dex.tasks.CompositeTask;
import java.util.HashSet;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Connectivity
extends CompositeTask
implements Algorithm {
    protected Graph gr;
    protected Set<Integer> aEdges;
    protected Set<Integer> aNodes;
    protected Objects nodesNotVisited;
    protected String name_attr_component;
    protected long attr_component;
    protected long actualComponent;
    protected boolean matResults;
    protected short direction;
    protected boolean computed = false;
    protected boolean closed = false;
    protected ConnectedComponents ccs;

    public Connectivity(Graph graph) {
        if (graph == null) {
            throw new NullPointerException("The graph can not be null.");
        }
        if (!graph.isOpen()) {
            throw new IllegalStateException("The graph has not been opened  yet.");
        }
        this.gr = graph;
        this.actualComponent = 0L;
        this.aEdges = new HashSet<Integer>();
        this.aNodes = new HashSet<Integer>();
        this.matResults = false;
        this.createGlobalTransientAttribute();
        this.ccs = new ConnectedComponents(this.gr, this.name_attr_component);
    }

    public void addAllEdges() {
        this.assertNotClosed();
        this.assertNotComputed();
        this.aEdges = this.gr.edgeTypes();
        if (this.aEdges.size() == 0) {
            this.close();
            throw new NoSuchElementException("There are no edges in the graph.");
        }
    }

    public void addEdge(int edgetype) {
        this.assertNotClosed();
        this.assertNotComputed();
        this.assertEdgeType(edgetype);
        this.aEdges.add(edgetype);
    }

    public void addAllNodes() {
        this.assertNotClosed();
        this.assertNotComputed();
        this.aNodes = this.gr.nodeTypes();
        if (this.aNodes.size() == 0) {
            this.close();
            throw new NoSuchElementException("There are no nodes in the graph.");
        }
    }

    public void addNode(int nodetype) {
        this.assertNotClosed();
        this.assertNotComputed();
        this.assertNodeType(nodetype);
        this.aNodes.add(nodetype);
    }

    public abstract void close();

    public ConnectedComponents getConnectedComponents() {
        this.assertNotClosed();
        this.assertComputed();
        return this.ccs;
    }

    public abstract void run() throws Throwable;

    public void setMaterializedAttribute(String nameattribute) {
        this.assertNotClosed();
        this.assertNotComputed();
        this.assertNotComponentAttribute(nameattribute);
        this.removeGlobalAttribute();
        this.matResults = true;
        this.createGlobalPersistentAttribute(nameattribute);
        this.ccs = new ConnectedComponents(this.gr, nameattribute);
    }

    protected void assertAddedEdges() {
        if (this.aEdges.isEmpty()) {
            this.close();
            throw new IllegalStateException("It is necessary to indicate which edges are allowed to navigate through while running this operation.");
        }
    }

    protected void assertAddedNodes() {
        if (this.aNodes.isEmpty()) {
            this.close();
            throw new IllegalStateException("It is necessary to indicate which nodes are allowed to navigate through while running this operation.");
        }
    }

    protected void assertNotComputed() {
        if (this.computed) {
            this.close();
            throw new IllegalStateException("The connectivity inspector has already been computed.");
        }
    }

    protected void assertNotClosed() {
        if (this.closed) {
            throw new IllegalStateException("The connectivity inspector has already been closed.");
        }
    }

    protected void setConnectedComponent(long idNode) {
        this.gr.setAttribute(idNode, this.attr_component, new Value(this.actualComponent));
    }

    protected void setNodesNotVisited() {
        this.nodesNotVisited = this.getNodesOfTypes(this.aNodes);
    }

    private void assertNotComponentAttribute(String nameattribute) {
        long attr = this.gr.findAttribute(1, nameattribute);
        if (attr != 0L) {
            this.close();
            throw new IllegalArgumentException("The given attribute identifier is already in use.");
        }
    }

    private void assertComputed() {
        if (!this.computed) {
            this.close();
            throw new IllegalStateException("The connectivity inspector has not been computed yet.");
        }
    }

    private void assertEdgeType(int edgetype) {
        boolean correct = false;
        try {
            correct = this.gr.isTypeEdge(edgetype);
            if (!correct) {
                this.close();
                throw new IllegalArgumentException("The given edge type " + edgetype + " is not correct.");
            }
        }
        catch (Exception e) {
            this.close();
            throw new IllegalArgumentException("The given edge type " + edgetype + " is not correct.");
        }
    }

    private void assertNodeType(int nodetype) {
        boolean correct = false;
        try {
            correct = this.gr.isTypeNode(nodetype);
            if (!correct) {
                this.close();
                throw new IllegalArgumentException("The given node type " + nodetype + " is not correct.");
            }
        }
        catch (Exception e) {
            this.close();
            throw new IllegalArgumentException("The given node type " + nodetype + " is not correct.");
        }
    }

    private void createGlobalPersistentAttribute(String nameattribute) {
        this.name_attr_component = nameattribute;
        this.attr_component = this.gr.newAttribute(1, nameattribute, (short)6, (short)2);
    }

    private void createGlobalTransientAttribute() {
        this.attr_component = this.gr.newTransientAttribute(1, (short)6, (short)2);
        this.name_attr_component = this.gr.getAttributeData(this.attr_component).getName();
    }

    private Objects getNodesOfTypes(Set<Integer> nodetypes) {
        Iterator<Integer> it = nodetypes.iterator();
        Objects nodesResult = new Objects(this.gr.getSession());
        while (it.hasNext()) {
            int nodetype = it.next();
            Objects nodes = this.gr.select(nodetype);
            nodesResult.union(nodes);
            nodes.close();
        }
        return nodesResult;
    }

    protected void removeGlobalAttribute() {
        if (this.attr_component == 0L) {
            throw new IllegalStateException("It has been impossible to close  all data.");
        }
        this.gr.removeAttribute(this.attr_component);
        this.attr_component = 0L;
    }
}

