/*
 * Decompiled with CFR 0.152.
 */
package edu.upc.dama.dex.algorithms;

import edu.upc.dama.dex.algorithms.SinglePairShortestPath;
import edu.upc.dama.dex.algorithms.navigation.WeightedEdgeNavigation;
import edu.upc.dama.dex.core.Graph;
import edu.upc.dama.dex.core.Objects;
import edu.upc.dama.dex.core.Value;
import edu.upc.dama.dex.utils.FibonacciHeap;
import edu.upc.dama.dex.utils.FibonacciHeapNode;
import java.util.HashMap;

public class SinglePairShortestPathDijkstra
extends SinglePairShortestPath {
    private FibonacciHeap<FibonacciHeapNode> queue = new FibonacciHeap();
    private Objects visitedSet = new Objects(this.gr.getSession());
    private int levelNodeFirstQueue;
    private double distNodeFirstQueue;
    private HashMap<Long, FibonacciHeapNode> nodesInQueue = new HashMap();
    private long pred_attr = 0L;
    private long dist_attr = 0L;

    public SinglePairShortestPathDijkstra(Graph graph, long source, long dest) {
        super(graph, source, dest);
        this.createTemporalAttrs();
    }

    public void addWeightedEdge(int edgetype, short navigation, long attributetype) {
        this.addWeightedEdge_(edgetype, navigation, attributetype);
    }

    public Double getCost() {
        this.assertNotClosed();
        this.assertComputed();
        if (this.computed && !this.existsShortestPath) {
            return new Double(-1.0);
        }
        return this.getDistance(this.dst);
    }

    public void close() {
        this.assertNotClosed();
        if (this.aEdges != null) {
            this.aEdges.clear();
        }
        if (this.queue != null) {
            this.queue.clear();
        }
        if (this.visitedSet != null && this.visitedSet.isOpen()) {
            this.visitedSet.close();
        }
        if (this.nodesInQueue != null) {
            this.nodesInQueue.clear();
        }
        this.dropAllTemporalAttrs();
        this.closed = true;
    }

    public void run() throws Throwable {
        this.assertNotClosed();
        this.assertNotComputed();
        this.assertAddedEdges();
        this.addInfoToNode(this.src, 0.0, 0, 0L);
        this.dijkstra();
        this.storeShortestPath();
        this.computed = true;
    }

    private void addInfoToNode(long idNode, double dist, int level, long idNodePred) {
        this.setDistance(idNode, dist);
        this.setPredecessor(idNode, idNodePred);
        if (this.nodesInQueue.containsKey(idNode)) {
            FibonacciHeapNode node = this.nodesInQueue.get(idNode);
            node.setLevel(level);
            this.queue.decreaseKey(node, dist);
        } else {
            FibonacciHeapNode node = new FibonacciHeapNode(idNode, dist, level);
            this.queue.insert(node, dist);
            this.nodesInQueue.put(idNode, node);
        }
    }

    private void createTemporalAttrs() {
        this.pred_attr = this.gr.newTransientAttribute(1, (short)6, (short)0);
        this.dist_attr = this.gr.newTransientAttribute(1, (short)3, (short)0);
    }

    private void dijkstra() {
        int nvisited = 0;
        while (!this.queue.isEmpty() && !this.existsShortestPath && (long)nvisited < this.gr.nodes()) {
            FibonacciHeapNode nodeMin = this.queue.removeMin();
            long idNodeMin = nodeMin.getData();
            this.nodesInQueue.remove(idNodeMin);
            this.distNodeFirstQueue = this.getDistance(idNodeMin);
            this.levelNodeFirstQueue = nodeMin.getLevel();
            boolean bl = this.existsShortestPath = idNodeMin == this.dst && this.distNodeFirstQueue != 0.0;
            if (this.existsShortestPath || this.visitedSet.exists(idNodeMin)) continue;
            ++nvisited;
            this.relaxNeighbors(idNodeMin);
            this.visitedSet.add(idNodeMin);
        }
    }

    private void dropAllTemporalAttrs() {
        if (this.pred_attr == 0L) {
            this.close();
            throw new IllegalStateException("Error while closing  the operation.");
        }
        this.gr.removeAttribute(this.pred_attr);
        if (this.dist_attr == 0L) {
            this.close();
            throw new IllegalStateException("Error while closing  the operation.");
        }
        this.gr.removeAttribute(this.dist_attr);
    }

    private long getDestinationNode(long idEdge, long sourceNode) {
        long[] headtail = this.gr.getEdge(idEdge);
        long destinationNode = 0L;
        if (headtail[0] == sourceNode) {
            destinationNode = headtail[1];
        } else if (headtail[1] == sourceNode) {
            destinationNode = headtail[0];
        }
        return destinationNode;
    }

    private Double getDistance(long idNode) {
        Value v = this.gr.getAttribute(idNode, this.dist_attr);
        if (v.isNull()) {
            return null;
        }
        return v.getDouble();
    }

    private long getEdge(long idTail, long idHead, int edgetype, short navigation) {
        switch (navigation) {
            case 1: {
                return this.gr.findEdge(idHead, idTail, edgetype);
            }
            case 2: {
                return this.gr.findEdge(idTail, idHead, edgetype);
            }
            case 3: {
                long idEdge = this.gr.findEdge(idTail, idHead, edgetype);
                if (idEdge == 0L) {
                    idEdge = this.gr.findEdge(idHead, idTail, edgetype);
                }
                return idEdge;
            }
        }
        throw new IllegalArgumentException("Navigation argument is not correct.");
    }

    private long getEdgeMinimumWeight(long idNode, long idNodePred) {
        long idEdgeMinimumWeight = 0L;
        double minimumWeight = Double.MAX_VALUE;
        for (WeightedEdgeNavigation edge : this.aEdges) {
            double weight;
            long idEdge = this.getEdge(idNodePred, idNode, edge.getType(), edge.getDirection());
            if (idEdge == 0L || !((weight = this.gr.getAttribute(idEdge, edge.getAttributeType()).getDouble()) < minimumWeight)) continue;
            minimumWeight = weight;
            idEdgeMinimumWeight = idEdge;
        }
        return idEdgeMinimumWeight;
    }

    private long getPredecessor(long idNode) {
        return this.gr.getAttribute(idNode, this.pred_attr).getLong();
    }

    private double getWeight(long idEdge, long attrtype) {
        short attrdata = this.gr.getAttributeData(attrtype).getDatatype();
        if (attrdata != 3 && attrdata != 6 && attrdata != 1) {
            this.close();
            throw new IllegalArgumentException("The given attribute type of edge which must contain the value of its weight is not an integer value, long value or double value.");
        }
        Value weight = this.gr.getAttribute(idEdge, attrtype);
        double weightD = attrdata == 6 ? new Long(weight.getLong()).doubleValue() : (attrdata == 1 ? new Integer(weight.getInt()).doubleValue() : weight.getDouble());
        if (weightD < 0.0) {
            this.close();
            throw new IllegalArgumentException("Graph has negative edges.");
        }
        return weightD;
    }

    private void relaxNeighbor(long idNode, long idNeighbor, double neighborWeight) {
        double newNeighborDist = this.distNodeFirstQueue + neighborWeight;
        int levelNeighbor = this.levelNodeFirstQueue + 1;
        Double neighborDist = this.getDistance(idNeighbor);
        if (neighborDist == null) {
            if (levelNeighbor <= this.MAX_HOPS || this.MAX_HOPS == -1) {
                this.addInfoToNode(idNeighbor, newNeighborDist, levelNeighbor, idNode);
            }
        } else if (neighborDist != null && (levelNeighbor <= this.MAX_HOPS || this.MAX_HOPS == -1)) {
            if (idNeighbor == this.dst && neighborDist == 0.0) {
                this.addInfoToNode(idNeighbor, newNeighborDist, levelNeighbor, idNode);
            } else if (neighborDist > newNeighborDist) {
                this.addInfoToNode(idNeighbor, newNeighborDist, levelNeighbor, idNode);
            }
        }
    }

    private void relaxNeighbors(long idNode) {
        for (WeightedEdgeNavigation edge : this.aEdges) {
            int type = edge.getType();
            short direction = edge.getDirection();
            long attrtype = edge.getAttributeType();
            Objects edgesOfaType = this.gr.explode(idNode, type, direction);
            Objects.Iterator neighborsIt = edgesOfaType.iterator();
            while (neighborsIt.hasNext()) {
                long idEdge = neighborsIt.next();
                double neighborWeight = this.getWeight(idEdge, attrtype);
                long idNeighbor = this.getDestinationNode(idEdge, idNode);
                this.relaxNeighbor(idNode, idNeighbor, neighborWeight);
            }
            neighborsIt.close();
            edgesOfaType.close();
        }
    }

    private void setDistance(long idNode, double distance) {
        this.gr.setAttribute(idNode, this.dist_attr, new Value(distance));
    }

    private void setPredecessor(long idNode, long idNodePred) {
        this.gr.setAttribute(idNode, this.pred_attr, new Value(idNodePred));
    }

    private void storeShortestPath() {
        if (!this.existsShortestPath) {
            return;
        }
        this.pathAsNodes = new long[this.levelNodeFirstQueue + 1];
        this.pathAsEdges = new long[this.levelNodeFirstQueue];
        this.pathAsNodes[this.levelNodeFirstQueue] = this.dst;
        long idNode = this.dst;
        for (int index = this.levelNodeFirstQueue - 1; index >= 0; --index) {
            long idEdge;
            long idNodePred;
            this.pathAsNodes[index] = idNodePred = this.getPredecessor(idNode);
            this.pathAsEdges[index] = idEdge = this.getEdgeMinimumWeight(idNode, idNodePred);
            idNode = idNodePred;
        }
    }
}

