/*
 * Decompiled with CFR 0.152.
 */
package edu.upc.dama.dex.algorithms;

import edu.upc.dama.dex.algorithms.StrongConnectivity;
import edu.upc.dama.dex.core.Graph;
import edu.upc.dama.dex.core.Objects;
import edu.upc.dama.dex.core.Value;
import java.util.Iterator;
import java.util.Stack;

public class StrongConnectivityGabow
extends StrongConnectivity {
    private Objects nodesStored;
    private Objects nodesVisited;
    private Stack<Long> stack1;
    private Stack<Long> stack2;
    private Stack<InfoNode> infoStack;
    private long index_attribute;
    private int index;

    public StrongConnectivityGabow(Graph graph) {
        super(graph);
        this.initialize();
    }

    public void close() {
        this.assertNotClosed();
        if (this.stack1 != null) {
            this.stack1.clear();
        }
        if (this.stack2 != null) {
            this.stack2.clear();
        }
        if (this.infoStack != null) {
            this.infoStack.clear();
        }
        if (this.aEdges != null) {
            this.aEdges.clear();
        }
        if (this.aNodes != null) {
            this.aNodes.clear();
        }
        if (this.index_attribute != 0L) {
            this.dropAuxiliaryTransientAttribute();
        }
        if (this.nodesStored != null && this.nodesStored.isOpen()) {
            this.nodesStored.close();
        }
        if (this.nodesVisited != null && this.nodesVisited.isOpen()) {
            this.nodesVisited.close();
        }
        if (this.nodesNotVisited != null && this.nodesNotVisited.isOpen()) {
            this.nodesNotVisited.close();
        }
        if (!this.matResults) {
            this.removeGlobalAttribute();
        }
        this.closed = true;
    }

    public void run() {
        this.assertNotClosed();
        this.assertNotComputed();
        this.assertAddedEdges();
        this.assertAddedNodes();
        this.setNodesNotVisited();
        long sizeNodesNotVisited = this.nodesNotVisited.size();
        boolean bl = this.computed = this.nodesNotVisited.size() == 0;
        while (!this.computed) {
            Objects.Iterator it = this.nodesNotVisited.iterator();
            if (it.hasNext()) {
                long idNode = it.next();
                this.gabow(idNode);
                this.prepareNextGabow(sizeNodesNotVisited, it);
            }
            it.close();
        }
        this.computed = true;
    }

    private void createAuxiliaryTransientAttribute() {
        this.index_attribute = this.gr.newTransientAttribute(1, (short)1, (short)0);
    }

    private void dropAuxiliaryTransientAttribute() {
        this.gr.removeAttribute(this.index_attribute);
        this.index_attribute = 0L;
    }

    private void gabow(long idNode) {
        InfoNode info = new InfoNode(idNode, idNode, true);
        this.infoStack.push(info);
        while (!this.infoStack.isEmpty()) {
            InfoNode infoPoped = this.infoStack.pop();
            long idNodePoped = infoPoped.getIdNode();
            long idNodePredPoped = infoPoped.getIdNodPred();
            boolean mustBePoped = infoPoped.isNeededTobePoped();
            if (!this.isVisited(idNodePoped)) {
                this.setInfoToNodeNotVisited(idNodePoped, idNodePredPoped);
                continue;
            }
            if (!mustBePoped) {
                if (this.hasBeenStored(idNodePoped)) continue;
                long peekStack2 = this.stack2.peek();
                int indexPoped = this.getIndex(idNodePoped).getInt();
                int indexPeekStack2 = this.getIndex(peekStack2).getInt();
                while (indexPoped < indexPeekStack2) {
                    this.stack2.pop();
                    peekStack2 = this.stack2.peek();
                    indexPeekStack2 = this.getIndex(peekStack2).getInt();
                }
                continue;
            }
            if (this.stack2.peek() != idNodePoped) continue;
            this.storeStronglyConnectedComponent(idNodePoped);
        }
    }

    private boolean hasBeenStored(long idNode) {
        return this.nodesStored.exists(idNode);
    }

    private void initialize() {
        this.stack1 = new Stack();
        this.stack2 = new Stack();
        this.index = 0;
        this.infoStack = new Stack();
        this.direction = (short)2;
        this.nodesStored = new Objects(this.gr.getSession());
        this.nodesVisited = new Objects(this.gr.getSession());
        this.createAuxiliaryTransientAttribute();
    }

    private boolean isVisited(long idNode) {
        return this.nodesVisited.exists(idNode);
    }

    private void prepareNextGabow(long sizeNodesNotVisited, Objects.Iterator it) {
        if (this.nodesNotVisited.size() != 0) {
            if (sizeNodesNotVisited != (long)this.nodesNotVisited.size()) {
                it.close();
                it = this.nodesNotVisited.iterator();
            }
        } else {
            this.computed = true;
        }
    }

    private void setInfoToNodeNotVisited(long idNodePoped, long idNodePredPoped) {
        this.setIndex(idNodePoped, this.index);
        ++this.index;
        this.stack1.push(idNodePoped);
        this.stack2.push(idNodePoped);
        this.nodesVisited.add(idNodePoped);
        InfoNode info = new InfoNode(idNodePoped, idNodePredPoped, true);
        this.infoStack.push(info);
        Iterator aEdgesIt = this.aEdges.iterator();
        while (aEdgesIt.hasNext()) {
            this.visitNeighborsOfAType(idNodePoped, (Integer)aEdgesIt.next());
        }
    }

    private void setIndex(long idNode, int index) {
        this.gr.setAttribute(idNode, this.index_attribute, new Value(index));
    }

    private Value getIndex(long idNode) {
        return this.gr.getAttribute(idNode, this.index_attribute);
    }

    private void storeStronglyConnectedComponent(long idNode) {
        this.stack2.pop();
        long idNodePoped = this.stack1.pop();
        this.setConnectedComponent(idNodePoped);
        this.nodesNotVisited.remove(idNodePoped);
        this.nodesStored.add(idNodePoped);
        while (idNodePoped != idNode) {
            idNodePoped = this.stack1.pop();
            this.setConnectedComponent(idNodePoped);
            this.nodesNotVisited.remove(idNodePoped);
            this.nodesStored.add(idNodePoped);
        }
        ++this.actualComponent;
    }

    private void visitNeighborsOfAType(long idNode, int edgetype) {
        Objects neighbors = this.gr.neighbors(idNode, edgetype, (short)2);
        Objects.Iterator neighborsIt = neighbors.iterator();
        while (neighborsIt.hasNext()) {
            long idNeighbor = neighborsIt.next();
            if (!this.nodesNotVisited.exists(idNeighbor)) continue;
            this.visitNeighbor(idNode, idNeighbor);
        }
        neighborsIt.close();
        neighbors.close();
    }

    private void visitNeighbor(long idNode, long idNeighbor) {
        InfoNode info = new InfoNode(idNeighbor, idNode, false);
        this.infoStack.push(info);
    }

    private class InfoNode {
        private long idNod;
        private long idNodPred;
        private boolean isNeededToBePop;

        public InfoNode(long idNode, long idNodePred, boolean isNeededToBePoped) {
            this.idNod = idNode;
            this.idNodPred = idNodePred;
            this.isNeededToBePop = isNeededToBePoped;
        }

        public long getIdNode() {
            return this.idNod;
        }

        public long getIdNodPred() {
            return this.idNodPred;
        }

        public boolean isNeededTobePoped() {
            return this.isNeededToBePop;
        }
    }
}

