/*
 * Decompiled with CFR 0.152.
 */
package edu.upc.dama.dex.algorithms;

import edu.upc.dama.dex.algorithms.Algorithm;
import edu.upc.dama.dex.algorithms.navigation.EdgeNavigation;
import edu.upc.dama.dex.algorithms.navigation.UnweightedEdgeNavigation;
import edu.upc.dama.dex.core.Graph;
import java.util.HashSet;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Traversal
implements Iterator<Long>,
Algorithm {
    protected Graph gr;
    protected long src;
    protected Set<EdgeNavigation> aEdges;
    protected Set<Integer> aNodes;
    protected boolean closed = false;
    protected boolean parametersChecked = false;

    public Traversal(Graph graph, long source) {
        if (graph == null) {
            throw new NullPointerException("The graph can not be null.");
        }
        if (!graph.isOpen()) {
            throw new IllegalStateException("The graph has not been opened  yet.");
        }
        this.gr = graph;
        this.assertNode(source);
        this.src = source;
        this.aEdges = new HashSet<EdgeNavigation>();
        this.aNodes = new HashSet<Integer>();
    }

    public void addEdge(int edgetype, short navigation) {
        UnweightedEdgeNavigation edge;
        this.assertNotClosed();
        this.assertNotStartedTraversing();
        this.assertNotAddedEdgeType(edgetype);
        try {
            edge = new UnweightedEdgeNavigation(this.gr, edgetype, navigation);
        }
        catch (IllegalArgumentException ex) {
            this.close();
            throw ex;
        }
        this.aEdges.add(edge);
        this.addInfoToAuxiliarStructure(edge);
    }

    public void addAllEdges(short navigation) {
        this.assertNotClosed();
        this.assertNotStartedTraversing();
        Set<Integer> edgetypes = this.gr.edgeTypes();
        if (edgetypes.size() == 0) {
            this.close();
            throw new NoSuchElementException("There are no edges added in the graph.");
        }
        for (int edgetype : edgetypes) {
            this.addEdge(edgetype, navigation);
        }
        this.setInfoToAuxiliarStructure();
    }

    public void addNode(int nodetype) {
        this.assertNotClosed();
        this.assertNotStartedTraversing();
        this.assertNodeType(nodetype);
        this.aNodes.add(nodetype);
    }

    public void addAllNodes() {
        this.assertNotClosed();
        this.assertNotStartedTraversing();
        Set<Integer> nodetypes = this.gr.nodeTypes();
        if (nodetypes.size() == 0) {
            this.close();
            throw new NoSuchElementException("There are no nodes added in the graph.");
        }
        for (int nodetype : nodetypes) {
            this.addNode(nodetype);
        }
    }

    public abstract void close();

    protected void assertInitialized() {
        this.assertAddedEdges();
        this.assertAddedNodes();
        this.assertSourceNode();
    }

    protected void assertNotClosed() {
        if (this.closed) {
            throw new IllegalStateException("The graph traversal has already been closed.");
        }
    }

    protected abstract void addInfoToAuxiliarStructure(EdgeNavigation var1);

    protected abstract void setInfoToAuxiliarStructure();

    private void assertAddedEdges() {
        if (this.aEdges.isEmpty()) {
            this.close();
            throw new IllegalArgumentException("It is necessary to indicate which edges are allowed to navigate through while calculating the shortest path.");
        }
    }

    private void assertAddedNodes() {
        if (this.aNodes.isEmpty()) {
            this.close();
            throw new IllegalArgumentException("It is necessary to indicate which nodes are allowed to navigate through while calculating the shortest path.");
        }
    }

    private void assertNode(long node) {
        if (node == 0L) {
            this.close();
            throw new IllegalArgumentException("The given node identifier " + node + " doesn't exist.");
        }
    }

    private void assertNodeType(int nodetype) {
        Set<Integer> nodetypes = this.gr.nodeTypes();
        if (!nodetypes.contains(nodetype)) {
            this.close();
            throw new IllegalArgumentException("The given node type " + nodetype + " is not correct.");
        }
    }

    private void assertNotAddedEdgeType(int edgetype) {
        for (EdgeNavigation edge : this.aEdges) {
            int etype = edge.getType();
            if (etype != edgetype) continue;
            this.close();
            throw new IllegalArgumentException("The given edge type identifier " + edgetype + " has already been added.");
        }
    }

    private void assertNotStartedTraversing() {
        if (this.parametersChecked) {
            this.close();
            throw new IllegalStateException("The graph traversal has already been started.");
        }
    }

    private void assertSourceNode() {
        int sourcetype = this.gr.getType(this.src);
        if (!this.aNodes.contains(sourcetype)) {
            this.close();
            throw new IllegalArgumentException("The type of the given source is not contained in the set of node types allowed");
        }
    }
}

