/*
 * Decompiled with CFR 0.152.
 */
package edu.upc.dama.dex.algorithms;

import edu.upc.dama.dex.algorithms.TraversalDFS;
import edu.upc.dama.dex.algorithms.WeakConnectivity;
import edu.upc.dama.dex.core.Graph;
import java.util.Iterator;

public class WeakConnectivityDFS
extends WeakConnectivity {
    public WeakConnectivityDFS(Graph graph) {
        super(graph);
        this.direction = (short)3;
    }

    public void close() {
        this.assertNotClosed();
        if (this.aEdges != null) {
            this.aEdges.clear();
        }
        if (this.aNodes != null) {
            this.aNodes.clear();
        }
        if (this.nodesNotVisited != null && this.nodesNotVisited.isOpen()) {
            this.nodesNotVisited.close();
        }
        if (!this.matResults) {
            this.removeGlobalAttribute();
        }
        this.closed = true;
    }

    public void run() {
        this.assertNotClosed();
        this.assertNotComputed();
        this.assertAddedEdges();
        this.assertAddedNodes();
        this.setNodesNotVisited();
        while (this.nodesNotVisited.size() != 0) {
            long idNode = this.nodesNotVisited.first();
            this.computeDFS(idNode);
            ++this.actualComponent;
        }
        this.computed = true;
    }

    private void computeDFS(long idNode) {
        TraversalDFS dfs = null;
        dfs = new TraversalDFS(this.gr, idNode);
        Iterator it = this.aEdges.iterator();
        while (it.hasNext()) {
            int edge = (Integer)it.next();
            dfs.addEdge(edge, this.direction);
        }
        it = this.aNodes.iterator();
        while (it.hasNext()) {
            int node = (Integer)it.next();
            dfs.addNode(node);
        }
        while (dfs.hasNext()) {
            long idNodeNext = dfs.next();
            this.setConnectedComponent(idNodeNext);
            this.nodesNotVisited.remove(idNodeNext);
        }
        dfs.close();
    }
}

