/*
 * Decompiled with CFR 0.152.
 */
package edu.upc.dama.dex.core;

import com.sparsity.dex.gdb.Database;
import com.sparsity.dex.gdb.DatabaseStatistics;
import edu.upc.dama.dex.core.DEX;
import edu.upc.dama.dex.core.DbGraph;
import edu.upc.dama.dex.core.Graph;
import edu.upc.dama.dex.core.Session;
import edu.upc.dama.dex.core.Value;
import edu.upc.dama.dex.utils.StringLib;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Writer;
import java.util.Iterator;
import java.util.Set;

public final class GraphPool
implements Closeable {
    private Database handle = null;
    private DEX dex = null;
    private String alias = null;
    private File img = null;

    GraphPool(DEX dex, Database handle) {
        this.dex = dex;
        this.handle = handle;
        assert (handle != null);
    }

    public Database getHandle() {
        return this.handle;
    }

    public boolean isOpen() {
        return this.handle != null;
    }

    public void close() {
        if (this.isOpen()) {
            this.dex.unregister(this);
            this.handle.close();
            this.handle = null;
            this.dex = null;
        }
    }

    public DEX getDEX() {
        return this.dex;
    }

    @Deprecated
    public void warmUp() {
    }

    public Session newSession() {
        return new Session(this, this.handle.newSession());
    }

    public String getAlias() {
        if (this.alias == null) {
            this.alias = this.handle.getAlias();
        }
        return this.alias;
    }

    public File getFileImage() {
        if (this.img == null) {
            this.img = new File(this.handle.getPath());
        }
        return this.img;
    }

    public void dumpStorage(Session sess, File file) throws FileNotFoundException {
        sess.getHandle().getGraph().dumpStorage(file.getPath());
    }

    public void dumpData(Session sess, File file) throws FileNotFoundException {
        sess.getHandle().getGraph().dumpData(file.getPath());
    }

    public void dumpStorage(Session sess, String file) throws FileNotFoundException {
        sess.getHandle().getGraph().dumpStorage(file);
    }

    public void dumpData(Session sess, String file) throws FileNotFoundException {
        sess.getHandle().getGraph().dumpData(file);
    }

    public void dumpSchema(Session sess, Writer writer) throws IOException {
        DbGraph dbg = sess.getDbGraph();
        writer.write("CREATE DBGRAPH " + StringLib.quote(this.getAlias()) + " INTO '" + this.getFileImage().getPath() + "'\n");
        for (int type : dbg.nodeTypes()) {
            Graph.TypeData tdata = dbg.getTypeData(type);
            writer.write("CREATE NODE " + StringLib.quote(tdata.getName()));
            Set<Long> attrs = dbg.getAttributesFromType(type);
            Iterator<Long> itAttrs = attrs.iterator();
            if (itAttrs.hasNext()) {
                writer.write(" ( ");
                int j = 0;
                while (itAttrs.hasNext()) {
                    long attr = itAttrs.next();
                    Graph.AttributeData adata = dbg.getAttributeData(attr);
                    writer.write(StringLib.quote(adata.getName()) + " " + Value.getTypeName(adata.getDatatype()));
                    switch (adata.getKind()) {
                        case 1: {
                            writer.write(" UNIQUE");
                            break;
                        }
                        case 2: {
                            writer.write(" INDEXED");
                        }
                    }
                    writer.write(j < attrs.size() - 1 ? ", " : " ");
                    ++j;
                }
                writer.write(")");
            }
            writer.write("\n");
        }
        for (int type : dbg.edgeTypes()) {
            Set<Long> attrs;
            Iterator<Long> itAttrs;
            Graph.TypeData tdata = dbg.getTypeData(type);
            writer.write("CREATE ");
            if (tdata.isUndirected()) {
                writer.write("UNDIRECTED ");
            }
            writer.write("EDGE " + StringLib.quote(tdata.getName()));
            if (tdata.isRestricted()) {
                int[] types = tdata.getRestricted();
                writer.write(" FROM " + StringLib.quote(dbg.getTypeData(types[0]).getName()) + " TO " + StringLib.quote(dbg.getTypeData(types[1]).getName()));
            }
            if ((itAttrs = (attrs = dbg.getAttributesFromType(type)).iterator()).hasNext()) {
                writer.write(" ( ");
                int j = 0;
                while (itAttrs.hasNext()) {
                    long attr = itAttrs.next();
                    Graph.AttributeData adata = dbg.getAttributeData(attr);
                    writer.write(StringLib.quote(adata.getName()) + " " + Value.getTypeName(adata.getDatatype()));
                    switch (adata.getKind()) {
                        case 1: {
                            writer.write(" UNIQUE");
                            break;
                        }
                        case 2: {
                            writer.write(" INDEXED");
                        }
                    }
                    writer.write(j < attrs.size() - 1 ? ", " : " ");
                    ++j;
                }
                writer.write(")");
            }
            if (tdata.hasNeighbors()) {
                writer.write(" MATERIALIZE NEIGHBORS");
            }
            writer.write("\n");
        }
        writer.flush();
    }

    @Deprecated
    public void flush() {
    }

    public Statistics getStatistics() {
        DatabaseStatistics ds = new DatabaseStatistics();
        this.handle.getStatistics(ds);
        Statistics st = new Statistics();
        st.cache = ds.getCache();
        st.data = ds.getData();
        st.in = ds.getRead();
        st.out = ds.getWrite();
        st.temp = ds.getTemp();
        return st;
    }

    public class Statistics {
        public long in = 0L;
        public long out = 0L;
        public long data = 0L;
        public long cache = 0L;
        public long temp = 0L;
    }
}

