/*
 * Decompiled with CFR 0.152.
 */
package edu.upc.dama.dex.io;

import edu.upc.dama.dex.io.RowReader;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;

public class JDBCReader
implements RowReader {
    private ResultSetMetaData rsmd;
    private ResultSet result;
    private int numColumns;

    public JDBCReader(String driverUrl, String protocol, String database, String query) throws IOException {
        this(driverUrl, "jdbc:" + protocol + database, null, null, query, false);
    }

    public JDBCReader(String driverUrl, String url, String query) throws IOException {
        this(driverUrl, url, null, null, query, false);
    }

    public JDBCReader(String driverUrl, String url, String user, String password, String query) throws IOException {
        this(driverUrl, url, user, password, query, true);
    }

    private JDBCReader(String driverUrl, String url, String user, String password, String query, boolean usingUser) throws IOException {
        try {
            Class.forName(driverUrl);
        }
        catch (ClassNotFoundException ex) {
            System.out.println(ex.toString());
        }
        try {
            Connection con = usingUser ? DriverManager.getConnection(url, user, password) : DriverManager.getConnection(url);
            Statement select = con.createStatement();
            this.result = select.executeQuery(query);
            this.rsmd = this.result.getMetaData();
            this.numColumns = this.rsmd.getColumnCount();
        }
        catch (SQLException ex) {
            throw new IOException("SQL Exception:" + ex.getMessage());
        }
    }

    public boolean reset() throws IOException {
        try {
            this.result.beforeFirst();
            return true;
        }
        catch (SQLException ex) {
            throw new IOException("SQL Exception:" + ex.getMessage());
        }
    }

    public String[] readNext() throws IOException {
        String[] ret = null;
        try {
            if (this.result.next()) {
                ret = new String[this.numColumns];
                for (int i = 1; i <= this.numColumns; ++i) {
                    ret[i - 1] = this.result.getString(i);
                }
            }
        }
        catch (SQLException ex) {
            throw new IOException("SQL Exception:" + ex.getMessage());
        }
        return ret;
    }

    public void close() throws IOException {
        try {
            this.result.close();
        }
        catch (SQLException ex) {
            throw new IOException("SQL Exception:" + ex.getMessage());
        }
    }

    public int getRow() throws IOException {
        try {
            return this.result.getRow();
        }
        catch (SQLException ex) {
            throw new IOException("SQL Exception:" + ex.getMessage());
        }
    }
}

