/*
 * Decompiled with CFR 0.152.
 */
package edu.upc.dama.dex.monitor;

import edu.upc.dama.dex.core.DEX;
import edu.upc.dama.dex.core.DbGraph;
import edu.upc.dama.dex.core.GraphPool;
import edu.upc.dama.dex.core.Session;
import edu.upc.dama.dex.core.Value;
import edu.upc.dama.dex.monitor.AdministrationMBean;
import edu.upc.dama.dex.monitor.MBeanUtils;
import edu.upc.dama.dex.monitor.proxy.AttributeDataProxy;
import edu.upc.dama.dex.script.ScriptParser;
import java.io.File;
import java.io.StringReader;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.management.NotificationBroadcasterSupport;

public class Administration
extends NotificationBroadcasterSupport
implements AdministrationMBean {
    private DEX dex;
    private MBeanUtils utils;

    public Administration(DEX dex) {
        this.dex = dex;
        this.utils = new MBeanUtils(dex);
    }

    public void execute(String script) throws Exception {
        try {
            GraphPool gpool;
            String pattern = "\\.*(dbgraph\\s+)*(\\w*)\\s*into\\s*\\'([\\w|.|\\|/|:]*)\\.*";
            Pattern p = Pattern.compile(pattern, 2);
            Matcher m = p.matcher(script);
            if (m.find()) {
                String alias = m.group(2);
                String file = m.group(3);
                File fileObject = new File(file);
                StringReader reader = new StringReader(script);
                ScriptParser ps = new ScriptParser(this.dex, reader);
                ps.parse(true);
                gpool = this.utils.getGraphPool(alias);
                if (gpool == null) {
                    gpool = this.dex.open(fileObject);
                }
            } else {
                throw new Exception("Invalid script sintax");
            }
            gpool.flush();
        }
        catch (Exception e) {
            throw new Exception(e);
        }
    }

    public void removeType(String graph, String type) {
        GraphPool gpool = this.utils.getGraphPool(graph);
        Session sess = gpool.newSession();
        DbGraph dbgraph = sess.getDbGraph();
        int typeCode = dbgraph.findType(type);
        if (typeCode != 0) {
            dbgraph.removeType(typeCode);
        }
        sess.close();
    }

    public void newNodeType(String graph, String type) {
        GraphPool gpool = this.utils.getGraphPool(graph);
        Session sess = gpool.newSession();
        DbGraph dbgraph = sess.getDbGraph();
        int typeCode = dbgraph.findType(type);
        if (typeCode == 0) {
            dbgraph.newNodeType(type);
        }
        sess.close();
    }

    public void newEdgeType(String graph, String type, boolean isDirected, boolean isRestricted, String[] src, String[] trg) {
        GraphPool gpool = this.utils.getGraphPool(graph);
        Session sess = gpool.newSession();
        DbGraph dbgraph = sess.getDbGraph();
        int typeCode = dbgraph.findType(type);
        if (typeCode == 0) {
            if (isRestricted) {
                int typeTail = dbgraph.findType(src[0]);
                int typeHead = dbgraph.findType(trg[0]);
                dbgraph.newRestrictedEdgeType(type, typeTail, typeHead);
            } else {
                dbgraph.newEdgeType(type, isDirected);
            }
            gpool.flush();
        }
        sess.close();
    }

    public void newAttribute(String graph, AttributeDataProxy attrData) {
        GraphPool gpool = this.utils.getGraphPool(graph);
        Session sess = gpool.newSession();
        DbGraph dbgraph = sess.getDbGraph();
        if ("".equals(attrData.name)) {
            dbgraph.newTransientAttribute(attrData.type, attrData.datatype, attrData.kind);
        } else {
            dbgraph.newAttribute(attrData.type, attrData.name, attrData.datatype, attrData.kind);
        }
        sess.close();
    }

    public void newAttribute(String graph, String type, String attrName, String datatype) {
        this.newAttribute(graph, type, null, attrName, datatype);
    }

    public void newAttribute(String graph, String type, Short attrType, String attrName, String dataType) {
        GraphPool gpool = this.utils.getGraphPool(graph);
        Session sess = gpool.newSession();
        DbGraph dbgraph = sess.getDbGraph();
        short datatype = Value.getType(dataType);
        int typeId = dbgraph.findType(type);
        if (typeId != 0) {
            if (attrName != null && !"".equalsIgnoreCase(attrName)) {
                long attrId = dbgraph.findAttribute(typeId, attrName);
                if (attrId == 0L) {
                    if (attrType != null) {
                        dbgraph.newAttribute(typeId, attrName, datatype, attrType);
                    } else {
                        dbgraph.newAttribute(typeId, attrName, datatype);
                    }
                }
            } else if (attrType != null) {
                dbgraph.newTransientAttribute(typeId, datatype, attrType);
            } else {
                dbgraph.newTransientAttribute(typeId, datatype);
            }
            gpool.flush();
        }
        sess.close();
    }

    public void removeAttribute(String graph, String typename, String attribute) {
        long attr;
        GraphPool gpool = this.utils.getGraphPool(graph);
        Session sess = gpool.newSession();
        DbGraph dbgraph = sess.getDbGraph();
        int type = dbgraph.findType(typename);
        if (type != 0 && (attr = dbgraph.findAttribute(type, attribute)) != 0L) {
            dbgraph.removeAttribute(attr);
        }
        gpool.flush();
        sess.close();
    }
}

