/*
 * Decompiled with CFR 0.152.
 */
package edu.upc.dama.dex.monitor;

import edu.upc.dama.dex.core.DEX;
import edu.upc.dama.dex.core.GraphPool;
import edu.upc.dama.dex.monitor.MBeanUtils;
import edu.upc.dama.dex.monitor.StatisticsMBean;
import edu.upc.dama.dex.monitor.proxy.DEXStatistics;
import edu.upc.dama.dex.monitor.proxy.GraphPoolStatistics;
import edu.upc.dama.dex.monitor.proxy.MemoryStatistics;
import edu.upc.dama.dex.monitor.proxy.ServerStatistics;
import edu.upc.dama.dex.utils.DEXConfig;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Set;
import javax.management.NotificationBroadcasterSupport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Statistics
extends NotificationBroadcasterSupport
implements StatisticsMBean {
    private DEX dex;
    private MBeanUtils utils;

    public Statistics(DEX dex) {
        this.dex = dex;
        this.utils = new MBeanUtils(dex);
    }

    @Override
    public ArrayList<String> getGraphPoolAlias() {
        ArrayList<String> gpAlias = new ArrayList<String>();
        Set<GraphPool> gps = this.dex.getGraphPools();
        int i = 0;
        for (GraphPool gp : gps) {
            String alias = gp.getAlias();
            if (alias == null) {
                alias = "GP" + i;
            }
            gpAlias.add(alias);
            ++i;
        }
        return gpAlias;
    }

    @Override
    public GraphPoolStatistics getGraphPoolStatistics(String graph) {
        GraphPool gpool = this.utils.getGraphPool(graph);
        return new GraphPoolStatistics(gpool.getStatistics());
    }

    @Override
    public DEXStatistics getSystemStatistics() {
        return new DEXStatistics(DEX.getSystemStatistics());
    }

    @Override
    public ServerStatistics getServerStatistics() {
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("java.runtime.name", System.getProperty("java.runtime.name"));
        properties.put("java.vm.name", System.getProperty("java.vm.name"));
        properties.put("java.vm.vendor", System.getProperty("java.vm.vendor"));
        properties.put("os.arch", System.getProperty("os.arch"));
        properties.put("os.name", System.getProperty("os.name"));
        properties.put("os.version", System.getProperty("os.version"));
        properties.put("dex.version", DEX.getVersion());
        properties.put("user.dir", System.getProperty("user.dir"));
        properties.put("system.cpu.count", String.valueOf(Runtime.getRuntime().availableProcessors()));
        try {
            String hostname = InetAddress.getLocalHost().getHostName();
            Integer port = DEXConfig.getInt("dex.monitor.port");
            String url = hostname + ":" + port;
            properties.put("dex.url", url);
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        return new ServerStatistics(properties);
    }

    @Override
    public MemoryStatistics getMemoryStatistics() {
        HashMap<String, Long> properties = new HashMap<String, Long>();
        properties.put("system.memory.free", Runtime.getRuntime().freeMemory());
        properties.put("system.memory.max", Runtime.getRuntime().maxMemory());
        properties.put("system.memory.total", Runtime.getRuntime().totalMemory());
        return new MemoryStatistics(properties);
    }
}

