/*
 * Decompiled with CFR 0.152.
 */
package edu.upc.dama.dex.shell;

import edu.upc.dama.dex.core.DbGraph;
import edu.upc.dama.dex.shell.Shell;
import java.io.IOException;
import java.io.PipedReader;
import java.io.PipedWriter;
import java.io.Writer;

public class CommandShell
implements Runnable {
    private Shell shell;
    private PipedWriter wReader;

    public CommandShell(DbGraph graph, Writer writer) throws IOException {
        PipedReader reader = new PipedReader();
        this.wReader = new PipedWriter(reader);
        this.shell = new Shell(graph, reader, writer);
    }

    public boolean workToDo() {
        return this.shell.workToDo();
    }

    public void runCommand(String command) throws IOException {
        this.wReader.write(command);
        this.shell.work();
    }

    public void stopCommand() {
        this.shell.stopCommand();
    }

    public void run() {
        try {
            this.shell.start();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void close() throws IOException {
        this.runCommand("quit\n");
    }
}

