/*
 * Decompiled with CFR 0.152.
 */
package edu.upc.dama.dex.shell;

import edu.upc.dama.dex.core.Attribute;
import edu.upc.dama.dex.core.DEX;
import edu.upc.dama.dex.core.DbGraph;
import edu.upc.dama.dex.core.Graph;
import edu.upc.dama.dex.core.GraphPool;
import edu.upc.dama.dex.core.Objects;
import edu.upc.dama.dex.core.Session;
import edu.upc.dama.dex.core.TextStream;
import edu.upc.dama.dex.core.Value;
import edu.upc.dama.dex.shell.ParseException;
import edu.upc.dama.dex.shell.ShellConstants;
import edu.upc.dama.dex.shell.ShellTokenManager;
import edu.upc.dama.dex.shell.SimpleCharStream;
import edu.upc.dama.dex.shell.Token;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeMap;
import java.util.Vector;

public class Shell
implements ShellConstants {
    static DbGraph dbg;
    int arrayType = -1;
    static TreeMap<String, Value> globals;
    private Writer writer;
    private BufferedWriter bw;
    private int MAX;
    private boolean work;
    private boolean printResults;
    public ShellTokenManager token_source;
    SimpleCharStream jj_input_stream;
    public Token token;
    public Token jj_nt;
    private int jj_ntk;
    private int jj_gen;
    private final int[] jj_la1 = new int[27];
    private static int[] jj_la1_0;
    private static int[] jj_la1_1;
    private static int[] jj_la1_2;
    private Vector jj_expentries = new Vector();
    private int[] jj_expentry;
    private int jj_kind = -1;

    public Shell(DbGraph dbgraph, Reader reader, Writer writer) throws IOException {
        this(reader);
        this.writer = writer;
        dbg = dbgraph;
        this.bw = new BufferedWriter(writer);
        globals.put("values", new Value(true));
        globals.put("maxsize", new Value(30));
        this.MAX = 0;
        this.work = false;
        this.printResults = true;
    }

    public boolean workToDo() {
        return this.work;
    }

    public void stopCommand() {
        this.printResults = false;
    }

    public void work() {
        this.work = true;
    }

    public void close() throws IOException {
        this.bw.close();
        dbg = null;
    }

    public static void main(String[] args) {
        if (args.length == 1) {
            try {
                int result;
                DEX dex = new DEX();
                GraphPool gp = dex.open(args[0]);
                Session sess = gp.newSession();
                dbg = sess.getDbGraph();
                do {
                    result = -1;
                    try {
                        InputStreamReader reader = new InputStreamReader(System.in);
                        OutputStreamWriter writer = new OutputStreamWriter(System.out);
                        Shell parser = new Shell(dbg, reader, writer);
                        result = parser.start();
                        reader.close();
                        writer.close();
                    }
                    catch (ParseException ex) {
                        System.out.println("Error parser");
                        System.out.println(ex.getMessage().split("\n")[0]);
                        System.out.println("Use 'help' to see the options.");
                    }
                    catch (NumberFormatException ex) {
                        System.out.println("Error number format");
                        System.out.println(ex.getMessage());
                    }
                    catch (Exception ex) {
                        System.out.println("Exception");
                        System.out.println(ex.getMessage());
                    }
                } while (result != 0);
                sess.close();
                gp.close();
                dex.close();
            }
            catch (IOException ex) {
                System.out.println(ex.getMessage());
            }
        } else {
            System.out.println("Wrong number of arguments. Only need one argument, a path of someone DEX image.");
        }
    }

    public final int start() throws ParseException, NumberFormatException, IOException {
        this.MAX = 40;
        int ret = 0;
        ret = this.startConsole();
        return ret;
    }

    public final int startConsole() throws ParseException, NumberFormatException, IOException {
        int a = 1;
        this.bw.write("\n>> ");
        this.bw.flush();
        block6: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 2: 
                case 21: 
                case 22: 
                case 23: 
                case 24: 
                case 25: 
                case 26: 
                case 27: 
                case 28: 
                case 29: 
                case 30: 
                case 31: 
                case 32: 
                case 33: 
                case 34: 
                case 35: 
                case 36: 
                case 39: 
                case 40: 
                case 41: 
                case 42: 
                case 43: 
                case 44: 
                case 45: 
                case 46: 
                case 47: 
                case 51: 
                case 62: 
                case 63: 
                case 66: {
                    break;
                }
                default: {
                    this.jj_la1[0] = this.jj_gen;
                    break block6;
                }
            }
            block7: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 21: 
                    case 22: 
                    case 23: 
                    case 24: 
                    case 25: 
                    case 26: 
                    case 27: 
                    case 28: 
                    case 29: 
                    case 30: 
                    case 31: 
                    case 32: 
                    case 33: 
                    case 34: 
                    case 35: 
                    case 36: 
                    case 39: 
                    case 40: 
                    case 41: 
                    case 42: 
                    case 43: 
                    case 44: 
                    case 45: 
                    case 46: 
                    case 47: 
                    case 51: 
                    case 62: 
                    case 63: 
                    case 66: {
                        break;
                    }
                    default: {
                        this.jj_la1[1] = this.jj_gen;
                        break block7;
                    }
                }
                a = this.read();
            }
            this.jj_consume_token(2);
            if (a == 0) {
                return 0;
            }
            this.printResults = true;
            this.bw.write("\n>> ");
            this.bw.flush();
        }
        this.jj_consume_token(0);
        throw new Error("Missing return statement in function");
    }

    public final void runCommand(Reader reader) throws ParseException, NumberFormatException, IOException {
        this.work = true;
        this.ReInit(reader);
        this.read();
        this.jj_consume_token(2);
        this.work = false;
    }

    public final void execute() throws ParseException, NumberFormatException, IOException {
        this.read();
        this.jj_consume_token(2);
    }

    private final int read() throws ParseException, NumberFormatException, IOException {
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 24: 
            case 26: 
            case 29: 
            case 40: 
            case 41: 
            case 43: {
                Objects o = this.Expression_objects();
                this.printObjects(o);
                o.close();
                break;
            }
            case 21: 
            case 22: 
            case 23: 
            case 25: 
            case 27: 
            case 28: 
            case 30: 
            case 31: 
            case 44: 
            case 63: {
                long size = this.Expression_long();
                this.bw.write("Result: " + size + "\n");
                this.bw.flush();
                break;
            }
            case 35: 
            case 39: 
            case 42: 
            case 66: {
                int v = this.Expression_int();
                this.bw.write("Result: " + v + "\n");
                this.bw.flush();
                break;
            }
            case 33: {
                this.jj_consume_token(33);
                long size = this.Expression_long();
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 21: 
                    case 22: 
                    case 23: 
                    case 25: 
                    case 27: 
                    case 28: 
                    case 30: 
                    case 31: 
                    case 44: 
                    case 63: {
                        long l = this.Expression_long();
                        Value va = dbg.getAttribute(size, l);
                        if (va.getType() == 7) {
                            TextStream tstrm = va.getTextStream();
                            char[] cc = new char[globals.get("maxsize").getInt()];
                            int len = tstrm.read(cc, 0, cc.length);
                            tstrm.close();
                            this.bw.write(String.format("Result: %s\n", new String(cc, 0, len) + "..."));
                        } else {
                            this.bw.write("Result: " + va.toString() + "\n");
                        }
                        this.bw.flush();
                        break block0;
                    }
                    case 67: {
                        String s = this.token_string();
                        Value va = dbg.getAttribute(size, s);
                        if (va.getType() == 7) {
                            TextStream tstrm = va.getTextStream();
                            char[] cc = new char[globals.get("maxsize").getInt()];
                            int len = tstrm.read(cc, 0, cc.length);
                            tstrm.close();
                            this.bw.write(String.format("Result: %s\n", new String(cc, 0, len) + "..."));
                        } else {
                            this.bw.write("Result: " + va.toString() + "\n");
                        }
                        this.bw.flush();
                        break block0;
                    }
                }
                this.jj_la1[2] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
            case 32: 
            case 34: {
                Attribute[] attrs = this.Expression_array();
                this.printArray(attrs);
                break;
            }
            case 46: 
            case 47: {
                this.varGlobals();
                break;
            }
            case 36: {
                this.jj_consume_token(36);
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 50: {
                        this.dumpSchema();
                        break block0;
                    }
                    case 37: {
                        this.dumpData();
                        break block0;
                    }
                    case 38: {
                        this.dumpStorage();
                        break block0;
                    }
                }
                this.jj_la1[3] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
            case 51: {
                this.jj_consume_token(51);
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 50: {
                        this.jj_consume_token(50);
                        this.printSchema();
                        this.printAttributes();
                        break block0;
                    }
                    case 53: {
                        this.jj_consume_token(53);
                        this.printSchema();
                        break block0;
                    }
                    case 54: {
                        this.jj_consume_token(54);
                        this.printAttributes();
                        break block0;
                    }
                    case 55: {
                        this.jj_consume_token(55);
                        long size = this.Expression_long();
                        Objects o = new Objects(dbg.getSession());
                        o.add(size);
                        this.printObjects(o);
                        o.close();
                        break block0;
                    }
                    case 56: {
                        this.jj_consume_token(56);
                        this.printGlobals();
                        break block0;
                    }
                    case 52: {
                        this.jj_consume_token(52);
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 35: 
                            case 39: 
                            case 42: 
                            case 66: {
                                int v = this.Expression_int();
                                this.printType(v);
                                break block0;
                            }
                            case 67: {
                                String s = this.token_string();
                                this.printType(dbg.findType(s));
                                break block0;
                            }
                        }
                        this.jj_la1[4] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                this.jj_la1[5] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
            case 62: {
                this.jj_consume_token(62);
                this.work = false;
                return 0;
            }
            case 45: {
                this.jj_consume_token(45);
                this.printHelp();
                break;
            }
            default: {
                this.jj_la1[6] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        this.work = false;
        return 1;
    }

    private final void varGlobals() throws ParseException, NumberFormatException, IOException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 46: {
                this.jj_consume_token(46);
                this.getGlobal();
                break;
            }
            case 47: {
                this.jj_consume_token(47);
                this.setGlobal();
                break;
            }
            default: {
                this.jj_la1[7] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    private final void dumpSchema() throws ParseException, ParseException, IOException {
        this.jj_consume_token(50);
        String alias = dbg.getSession().getGraphPool().getAlias();
        File file = new File(alias + ".des");
        if (file.exists() && !this.askYesOrNo(alias + ".des file exists, Do you want to overwrite it?")) {
            return;
        }
        FileWriter fw = new FileWriter(file);
        dbg.getSession().getGraphPool().dumpSchema(dbg.getSession(), fw);
        fw.flush();
        fw.close();
        this.bw.write("Scripting has successfully been written to " + alias + ".des");
        this.bw.flush();
    }

    private final void dumpData() throws ParseException, ParseException, IOException {
        this.jj_consume_token(37);
        String alias = dbg.getGraphPool().getAlias();
        File file = new File(alias + ".data");
        if (file.exists() && !this.askYesOrNo(alias + ".data file exists, Do you want to overwrite it?")) {
            return;
        }
        dbg.getGraphPool().dumpData(dbg.getSession(), alias + ".data");
        this.bw.write("Logical content has successfully been written to " + alias + ".data");
        this.bw.flush();
    }

    private final void dumpStorage() throws ParseException, ParseException, IOException {
        this.jj_consume_token(38);
        String alias = dbg.getGraphPool().getAlias();
        File file = new File(alias + ".storage");
        if (file.exists() && !this.askYesOrNo(alias + ".storage file exists, Do you want to overwrite it?")) {
            return;
        }
        dbg.getGraphPool().dumpStorage(dbg.getSession(), alias + ".storage");
        this.bw.write("Internal content has successfully been written to " + alias + ".storage");
        this.bw.flush();
    }

    private final void getGlobal() throws ParseException, NumberFormatException, IOException {
        Token name = this.jj_consume_token(68);
        if (globals.containsKey(name.image)) {
            Value g = globals.get(name.image);
            this.bw.write("Global variable '" + name.image + "' is set to " + g.toString() + "\n");
        } else {
            this.bw.write("There is no variable with the given name: " + name.image + "\n");
        }
        this.bw.flush();
    }

    private final void setGlobal() throws ParseException, NumberFormatException, IOException {
        Value v;
        Token name = this.jj_consume_token(68);
        if (!globals.containsKey(name.image)) {
            this.bw.write("There is no variable with the given name: " + name.image + "\n");
            this.bw.flush();
            return;
        }
        short vtype = globals.get(name.image).getType();
        if (vtype != (v = this.Expression_value()).getType()) {
            throw new ParseException("Valor de tipus incompatible");
        }
        globals.put(name.image, v);
    }

    private final Value Expression_value() throws ParseException, NumberFormatException {
        Value v = new Value();
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 57: {
                this.jj_consume_token(57);
                v.setNull();
                break;
            }
            case 48: 
            case 58: {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 48: {
                        this.jj_consume_token(48);
                        break;
                    }
                    case 58: {
                        this.jj_consume_token(58);
                        break;
                    }
                    default: {
                        this.jj_la1[8] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                v.setBool(true);
                break;
            }
            case 49: 
            case 59: {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 49: {
                        this.jj_consume_token(49);
                        break;
                    }
                    case 59: {
                        this.jj_consume_token(59);
                        break;
                    }
                    default: {
                        this.jj_la1[9] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                v.setBool(false);
                break;
            }
            case 66: {
                Token valor = this.jj_consume_token(66);
                v.setInt(Integer.parseInt(valor.image));
                break;
            }
            case 63: {
                Token valor = this.jj_consume_token(63);
                v.setLong(Long.parseLong(valor.image.substring(0, valor.image.length() - 1)));
                break;
            }
            case 64: {
                Token valor = this.jj_consume_token(64);
                v.setDouble(Double.parseDouble(valor.image));
                break;
            }
            case 67: {
                String s = this.token_string();
                v.setString(s);
                break;
            }
            case 33: {
                this.jj_consume_token(33);
                long objID = this.Expression_long();
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 21: 
                    case 22: 
                    case 23: 
                    case 25: 
                    case 27: 
                    case 28: 
                    case 30: 
                    case 31: 
                    case 44: 
                    case 63: {
                        long attrID = this.Expression_long();
                        return dbg.getAttribute(objID, attrID);
                    }
                    case 67: {
                        String s = this.token_string();
                        return dbg.getAttribute(objID, s);
                    }
                }
                this.jj_la1[10] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
            default: {
                this.jj_la1[11] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return v;
    }

    private final long Expression_size() throws ParseException, NumberFormatException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 24: 
            case 26: 
            case 29: 
            case 40: 
            case 41: 
            case 43: {
                Objects o = this.Expression_objects();
                long size = o.size();
                o.close();
                return size;
            }
            case 32: 
            case 34: {
                Attribute[] attrs = this.Expression_array();
                return attrs.length;
            }
        }
        this.jj_la1[12] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    private final Attribute[] Expression_array() throws ParseException, NumberFormatException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 32: {
                this.jj_consume_token(32);
                Attribute[] attrs = this.fattrs();
                this.arrayType = 1;
                return attrs;
            }
            case 34: {
                this.jj_consume_token(34);
                long l = this.Expression_long();
                this.arrayType = 2;
                return dbg.findAttributes(l);
            }
        }
        this.jj_la1[13] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    private final long Expression_long() throws ParseException, NumberFormatException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 23: {
                this.jj_consume_token(23);
                long o = this.head();
                return o;
            }
            case 25: {
                this.jj_consume_token(25);
                long o = this.tail();
                return o;
            }
            case 27: {
                this.jj_consume_token(27);
                long o = this.fattr();
                return o;
            }
            case 28: {
                this.jj_consume_token(28);
                long o = this.fedge();
                return o;
            }
            case 30: {
                this.jj_consume_token(30);
                long o = this.fedgepeer();
                return o;
            }
            case 31: {
                this.jj_consume_token(31);
                long o = this.fobject();
                return o;
            }
            case 21: {
                this.jj_consume_token(21);
                return dbg.nodes();
            }
            case 22: {
                this.jj_consume_token(22);
                return dbg.edges();
            }
            case 63: {
                Token number = this.jj_consume_token(63);
                return Long.parseLong(number.image.substring(0, number.image.length() - 1));
            }
            case 44: {
                this.jj_consume_token(44);
                this.jj_consume_token(16);
                long o = this.Expression_size();
                this.jj_consume_token(17);
                return o;
            }
        }
        this.jj_la1[14] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    private final int Expression_int() throws ParseException, NumberFormatException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 42: {
                this.jj_consume_token(42);
                String type = this.token_string();
                return dbg.findType(type);
            }
            case 66: {
                Token number = this.jj_consume_token(66);
                return Integer.parseInt(number.image);
            }
            case 35: {
                this.jj_consume_token(35);
                long id = this.Expression_long();
                return (int)dbg.getAttributeCount(id);
            }
            case 39: {
                this.jj_consume_token(39);
                long id = this.Expression_long();
                return (int)dbg.getAttributeSize(id);
            }
        }
        this.jj_la1[15] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    private final String token_string() throws ParseException, NumberFormatException {
        Token string = this.jj_consume_token(67);
        String[] aux = string.image.split("\"");
        if (aux.length < 2 || aux.length > 2) {
            return "";
        }
        return aux[1];
    }

    private final Objects Expression_objects() throws ParseException, NumberFormatException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 40: {
                this.jj_consume_token(40);
                Objects o = this.neigh(1);
                return o;
            }
            case 41: {
                this.jj_consume_token(41);
                Objects o = this.neigh(2);
                return o;
            }
            case 43: {
                this.jj_consume_token(43);
                Objects o = this.select();
                return o;
            }
            case 24: {
                this.jj_consume_token(24);
                Objects o = this.Expression_objects();
                Objects h = dbg.heads(o);
                o.close();
                return h;
            }
            case 26: {
                this.jj_consume_token(26);
                Objects o = this.Expression_objects();
                Objects t = dbg.tails(o);
                o.close();
                return t;
            }
            case 29: {
                this.jj_consume_token(29);
                Objects o = this.fedges();
                return o;
            }
        }
        this.jj_la1[16] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    private final long head() throws ParseException, NumberFormatException {
        long idEdge = this.Expression_long();
        long h = dbg.getEdge(idEdge)[1];
        return h;
    }

    private final long tail() throws ParseException, NumberFormatException {
        long idEdge = this.Expression_long();
        long t = dbg.getEdge(idEdge)[0];
        return t;
    }

    private final Attribute[] fattrs() throws ParseException, NumberFormatException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 35: 
            case 39: 
            case 42: 
            case 66: {
                int idType = this.Expression_int();
                return dbg.findAttributes(idType);
            }
            case 67: {
                String type = this.token_string();
                return dbg.findAttributes(dbg.findType(type));
            }
        }
        this.jj_la1[17] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    private final long fattr() throws ParseException, NumberFormatException {
        int idType;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 35: 
            case 39: 
            case 42: 
            case 66: {
                idType = this.Expression_int();
                break;
            }
            case 67: {
                String idObject = this.token_string();
                idType = dbg.findType(idObject);
                break;
            }
            default: {
                this.jj_la1[18] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        String nameAttr = this.token_string();
        long attr = dbg.findAttribute(idType, nameAttr);
        return attr;
    }

    private final long fedge() throws ParseException, NumberFormatException {
        int edgeType;
        long node1 = this.Expression_long();
        long node2 = this.Expression_long();
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 35: 
            case 39: 
            case 42: 
            case 66: {
                edgeType = this.Expression_int();
                break;
            }
            case 67: {
                String edgeName = this.token_string();
                edgeType = dbg.findType(edgeName);
                break;
            }
            default: {
                this.jj_la1[19] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return dbg.findEdge(node1, node2, edgeType);
    }

    private final Objects fedges() throws ParseException, NumberFormatException {
        int edgeType;
        long node1 = this.Expression_long();
        long node2 = this.Expression_long();
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 35: 
            case 39: 
            case 42: 
            case 66: {
                edgeType = this.Expression_int();
                break;
            }
            case 67: {
                String edgeName = this.token_string();
                edgeType = dbg.findType(edgeName);
                break;
            }
            default: {
                this.jj_la1[20] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        long[] v = dbg.findEdges(node1, node2, edgeType, Integer.MAX_VALUE);
        Objects o = new Objects(dbg.getSession());
        for (int i = 0; i < v.length; ++i) {
            o.add(v[i]);
        }
        return o;
    }

    private final long fedgepeer() throws ParseException, NumberFormatException {
        long edge = this.Expression_long();
        long node = this.Expression_long();
        return dbg.getEdgePeer(edge, node);
    }

    private final long fobject() throws ParseException, NumberFormatException {
        long attrID = this.Expression_long();
        Value v = this.Expression_value();
        return dbg.findObj(attrID, v);
    }

    private final Objects neigh(int i) throws ParseException, NumberFormatException {
        int edgetype;
        long node = this.Expression_long();
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 35: 
            case 39: 
            case 42: 
            case 66: {
                edgetype = this.Expression_int();
                break;
            }
            case 67: {
                String nameEdge = this.token_string();
                edgetype = dbg.findType(nameEdge);
                break;
            }
            default: {
                this.jj_la1[21] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        short dir = this.direction();
        if (i == 1) {
            Objects o = dbg.neighbors(node, edgetype, dir);
            return o;
        }
        if (i == 2) {
            Objects o = dbg.explode(node, edgetype, dir);
            return o;
        }
        throw new Error("Missing return statement in function");
    }

    private final Objects select() throws ParseException, NumberFormatException {
        int select;
        int idType;
        short op = 3;
        String nameAttr = "";
        Value value = new Value();
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 35: 
            case 39: 
            case 42: 
            case 66: {
                idType = this.Expression_int();
                select = 1;
                break;
            }
            case 67: {
                String type = this.token_string();
                idType = dbg.findType(type);
                select = 1;
                break;
            }
            default: {
                this.jj_la1[22] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 67: {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 67: {
                        nameAttr = this.token_string();
                        ++select;
                        break;
                    }
                    default: {
                        this.jj_la1[23] = this.jj_gen;
                    }
                }
                op = this.operator();
                ++select;
                value = this.Expression_value();
                break;
            }
            default: {
                this.jj_la1[24] = this.jj_gen;
            }
        }
        if (select == 1) {
            Objects o = dbg.select(idType);
            return o;
        }
        if (select == 2) {
            Objects o = dbg.select((long)idType, op, value);
            return o;
        }
        if (select == 3) {
            Objects o = dbg.select(dbg.findAttribute(idType, nameAttr), op, value);
            return o;
        }
        throw new Error("Missing return statement in function");
    }

    private final short operator() throws ParseException, NumberFormatException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 7: {
                this.jj_consume_token(7);
                return 3;
            }
            case 8: {
                this.jj_consume_token(8);
                return 6;
            }
            case 9: {
                this.jj_consume_token(9);
                return 5;
            }
            case 10: {
                this.jj_consume_token(10);
                return 4;
            }
            case 11: {
                this.jj_consume_token(11);
                return 1;
            }
            case 12: {
                this.jj_consume_token(12);
                return 2;
            }
            case 13: {
                this.jj_consume_token(13);
                return 7;
            }
            case 14: {
                this.jj_consume_token(14);
                return 11;
            }
            case 15: {
                this.jj_consume_token(15);
                return 12;
            }
        }
        this.jj_la1[25] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    private final short direction() throws ParseException, NumberFormatException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 18: {
                Token dir = this.jj_consume_token(18);
                return 1;
            }
            case 19: {
                Token dir = this.jj_consume_token(19);
                return 2;
            }
            case 20: {
                Token dir = this.jj_consume_token(20);
                return 3;
            }
        }
        this.jj_la1[26] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    private void printSchema() throws ParseException, IOException {
        int type;
        this.bw.write("\n");
        String capsalera = "Type|            Type Name| Type Identifier|                Count|                           Info|";
        String separator = "==================================================================================================";
        this.bw.write(capsalera + "\n" + separator + "\n");
        this.bw.flush();
        Iterator<Integer> itDat = dbg.getNodeTypes();
        int count = 0;
        while (itDat.hasNext()) {
            if (this.MAX > 0 && count == this.MAX || !this.printResults) {
                count = 0;
                this.bw.write(separator + "\n");
                this.bw.flush();
                if (!this.printResults || !this.askYesOrNo("Do you want to see more?")) {
                    this.bw.write("\n");
                    this.bw.flush();
                    return;
                }
                this.bw.write(capsalera + "\n" + separator + "\n");
                this.bw.flush();
            }
            ++count;
            type = itDat.next();
            this.bw.write(String.format("%4s|", "N"));
            this.bw.flush();
            String name = dbg.getTypeName(type);
            if (name.length() > 21) {
                name = name.substring(0, 17);
                name = name.concat("...");
            }
            Objects objs = dbg.select(type);
            this.bw.write(String.format("%21s|%16s|%21s|%31s|\n", name, type, objs.size(), ""));
            this.bw.flush();
            objs.close();
        }
        itDat = dbg.getEdgeTypes();
        count = 0;
        while (itDat.hasNext()) {
            if (this.MAX > 0 && count == this.MAX || !this.printResults) {
                count = 0;
                this.bw.write(separator + "\n");
                this.bw.flush();
                if (!this.printResults || !this.askYesOrNo("Do you want to see more?")) {
                    this.bw.write("\n");
                    this.bw.flush();
                    return;
                }
                this.bw.write(capsalera + "\n" + separator + "\n");
                this.bw.flush();
            }
            ++count;
            type = itDat.next();
            Graph.TypeData tdata = dbg.getTypeData(type);
            if (tdata.isUndirected()) {
                this.bw.write(String.format("%4s|", "UE" + (tdata.hasNeighbors() ? "-N" : "")));
            } else if (tdata.isRestricted()) {
                this.bw.write(String.format("%4s|", "RE" + (tdata.hasNeighbors() ? "-N" : "")));
            } else if (tdata.isDirected()) {
                this.bw.write(String.format("%4s|", "DE" + (tdata.hasNeighbors() ? "-N" : "")));
            } else {
                this.bw.write(String.format("%4s|", "E" + (tdata.hasNeighbors() ? "-N" : "")));
            }
            this.bw.flush();
            String name = tdata.getName();
            if (name.length() > 21) {
                name = name.substring(0, 17);
                name = name.concat("...");
            }
            this.bw.write(String.format("%21s|%16s|", name, type));
            if (tdata.isRestricted()) {
                int[] types = tdata.getRestricted();
                String name1 = dbg.getTypeData(types[0]).getName();
                String name2 = dbg.getTypeData(types[1]).getName();
                String info = name1.length() + name2.length() + 5 <= 31 ? name1 + " --> " + name2 : (name1.length() > 13 && name2.length() > 13 ? name1.substring(0, 13) + " --> " + name2.substring(0, 13) : (name1.length() > 13 ? name1.substring(0, 26 - name2.length()) + " --> " + name2 : name1 + " --> " + name2.substring(0, 26 - name1.length())));
                Objects objs = dbg.select(type);
                this.bw.write(String.format("%21s|%31s|", objs.size(), info));
                objs.close();
            } else {
                Objects objs = dbg.select(type);
                this.bw.write(String.format("%21s|%31s|", objs.size(), ""));
                objs.close();
            }
            this.bw.write("\n");
        }
        this.bw.write(separator + "\n");
        this.bw.write("\n");
        this.bw.flush();
    }

    private void printAttributes() throws ParseException, IOException {
        this.bw.write("\n");
        String capsalera = " Type Identifier|         Type name|                Name|           Identifier| Data type|   Kind|";
        String separator = "==================================================================================================";
        this.bw.write(capsalera + "\n" + separator + "\n");
        Set<Integer> types = dbg.nodeTypes();
        types.addAll(dbg.edgeTypes());
        types.add(1);
        Iterator<Integer> itTypes = types.iterator();
        int count = 0;
        while (itTypes.hasNext()) {
            String typename;
            int type = itTypes.next();
            String string = typename = type != 1 ? dbg.getTypeName(type) : "-";
            if (typename.length() > 18) {
                typename = typename.substring(0, 14);
                typename = typename.concat("...");
            }
            for (long attrs : dbg.getAttributesFromType(type)) {
                Graph.AttributeData adata = dbg.getAttributeData(attrs);
                if (this.MAX > 0 && count == this.MAX || !this.printResults) {
                    count = 0;
                    this.bw.write(separator + "\n");
                    if (!this.printResults || !this.askYesOrNo("Do you want to see more?")) {
                        this.bw.write("\n");
                        return;
                    }
                    this.bw.write(capsalera + "\n" + separator + "\n");
                }
                ++count;
                this.bw.write(String.format("%16s|%18s|", type, typename));
                String name = adata.getName();
                if (name.length() > 20) {
                    name = name.substring(0, 16);
                    name = name.concat("...");
                }
                this.bw.write(String.format("%20s|%21s|%10s|", name, attrs, Value.getTypeName(dbg.getAttributeType(attrs))));
                switch (adata.getKind()) {
                    case 0: {
                        this.bw.write(String.format("%7s|\n", "BASIC"));
                        break;
                    }
                    case 1: {
                        this.bw.write(String.format("%7s|\n", "UNIQUE"));
                        break;
                    }
                    case 2: {
                        this.bw.write(String.format("%7s|\n", "INDEXED"));
                    }
                }
            }
        }
        this.bw.write(separator + "\n");
        this.bw.flush();
    }

    private void printType(int type) throws ParseException, IOException {
        boolean node = false;
        if (dbg.isTypeEdge(type)) {
            node = false;
        } else if (dbg.isTypeNode(type)) {
            node = true;
        } else {
            throw new ParseException("Node or Edge type expected.");
        }
        String capsalera = " N/E|            Type name| Type Identifier|                Count|";
        String separator = "==================================================================";
        this.bw.write(capsalera + "\n" + separator + "\n");
        if (node) {
            this.bw.write("   N|");
        } else {
            this.bw.write("   E|");
        }
        String typename = dbg.getTypeName(type);
        if (typename.length() > 21) {
            typename = typename.substring(0, 17);
            typename = typename.concat("...");
        }
        this.bw.write(String.format("%21s|%16s|", typename, type));
        Objects objs = dbg.select(type);
        this.bw.write(String.format("%21s|", objs.size()));
        objs.close();
        this.bw.write("\n" + separator + "\n\n");
        Attribute[] attrs = dbg.findAttributes(type);
        if (attrs.length > 0) {
            capsalera = " Type Identifier|            Type name|       Attribute name| Attribute identifier| Data type|";
            separator = "==============================================================================================";
            this.bw.write(capsalera + "\n" + separator + "\n");
            int count = 0;
            for (int i = 0; i < attrs.length; ++i) {
                if (this.MAX > 0 && count == this.MAX) {
                    count = 0;
                    this.bw.write(separator + "\n");
                    if (!this.askYesOrNo("Do you want to see more?")) {
                        this.bw.write("\n");
                        return;
                    }
                    this.bw.write(capsalera + "\n" + separator + "\n");
                }
                ++count;
                this.bw.write(String.format("%16s|%21s", type, typename));
                String name = attrs[i].name;
                if (name.length() > 21) {
                    name = name.substring(0, 17);
                    name = name.concat("...");
                }
                this.bw.write(String.format("%21s|%21s|%10s|", name, attrs[i].value.toString(), Value.getTypeName(dbg.getAttributeType(attrs[i].value.getLong()))));
                this.bw.write("\n");
            }
            this.bw.write(separator + "\n");
        } else {
            this.bw.write("No attributes for this type.\n");
        }
        this.bw.write("\n");
        this.bw.flush();
    }

    private void printObjects(Objects o) throws ParseException, IOException {
        this.bw.write("\n");
        if (o.size() < 1) {
            this.bw.write("No elements for this query.\n");
            return;
        }
        ArrayList<Integer> longituts = new ArrayList<Integer>();
        boolean values = globals.get("values").getBool();
        int type = dbg.getType(o.first());
        boolean edges = dbg.isTypeEdge(type);
        longituts.add(21);
        int size = (Integer)longituts.get(0) + 1;
        this.bw.write(String.format("%" + longituts.get(0) + "s|", "Object Identifier"));
        if (edges) {
            this.bw.write(String.format("%" + longituts.get(0) + "s|  |%" + longituts.get(0) + "s|", "Tail Identifier", "Head Identifier"));
            size += 2 * ((Integer)longituts.get(0) + 1) + 3;
        }
        if (values) {
            Attribute[] attr = dbg.findAttributes(type);
            int maxSize = globals.get("maxsize").getInt();
            for (int i = 0; i < attr.length; ++i) {
                int vsize;
                Attribute a = attr[i];
                int ssize = a.name.length() + 1;
                switch (dbg.getAttributeType(a.value.getLong())) {
                    case 4: {
                        vsize = 6;
                        break;
                    }
                    case 3: {
                        vsize = 23;
                        break;
                    }
                    case 1: {
                        vsize = 12;
                        break;
                    }
                    case 6: {
                        vsize = 21;
                        break;
                    }
                    case 2: 
                    case 5: 
                    case 7: {
                        vsize = maxSize + 4;
                        break;
                    }
                    default: {
                        vsize = 0;
                    }
                }
                int aux = Math.max(ssize, vsize);
                longituts.add(aux);
                size += aux + 1;
                this.bw.write(String.format("%" + aux + "s|", a.name));
            }
        }
        this.bw.write("\n");
        String separator = new String();
        for (int i = 0; i < size; ++i) {
            separator = separator.concat("=");
        }
        this.bw.write(separator + "\n");
        int count = 0;
        Objects.Iterator it = o.iterator();
        while (it.hasNext()) {
            if (this.MAX > 0 && count == this.MAX || !this.printResults) {
                count = 0;
                this.bw.write(separator + "\n");
                if (!this.printResults || !this.askYesOrNo("Do you want to see more?")) {
                    this.bw.write("\n");
                    return;
                }
                this.bw.write(String.format("%" + longituts.get(0) + "s|", "Object Identifier"));
                if (edges) {
                    this.bw.write(String.format("%" + longituts.get(0) + "s|  |%" + longituts.get(0) + "s|", "Tail Identifier", "Head Identifier"));
                }
                if (values) {
                    Attribute[] attr = dbg.findAttributes(type);
                    for (int i = 0; i < attr.length; ++i) {
                        Attribute a = attr[i];
                        this.bw.write(String.format("%" + longituts.get(i + 1) + "s|", a.name));
                    }
                }
                this.bw.write("\n" + separator + "\n");
            }
            long obj = it.next();
            String s = String.valueOf(obj);
            this.bw.write(String.format("%" + longituts.get(0) + "s|", s));
            if (edges) {
                this.bw.write(String.format("%" + longituts.get(0) + "s|", dbg.getEdge(obj)[0]));
                if (dbg.isEdgeTypeUndirected(type)) {
                    this.bw.write("--|");
                } else {
                    this.bw.write("->|");
                }
                this.bw.write(String.format("%" + longituts.get(0) + "s|", dbg.getEdge(obj)[1]));
            }
            if (values) {
                Attribute[] attrs = dbg.findAttributes(type);
                for (int i = 0; i < attrs.length; ++i) {
                    Value v = new Value();
                    dbg.getAttribute(obj, attrs[i].value.getLong(), v);
                    if (v.getType() == 7) {
                        TextStream tstrm = v.getTextStream();
                        char[] cc = new char[globals.get("maxsize").getInt()];
                        int len = tstrm.read(cc, 0, cc.length);
                        tstrm.close();
                        this.bw.write(String.format("%" + longituts.get(i + 1) + "s|", new String(cc, 0, len) + "..."));
                        continue;
                    }
                    if (v.getType() == 2 && v.getString().length() > globals.get("maxsize").getInt()) {
                        v.setString(v.getString().substring(0, globals.get("maxsize").getInt()));
                        v.setString(v.getString().concat("..."));
                    }
                    this.bw.write(String.format("%" + longituts.get(i + 1) + "s|", v.toString()));
                }
            }
            this.bw.write("\n");
            ++count;
        }
        this.bw.write(separator + "\n");
        this.bw.flush();
    }

    private void printArray(Attribute[] attrs) throws ParseException, IOException {
        this.bw.write("\n");
        String capsalera = "       Attribute name|                             Value| Data type|";
        String separator = "====================================================================";
        this.bw.write(capsalera + "\n" + separator + "\n");
        int count = 0;
        for (int i = 0; i < attrs.length; ++i) {
            Value v;
            if (this.MAX > 0 && count == this.MAX || !this.printResults) {
                count = 0;
                this.bw.write(separator + "\n");
                if (!this.printResults || !this.askYesOrNo("Do you want to see more?")) {
                    this.bw.write("\n");
                    return;
                }
                this.bw.write(capsalera + "\n" + separator + "\n");
            }
            ++count;
            String name = attrs[i].name;
            if (name.length() > 21) {
                name = name.substring(0, 17);
                name = name.concat("...");
            }
            if ((v = attrs[i].value).getType() == 2 && v.getString().length() > 30) {
                v.setString(v.getString().substring(0, 30));
                v.setString(v.getString().concat("..."));
            }
            if (v.getType() == 7) {
                TextStream tstrm = v.getTextStream();
                char[] cc = new char[globals.get("maxsize").getInt()];
                int len = tstrm.read(cc, 0, cc.length);
                tstrm.close();
                this.bw.write(String.format("%21s|%34s|%10s|\n", name, new String(cc, 0, len) + "...", Value.getTypeName(attrs[i].value.getType())));
                continue;
            }
            this.bw.write(String.format("%21s|%34s|%10s|\n", name, v.toString(), Value.getTypeName(attrs[i].value.getType())));
        }
        this.bw.write(separator + "\n");
        this.bw.flush();
    }

    private void printGlobals() throws ParseException, IOException {
        this.bw.write("    Global name|   Global Value| Global type|                             Description|\n");
        this.bw.write("======================================================================================\n");
        this.bw.write(String.format("%15s|%15s|%12s|%40s|\n", "values", globals.get("values"), Value.getTypeName(globals.get("values").getType()), "If 'true' show attributes and his values"));
        this.bw.write(String.format("%15s|%15s|%12s|%40s|\n", "maxsize", globals.get("maxsize"), Value.getTypeName(globals.get("maxsize").getType()), "Maximum length of String view."));
        this.bw.write("======================================================================================\n");
        this.bw.flush();
    }

    private void printHelp() throws ParseException, IOException {
        this.bw.write("\n");
        this.bw.write("Expressions that retrieve Objects (aka <objects_expression>):\n");
        this.bw.write("\n");
        this.bw.write("select <type_id>\n");
        this.bw.write("select \"<type_name>\"\n");
        this.bw.write("select <type_id> \"<attribute_name>\" <op> <value>\n");
        this.bw.write("select \"<type_name>\" \"<attribute_name>\" <op> <value>\n");
        this.bw.write("select <attribute_id> <op> <value>");
        this.bw.write("\n");
        this.bw.write("explode <node_id> <edgetype_id> in|out|both\n");
        this.bw.write("explode <node_id> \"<edgetype_name>\" in|out|both\n");
        this.bw.write("\n");
        this.bw.write("neighbors <node_id> <edgetype_id> in|out|both\n");
        this.bw.write("neighbors <node_id> \"<edgetype_name>\" in|out|both\n");
        this.bw.write("\n");
        this.bw.write("findEdges <node_id> <node_id> <edgetype_id>\n");
        this.bw.write("findEdges <node_id> <node_id> \"<edgetype_name>\"\n");
        this.bw.write("\n");
        this.bw.write("Expressions to be use with Objects (aka <objects_expression>):\n");
        this.bw.write("\n");
        this.bw.write("heads <objects_expression>\n");
        this.bw.write("tails <objects_expression>\n");
        this.bw.write("count (<objects_expression>|<array_expression>)\n");
        this.bw.write("\n");
        this.bw.write("Expressions that get a numerical result:\n");
        this.bw.write("\n");
        this.bw.write("head <edge_id>\n");
        this.bw.write("tail <edge_id>\n");
        this.bw.write("\n");
        this.bw.write("findAttribute <type_id> \"<attribute_name>\"\n");
        this.bw.write("findAttribute \"<type_name>\" \"<attribute_name>\"\n");
        this.bw.write("\n");
        this.bw.write("findEdge <node_id> <node_id> <edgetype_id>\n");
        this.bw.write("findEdge <node_id> <node_id> \"<edgetype_name>\"\n");
        this.bw.write("findObject <attribute_id> <value>\n");
        this.bw.write("edgePeer <edgetype_id> <node_id>\n");
        this.bw.write("\n");
        this.bw.write("edges\n");
        this.bw.write("nodes\n");
        this.bw.write("\n");
        this.bw.write("findType \"<type_name>\"\n");
        this.bw.write("attributeCount <attribute_id>\n");
        this.bw.write("attributeSize <attribute_id>\n");
        this.bw.write("\n");
        this.bw.write("Expression that get an Attribute array result (aka <array_expression>):\n");
        this.bw.write("\n");
        this.bw.write("findAttributes <type_id>\n");
        this.bw.write("findAttributes \"<type_name>\"\n");
        this.bw.write("getAttributes <object_id>\n");
        this.bw.write("\n");
        this.bw.write("Expressions that get a Value result:\n");
        this.bw.write("\n");
        this.bw.write("getAttribute <object_id> <attribute_id>\n");
        this.bw.write("getAttribute <object_id> \"<attribute_name>\"\n");
        this.bw.write("\n");
        this.bw.write("Expressions for global variables:\n");
        this.bw.write("\n");
        this.bw.write("get <var_name>\n");
        this.bw.write("set <var_name> <value>\n");
        this.bw.write("\n");
        this.bw.write("Prints:\n");
        this.bw.write("\n");
        this.bw.write("print schema\n");
        this.bw.write("print types\n");
        this.bw.write("print attributes\n");
        this.bw.write("print type <type_id>\n");
        this.bw.write("print type \"<type_name>\"\n");
        this.bw.write("print object <object_id>\n");
        this.bw.write("print globals\n");
        this.bw.write("\n");
        this.bw.write("Dumps:\n");
        this.bw.write("\n");
        this.bw.write("dump schema\n");
        this.bw.write("dump data\n");
        this.bw.write("dump storage\n");
        this.bw.write("\n");
        this.bw.write("Other:\n");
        this.bw.write("\n");
        this.bw.write("help\n");
        this.bw.write("quit\n");
        this.bw.write("\n");
        this.bw.write("Observations:\n");
        this.bw.write("\n");
        this.bw.write("<object_id>, <node_id>, <edge_id> and <attribute_id> must belong to Long type\n");
        this.bw.write("<type_id>, <nodetype_id>, <edgetype_id> must belong to Integer type.\n");
        this.bw.write("<type_name>, <nodetype_name>, <edgetype_name> must belong to String type.\n");
        this.bw.write("<value> must match Boolean(true|false), Double, Integer, Long, String or Timestamp(Long).\n");
        this.bw.write("<op> must be '==', '!=', '<', '<=', '>', '>=', 'like', 'ilike', 'ere'.\n");
        this.bw.write("Long must have an 'L' at the end.\n");
        this.bw.write("Double must have '.' somewhere.\n");
        this.bw.write("String must be quoted with '\"'.\n");
        this.bw.flush();
    }

    private boolean askYesOrNo(String question) throws ParseException, IOException {
        this.bw.write(question + "\n");
        this.bw.flush();
        while (true) {
            this.jj_consume_token(2);
            this.bw.write("Yes [y] or No [n]?\n");
            this.bw.flush();
            int i = this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk;
            switch (i) {
                case 60: {
                    this.jj_consume_token(60);
                    return true;
                }
                case 61: {
                    this.jj_consume_token(61);
                    return false;
                }
            }
            this.jj_consume_token(i);
        }
    }

    private static void jj_la1_0() {
        jj_la1_0 = new int[]{-2097148, -2097152, -622854144, 0, 0, 0, -2097152, 0, 0, 0, -622854144, 0, 0x25000000, 0, -622854144, 0, 0x25000000, 0, 0, 0, 0, 0, 0, 0, 65408, 65408, 0x1C0000};
    }

    private static void jj_la1_1() {
        jj_la1_1 = new int[]{-1073152097, -1073152097, -2147479552, 262240, 1160, 32768000, -1073152097, 49152, 0x4010000, 0x8020000, -2147479552, -1912406014, 2821, 5, -2147479552, 1160, 2816, 1160, 1160, 1160, 1160, 1160, 1160, 0, 0, 0, 0};
    }

    private static void jj_la1_2() {
        jj_la1_2 = new int[]{4, 4, 8, 0, 12, 0, 4, 0, 0, 0, 8, 13, 0, 0, 0, 4, 0, 12, 12, 12, 12, 12, 12, 8, 8, 0, 0};
    }

    public Shell(InputStream stream) {
        this(stream, null);
    }

    public Shell(InputStream stream, String encoding) {
        try {
            this.jj_input_stream = new SimpleCharStream(stream, encoding, 1, 1);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        this.token_source = new ShellTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 27; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    public void ReInit(InputStream stream) {
        this.ReInit(stream, null);
    }

    public void ReInit(InputStream stream, String encoding) {
        try {
            this.jj_input_stream.ReInit(stream, encoding, 1, 1);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 27; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    public Shell(Reader stream) {
        this.jj_input_stream = new SimpleCharStream(stream, 1, 1);
        this.token_source = new ShellTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 27; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    public void ReInit(Reader stream) {
        this.jj_input_stream.ReInit(stream, 1, 1);
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 27; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    public Shell(ShellTokenManager tm) {
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 27; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    public void ReInit(ShellTokenManager tm) {
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 27; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    private final Token jj_consume_token(int kind) throws ParseException {
        Token oldToken = this.token;
        this.token = oldToken.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        if (this.token.kind == kind) {
            ++this.jj_gen;
            return this.token;
        }
        this.token = oldToken;
        this.jj_kind = kind;
        throw this.generateParseException();
    }

    public final Token getNextToken() {
        this.token = this.token.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        ++this.jj_gen;
        return this.token;
    }

    public final Token getToken(int index) {
        Token t = this.token;
        for (int i = 0; i < index; ++i) {
            t = t.next != null ? t.next : (t.next = this.token_source.getNextToken());
        }
        return t;
    }

    private final int jj_ntk() {
        this.jj_nt = this.token.next;
        if (this.jj_nt == null) {
            this.token.next = this.token_source.getNextToken();
            this.jj_ntk = this.token.next.kind;
            return this.jj_ntk;
        }
        this.jj_ntk = this.jj_nt.kind;
        return this.jj_ntk;
    }

    public ParseException generateParseException() {
        int i;
        this.jj_expentries.removeAllElements();
        boolean[] la1tokens = new boolean[72];
        for (i = 0; i < 72; ++i) {
            la1tokens[i] = false;
        }
        if (this.jj_kind >= 0) {
            la1tokens[this.jj_kind] = true;
            this.jj_kind = -1;
        }
        for (i = 0; i < 27; ++i) {
            if (this.jj_la1[i] != this.jj_gen) continue;
            for (int j = 0; j < 32; ++j) {
                if ((jj_la1_0[i] & 1 << j) != 0) {
                    la1tokens[j] = true;
                }
                if ((jj_la1_1[i] & 1 << j) != 0) {
                    la1tokens[32 + j] = true;
                }
                if ((jj_la1_2[i] & 1 << j) == 0) continue;
                la1tokens[64 + j] = true;
            }
        }
        for (i = 0; i < 72; ++i) {
            if (!la1tokens[i]) continue;
            this.jj_expentry = new int[1];
            this.jj_expentry[0] = i;
            this.jj_expentries.addElement(this.jj_expentry);
        }
        int[][] exptokseq = new int[this.jj_expentries.size()][];
        for (int i2 = 0; i2 < this.jj_expentries.size(); ++i2) {
            exptokseq[i2] = (int[])this.jj_expentries.elementAt(i2);
        }
        return new ParseException(this.token, exptokseq, tokenImage);
    }

    public final void enable_tracing() {
    }

    public final void disable_tracing() {
    }

    static {
        globals = new TreeMap();
        Shell.jj_la1_0();
        Shell.jj_la1_1();
        Shell.jj_la1_2();
    }
}

