/*
 * Decompiled with CFR 0.152.
 */
package edu.upc.dama.dex.tasks;

import edu.upc.dama.dex.tasks.Scheduler;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;

public abstract class Task {
    private final AtomicReference<Throwable> exception = new AtomicReference();
    private Task parent;
    private final AtomicInteger dependenceCounter = new AtomicInteger(1);

    protected abstract boolean execute() throws Throwable;

    protected void cancel() {
    }

    void setException(Throwable th) {
        this.exception.set(th);
    }

    boolean hasException() {
        return this.exception.get() != null;
    }

    void throwException() throws Throwable {
        Throwable th = this.exception.get();
        if (th != null) {
            throw th;
        }
    }

    Throwable getException() {
        return this.exception.get();
    }

    void add(Task childTask) {
        if (childTask == null) {
            throw new NullPointerException("Illegal argument: childTask cannot be null");
        }
        if (childTask.parent != null) {
            throw new IllegalArgumentException("Illegal childTask: it is already added to another task");
        }
        if (this.parent == null) {
            throw new IllegalStateException("cannot add tasks to this task now");
        }
        if (!this.hasException()) {
            this.parent.add(childTask);
        }
    }

    void registerChild(Task childTask) {
        if (childTask == null) {
            throw new NullPointerException("Illegal argument: childTask cannot be null");
        }
        if (childTask.parent != null) {
            throw new IllegalArgumentException("Illegal childTask: it is already added to another task");
        }
        if (this.incrementDependenceCount() <= 1) {
            throw new IllegalStateException("Task already finished");
        }
        childTask.parent = this;
    }

    void setParent(Task parent) {
        if (parent == null) {
            throw new NullPointerException("Illegal argument: parent cannot be null");
        }
        if (this.parent != null) {
            throw new IllegalStateException("Illegal childTask: it is already added to another task");
        }
        this.parent = parent;
    }

    int getDependenceCount() {
        return this.dependenceCounter.get();
    }

    int incrementDependenceCount() {
        return this.dependenceCounter.incrementAndGet();
    }

    int decrementDependenceCount() {
        return this.dependenceCounter.decrementAndGet();
    }

    int decrementDependenceCount(int amount) {
        return this.dependenceCounter.addAndGet(-amount);
    }

    boolean success() {
        return this.finish();
    }

    boolean fail(Throwable th) {
        this.setException(th);
        return this.finish();
    }

    boolean finish() {
        boolean finished;
        int dependenceCount = this.decrementDependenceCount();
        boolean bl = finished = dependenceCount == 0;
        if (dependenceCount < 0) {
            throw new IllegalStateException("Negative dependence count");
        }
        if (finished && this.parent != null) {
            if (this.hasException()) {
                this.parent.fail(this.getException());
            } else {
                this.parent.success();
            }
        }
        return finished;
    }

    public static void main(String[] p) throws Throwable {
        Task helloWorld = new Task(){

            protected boolean execute() throws Throwable {
                System.out.println("hello world");
                return false;
            }
        };
        Scheduler.addAndWait(helloWorld);
        Task count10 = new Task(){
            private int i = 0;

            protected boolean execute() throws Throwable {
                ++this.i;
                System.out.println("i: " + this.i);
                return this.i < 10;
            }
        };
        Scheduler.addAndWait(count10);
        Task dummy = new Task(){

            protected boolean execute() throws Throwable {
                throw new UnsupportedOperationException("Not execute.");
            }
        };
        try {
            Scheduler.add(dummy);
        }
        catch (Throwable ex) {
            System.out.println("Exception expected: " + ex);
        }
        try {
            Scheduler.addAndWait(dummy);
        }
        catch (Throwable ex) {
            System.out.println("Exception expected: " + ex);
        }
    }
}

