/*
 * Decompiled with CFR 0.152.
 */
package edu.upc.dama.dex.tasks;

import edu.upc.dama.dex.core.Graph;
import edu.upc.dama.dex.core.Objects;
import edu.upc.dama.dex.core.Value;
import edu.upc.dama.dex.tasks.ForEachTask;
import edu.upc.dama.dex.tasks.ObjectsTask;
import edu.upc.dama.dex.tasks.ParallelTask;
import edu.upc.dama.dex.tasks.SerialTask;
import edu.upc.dama.dex.tasks.Task;
import java.util.concurrent.atomic.AtomicReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Tasks {
    public static Task parallel(final Task ... parallels) {
        return new ParallelTask(){

            protected boolean execute() throws Throwable {
                for (Task task : parallels) {
                    this.add(task);
                }
                return false;
            }
        };
    }

    public static Task serial(final Task ... serials) {
        return new SerialTask(){

            protected boolean execute() throws Throwable {
                for (Task task : serials) {
                    this.add(task);
                }
                return false;
            }
        };
    }

    public static ObjectsTask select(final Graph graph, final int type) {
        return new ObjectsTask(){

            protected boolean execute() throws Throwable {
                this.setObjects(graph.select(type));
                return false;
            }
        };
    }

    public static ObjectsTask select(final Graph graph, final long attr, final short op, final Value value) {
        return new ObjectsTask(){

            protected boolean execute() throws Throwable {
                this.setObjects(graph.select(attr, op, value));
                return false;
            }
        };
    }

    public static Task close(final ObjectsTask objects) {
        return new Task(){

            protected boolean execute() throws Throwable {
                objects.getObjects().close();
                return false;
            }
        };
    }

    public static Task intersectAndClose(final ObjectsTask objectsResult, final ObjectsTask ... objectsClose) {
        return new Task(){
            int i = 0;

            protected boolean execute() throws Throwable {
                if (this.i < objectsClose.length) {
                    Objects result = objectsResult.getObjects();
                    Objects os = objectsClose[this.i].getObjects();
                    result.intersection(os);
                    os.close();
                    ++this.i;
                    return this.i < objectsClose.length;
                }
                return false;
            }
        };
    }

    public static Task setIterable(final ForEachTask<Long> forEach, final ObjectsTask objects) {
        return new Task(){

            protected boolean execute() throws Throwable {
                forEach.setIterable(objects.getObjects());
                return false;
            }
        };
    }

    private static Task save(final ObjectsTask otask, final AtomicReference<Objects> objects) {
        return Tasks.serial(otask, new Task(){

            protected boolean execute() throws Throwable {
                objects.set(otask.getObjects());
                return false;
            }
        });
    }
}

