/*
 * Decompiled with CFR 0.152.
 */
package edu.upc.dama.dex.tasks;

import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;

public class Tracer {
    private static String tracename;
    private static Tracer[] tracers;
    private static final ThreadLocal<Tracer> localTracer;
    private static long minTime;
    private static long maxTime;
    private final int thid;
    private final ArrayList<Event> events = new ArrayList(0x100000);

    public static void initApp(String tracename, int numThreads) {
        tracers = new Tracer[numThreads];
        Tracer.tracename = tracename;
    }

    public static void finiApp() throws IOException {
        for (int i = 0; i < tracers.length; ++i) {
            if (tracers[i] != null) continue;
            Tracer.tracers[i] = new Tracer(i);
        }
        Merger merger = new Merger();
        merger.merge();
    }

    public static void initThread(int thid) {
        if (thid < 0) {
            throw new IllegalArgumentException("illegal argument: thid < 0");
        }
        if (thid >= tracers.length) {
            throw new IllegalArgumentException("illegal argument: thid >= thread count");
        }
        if (tracers[thid] != null) {
            throw new IllegalArgumentException("illegal argument: thid thread already in use");
        }
        if (localTracer.get() != null) {
            throw new IllegalStateException("illegal state: thread already initialized");
        }
        Tracer tracer = new Tracer(thid);
        localTracer.set(tracer);
        Tracer.tracers[thid] = tracer;
    }

    public static void finiThread() {
        localTracer.set(null);
    }

    public static void event(long type, long value) {
        if (localTracer.get() == null) {
            return;
        }
        localTracer.get().event(System.currentTimeMillis(), type, value);
    }

    private Tracer(int thid) {
        this.thid = thid;
    }

    private void event(long time, long type, long value) {
        Event event = new Event(time, type, value);
        this.events.add(event);
    }

    private long computeMaxTime(long maxTime) {
        int count = this.events.size();
        if (count > 0) {
            long lastTime = this.events.get(count - 1).time;
            maxTime = Math.max(maxTime, lastTime);
        }
        return maxTime;
    }

    private long computeMinTime(long minTime) {
        int count = this.events.size();
        if (count > 0) {
            long firstTime = this.events.get(0).time;
            minTime = Math.min(minTime, firstTime);
        }
        return minTime;
    }

    private Event getEvent(int p) {
        if (p < this.events.size()) {
            return this.events.get(p);
        }
        return null;
    }

    private long computeLocalTime(int p, long localTime) {
        Event event = this.getEvent(p);
        if (event != null) {
            localTime = Math.min(localTime, event.time);
        }
        return localTime;
    }

    private int writeLocal(Writer writer, int p, long localTime) throws IOException {
        Event event = this.getEvent(p);
        if (event != null && event.time == localTime) {
            event.write(writer, this.thid);
            ++p;
        }
        return p;
    }

    static {
        localTracer = new ThreadLocal();
        maxTime = 0L;
    }

    private static final class Merger {
        private int currentThid = 0;
        private int[] positions = new int[Tracer.access$300().length];
        private Writer writer;

        private Merger() {
        }

        public void merge() throws IOException {
            this.computeMaxTime();
            this.computeMinTime();
            this.openWriter();
            this.writeHeader();
            while (this.writeEvents()) {
            }
            this.closeWriter();
        }

        private void computeMaxTime() {
            maxTime = 0L;
            for (int i = 0; i < tracers.length; ++i) {
                Tracer tracer = tracers[i];
                maxTime = tracer.computeMaxTime(maxTime);
            }
        }

        private void computeMinTime() {
            minTime = maxTime;
            for (int i = 0; i < tracers.length; ++i) {
                Tracer tracer = tracers[i];
                minTime = tracer.computeMinTime(minTime);
            }
        }

        private void openWriter() throws IOException {
            this.writer = new FileWriter(tracename + ".prv");
        }

        private void writeHeader() throws IOException {
            this.writer.append("#Paraver(01/01/01 at 01:01):").append(Long.toString(maxTime - minTime)).append(":1(1):1:1(").append(Integer.toString(tracers.length)).append(":1)").append('\n');
        }

        private boolean writeEvents() throws IOException {
            int p;
            Tracer tracer;
            int i;
            long localTime = Long.MAX_VALUE;
            for (i = 0; i < tracers.length; ++i) {
                tracer = tracers[i];
                p = this.positions[i];
                localTime = tracer.computeLocalTime(p, localTime);
            }
            for (i = 0; i < tracers.length; ++i) {
                tracer = tracers[i];
                p = this.positions[i];
                this.positions[i] = p = tracer.writeLocal(this.writer, p, localTime);
            }
            return localTime < Long.MAX_VALUE;
        }

        private void closeWriter() throws IOException {
            this.writer.close();
        }
    }

    private static final class Event {
        private long time;
        private long type;
        private long value;

        public Event(long time, long type, long value) {
            this.time = time;
            this.type = type;
            this.value = value;
        }

        public void write(Writer writer, int thid) throws IOException {
            writer.append("2:1:1:1:").append(Integer.toString(thid + 1)).append(':').append(Long.toString(this.time - minTime)).append(':').append(Long.toString(this.type)).append(':').append(Long.toString(this.value)).append('\n');
        }

        public String toString() {
            return ":" + this.time + ":" + this.type + "=" + this.value;
        }
    }
}

