/*
 * Decompiled with CFR 0.152.
 */
package edu.upc.dama.dex.tasks;

import edu.upc.dama.dex.tasks.Scheduler;
import edu.upc.dama.dex.tasks.Task;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicBoolean;

class WaitTask
extends Task {
    private final Task subtask;
    private long timeStart;
    private long timeStop;
    private final Semaphore semaphore = new Semaphore(0);
    private final AtomicBoolean finished = new AtomicBoolean(false);

    WaitTask(Task subtask) {
        this.subtask = subtask;
        Scheduler.register(subtask, this);
    }

    void add(Task childTask) {
        throw new IllegalStateException("There is no collection task");
    }

    protected boolean execute() throws Throwable {
        if (!this.finished.get()) {
            this.registerChild(this.subtask);
            Scheduler.enqueueTask(this.subtask);
        }
        return false;
    }

    public void cancel() {
        if (this.finished.compareAndSet(false, true)) {
            this.timeStop = System.currentTimeMillis();
            this.semaphore.release();
            Scheduler.unregister(this);
        }
        super.cancel();
    }

    boolean finish() {
        if (super.finish()) {
            if (this.finished.compareAndSet(false, true)) {
                this.timeStop = System.currentTimeMillis();
                this.semaphore.release();
                Scheduler.unregister(this);
            }
            return true;
        }
        this.timeStart = System.currentTimeMillis();
        return false;
    }

    void waitTask() throws Throwable, InterruptedException {
        this.semaphore.acquire();
        this.throwException();
    }
}

