/*
 * Decompiled with CFR 0.152.
 */
package edu.upc.dama.dex.utils;

import java.util.ArrayList;
import java.util.TreeMap;

public class CmdLineArgs {
    int minArgs;
    int maxArgs;
    String prefix;
    ArrayList<String> args;
    final short TYPE_INT = 0;
    final short TYPE_BOOL = 1;
    final short TYPE_STRING = (short)2;
    final short TYPE_FLAGS = (short)3;
    TreeMap<String, Option> options;

    public CmdLineArgs(int minArgs, int maxArgs, String prefix) {
        this.init(minArgs, maxArgs, prefix);
    }

    public CmdLineArgs(int args, String prefix) {
        this.init(args, args, prefix);
    }

    public CmdLineArgs() {
        this.init(0, 0, null);
    }

    void init(int minArgs, int maxArgs, String prefix) {
        assert (minArgs <= maxArgs);
        this.minArgs = minArgs;
        this.maxArgs = maxArgs;
        this.prefix = prefix;
        this.args = new ArrayList();
        this.options = new TreeMap();
    }

    public void registerString(String name, char option, boolean required, String desc, String defvalue) {
        this.register(name, option, (short)2, required, desc, defvalue);
    }

    public void registerInt(String name, char option, boolean required, String desc, int defvalue) {
        this.register(name, option, (short)0, required, desc, new Integer(defvalue));
    }

    public void registerOption(String name, char option, boolean required, String desc, boolean defvalue) {
        this.register(name, option, (short)1, required, desc, new Boolean(defvalue));
    }

    public void registerFlags(String name, char option, String flags, boolean required, String desc, String defvalue) {
        assert (flags != null);
        Option o = this.register(name, option, (short)3, required, desc, defvalue == null ? "" : defvalue);
        o.extra = flags;
    }

    Option register(String name, char option, short type, boolean required, String desc, Object defvalue) {
        if (this.options.containsKey(name)) {
            throw new IllegalStateException(name + " already defined");
        }
        Option o = new Option();
        o.option = option;
        o.type = type;
        o.desc = desc;
        o.required = required;
        o.defvalue = defvalue;
        o.extra = null;
        this.options.put(name, o);
        return o;
    }

    public String usage() {
        String s = "";
        for (Option o : this.options.values()) {
            s = s + " ";
            if (!o.required) {
                s = s + "[";
            }
            s = s + '-';
            s = s + o.option;
            switch (o.type) {
                case 0: {
                    s = s + " <INT>";
                    break;
                }
                case 2: {
                    s = s + " <STR>";
                    break;
                }
                case 3: {
                    s = s + "<" + o.extra + ">";
                }
            }
            if (o.required) continue;
            s = s + "]";
        }
        if (this.minArgs > 0) {
            if (this.minArgs == 1 && this.maxArgs == 1) {
                s = s + " " + this.prefix;
            } else {
                for (int i = this.minArgs; i <= this.maxArgs; ++i) {
                    s = s + " " + this.prefix + "_" + i;
                }
            }
        }
        if (this.options.size() > 0) {
            s = s + "\nwhere:";
            for (String k : this.options.keySet()) {
                Option o = this.options.get(k);
                s = s + "\n\t-";
                s = s + o.option;
                s = s + " = " + k;
                if (o.desc != null) {
                    s = s + " " + o.desc;
                }
                if (o.defvalue == null) continue;
                s = s + "; default is \"" + o.defvalue + "\"";
            }
        }
        return s;
    }

    public void parse(String[] params) {
        this.args.clear();
        for (Option o : this.options.values()) {
            if (o.required) {
                o.value = null;
                continue;
            }
            o.value = o.defvalue;
        }
        for (int i = 0; i < params.length; ++i) {
            String s = params[i];
            if (s.charAt(0) == '-') {
                char opt;
                boolean found = false;
                if (s.length() == 1) {
                    throw new IllegalArgumentException("missing option #" + (i + 1));
                }
                if (s.length() == 2) {
                    opt = s.charAt(1);
                    for (Option o : this.options.values()) {
                        if (o.option != opt) continue;
                        switch (o.type) {
                            case 0: {
                                if (i == params.length) {
                                    throw new IllegalArgumentException("missing int value in option " + s);
                                }
                                o.value = Integer.parseInt(params[++i]);
                                break;
                            }
                            case 2: {
                                if (i == params.length) {
                                    throw new IllegalArgumentException("missing int value in option " + s);
                                }
                                o.value = params[++i];
                                break;
                            }
                            case 1: {
                                o.value = Boolean.TRUE;
                                break;
                            }
                            case 3: {
                                throw new IllegalArgumentException("missing flags in " + (i + 1));
                            }
                            default: {
                                throw new IllegalArgumentException("invalid type " + s);
                            }
                        }
                        found = true;
                        break;
                    }
                } else {
                    opt = s.charAt(1);
                    for (Option o : this.options.values()) {
                        if (o.option != opt) continue;
                        if (o.type == 3) {
                            String flags = (String)o.extra;
                            for (int f = 2; f < s.length(); ++f) {
                                if (flags.indexOf(s.charAt(f)) != -1) continue;
                                throw new IllegalArgumentException("invalid flag " + s.charAt(f) + " in " + s);
                            }
                        } else {
                            throw new IllegalArgumentException("flags expected in " + s);
                        }
                        o.value = s.substring(2);
                        found = true;
                        break;
                    }
                }
                if (found) continue;
                throw new IllegalArgumentException("unknown option " + s);
            }
            do {
                this.args.add(params[i++]);
            } while (i < params.length);
        }
        for (String s : this.options.keySet()) {
            Option o = this.options.get(s);
            if (!o.required || o.value != null) continue;
            throw new IllegalArgumentException(s + " required");
        }
        if (this.args.size() < this.minArgs || this.args.size() > this.maxArgs) {
            String s = this.args.size() + " provided, required ";
            if (this.minArgs != this.maxArgs) {
                s = s + "from ";
            }
            s = s + this.minArgs;
            if (this.minArgs != this.maxArgs) {
                s = s + " to " + this.maxArgs;
            }
            throw new IllegalArgumentException(s);
        }
    }

    Option getOption(short type, String name) {
        if (!this.options.containsKey(name)) {
            throw new IllegalArgumentException(name + " not defined");
        }
        Option o = this.options.get(name);
        if (o.type != type) {
            throw new IllegalArgumentException(name);
        }
        return o;
    }

    public String getOptionString(String name) {
        return (String)this.getOption((short)2, (String)name).value;
    }

    public boolean getOptionBool(String name) {
        return (Boolean)this.getOption((short)1, (String)name).value;
    }

    public int getOptionInt(String name) {
        return (Integer)this.getOption((short)0, (String)name).value;
    }

    public boolean hasOptionFlags(String name) {
        return ((String)this.getOption((short)3, (String)name).value).length() > 0;
    }

    public boolean getOptionFlag(String name, char flag) {
        return ((String)this.getOption((short)3, (String)name).value).indexOf(flag) != -1;
    }

    public String[] getArgs() {
        return this.args.toArray(new String[0]);
    }

    class Option {
        char option;
        short type;
        boolean required;
        String desc;
        Object defvalue;
        Object value;
        Object extra;

        Option() {
        }
    }
}

