/*
 * Decompiled with CFR 0.152.
 */
package edu.upc.dama.dex.utils;

import edu.upc.dama.dex.utils.IOLib;
import java.util.Properties;

public class DEXConfig
extends Properties {
    private static final DEXConfig dexconfig = new DEXConfig();

    public static DEXConfig getConfig() {
        return dexconfig;
    }

    private DEXConfig() {
        String configFile;
        this.setDefaults();
        try {
            configFile = System.getProperty("dex.config");
        }
        catch (Exception e) {
            configFile = null;
        }
        if (configFile == null) {
            configFile = "dex.cfg";
        }
        try {
            this.load(IOLib.streamFromString(configFile));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static String get(String key) {
        return dexconfig.getProperty(key);
    }

    public static int getInt(String key) {
        String val = dexconfig.getProperty(key);
        try {
            return Integer.parseInt(val);
        }
        catch (NumberFormatException nfe) {
            return Integer.MIN_VALUE;
        }
    }

    public static long getLong(String key) {
        String val = dexconfig.getProperty(key);
        try {
            return Long.parseLong(val);
        }
        catch (NumberFormatException nfe) {
            return Long.MIN_VALUE;
        }
    }

    public static float getFloat(String key) {
        String val = dexconfig.getProperty(key);
        try {
            return Float.parseFloat(val);
        }
        catch (NumberFormatException nfe) {
            return Float.NaN;
        }
    }

    public static double getDouble(String key) {
        String val = dexconfig.getProperty(key);
        try {
            return Double.parseDouble(val);
        }
        catch (NumberFormatException nfe) {
            return Double.NaN;
        }
    }

    public static boolean getBoolean(String key) {
        String val = dexconfig.getProperty(key);
        return "true".equalsIgnoreCase(val);
    }

    public static void set(String key, String value) {
        dexconfig.setProperty(key, value);
    }

    private void setDefaults() {
        this.setProperty("dex.io.pool.frame.size", "1");
        this.setProperty("dex.io.pool.persistent.minsize", "64");
        this.setProperty("dex.io.pool.persistent.maxsize", "0");
        this.setProperty("dex.io.pool.temporal.minsize", "16");
        this.setProperty("dex.io.pool.temporal.maxsize", "0");
        this.setProperty("dex.io.cache.maxsize", "0");
        this.setProperty("dex.monitor.active", "false");
        this.setProperty("dex.monitor.port", "9999");
        this.setProperty("dex.tasks.workers", "1");
        this.setProperty("dex.license", "");
        this.setProperty("dex.log", "INFO;jdex.log");
    }
}

