/*
 * Decompiled with CFR 0.152.
 */
package edu.upc.dama.dex.utils;

import edu.upc.dama.dex.utils.FibonacciHeapNode;
import java.util.ArrayList;
import java.util.Stack;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FibonacciHeap<T> {
    private static final double oneOverLogPhi = 1.0 / Math.log((1.0 + Math.sqrt(5.0)) / 2.0);
    public FibonacciHeapNode minNode;
    private int nNodes;

    public boolean isEmpty() {
        return this.minNode == null;
    }

    public void clear() {
        this.minNode = null;
        this.nNodes = 0;
    }

    public void decreaseKey(FibonacciHeapNode x, double k) {
        if (k > x.key) {
            throw new IllegalArgumentException("decreaseKey() got larger key value");
        }
        x.key = k;
        FibonacciHeapNode y = x.parent;
        if (y != null && x.key < y.key) {
            this.cut(x, y);
            this.cascadingCut(y);
        }
        if (this.minNode == null) {
            this.minNode = x;
        }
        if (x.key < this.minNode.key) {
            this.minNode = x;
        }
    }

    public void delete(FibonacciHeapNode x) {
        this.decreaseKey(x, Double.NEGATIVE_INFINITY);
        this.removeMin();
    }

    public void insert(FibonacciHeapNode node, double key) {
        node.key = key;
        if (this.minNode != null) {
            node.left = this.minNode;
            node.right = this.minNode.right;
            this.minNode.right = node;
            node.right.left = node;
            if (key < this.minNode.key) {
                this.minNode = node;
            }
        } else {
            this.minNode = node;
        }
        ++this.nNodes;
    }

    public FibonacciHeapNode min() {
        return this.minNode;
    }

    public FibonacciHeapNode removeMin() {
        FibonacciHeapNode z = this.minNode;
        if (z != null) {
            FibonacciHeapNode x = z.child;
            for (int numKids = z.degree; numKids > 0; --numKids) {
                FibonacciHeapNode tempRight = x.right;
                x.left.right = x.right;
                x.right.left = x.left;
                x.left = this.minNode;
                x.right = this.minNode.right;
                this.minNode.right = x;
                x.right.left = x;
                x.parent = null;
                x = tempRight;
            }
            z.left.right = z.right;
            z.right.left = z.left;
            if (z == z.right) {
                this.minNode = null;
            } else {
                this.minNode = z.right;
                this.consolidate();
            }
            --this.nNodes;
        }
        return z;
    }

    public int size() {
        return this.nNodes;
    }

    public static <T> FibonacciHeap<T> union(FibonacciHeap<T> h1, FibonacciHeap<T> h2) {
        FibonacciHeap<T> h = new FibonacciHeap<T>();
        if (h1 != null && h2 != null) {
            h.minNode = h1.minNode;
            if (h.minNode != null) {
                if (h2.minNode != null) {
                    h.minNode.right.left = h2.minNode.left;
                    h2.minNode.left.right = h.minNode.right;
                    h.minNode.right = h2.minNode;
                    h2.minNode.left = h.minNode;
                    if (h2.minNode.key < h1.minNode.key) {
                        h.minNode = h2.minNode;
                    }
                }
            } else {
                h.minNode = h2.minNode;
            }
            h.nNodes = h1.nNodes + h2.nNodes;
        }
        return h;
    }

    public String toString() {
        if (this.minNode == null) {
            return "FibonacciHeap=[]";
        }
        Stack<FibonacciHeapNode> stack = new Stack<FibonacciHeapNode>();
        stack.push(this.minNode);
        StringBuffer buf = new StringBuffer(512);
        buf.append("FibonacciHeap=[");
        while (!stack.empty()) {
            FibonacciHeapNode curr = (FibonacciHeapNode)stack.pop();
            buf.append(curr);
            buf.append(", ");
            if (curr.child != null) {
                stack.push(curr.child);
            }
            FibonacciHeapNode start = curr;
            curr = curr.right;
            while (curr != start) {
                buf.append(curr);
                buf.append(", ");
                if (curr.child != null) {
                    stack.push(curr.child);
                }
                curr = curr.right;
            }
        }
        buf.append(']');
        return buf.toString();
    }

    protected void cascadingCut(FibonacciHeapNode y) {
        FibonacciHeapNode z = y.parent;
        if (z != null) {
            if (!y.mark) {
                y.mark = true;
            } else {
                this.cut(y, z);
                this.cascadingCut(z);
            }
        }
    }

    protected void consolidate() {
        int arraySize = (int)Math.floor(Math.log(this.nNodes) * oneOverLogPhi) + 1;
        ArrayList<FibonacciHeapNode> array = new ArrayList<FibonacciHeapNode>(arraySize);
        for (int i = 0; i < arraySize; ++i) {
            array.add(null);
        }
        int numRoots = 0;
        FibonacciHeapNode x = this.minNode;
        if (x != null) {
            ++numRoots;
            x = x.right;
            while (x != this.minNode) {
                ++numRoots;
                x = x.right;
            }
        }
        while (numRoots > 0) {
            FibonacciHeapNode y;
            int d = x.degree;
            FibonacciHeapNode next = x.right;
            while ((y = (FibonacciHeapNode)array.get(d)) != null) {
                if (x.key > y.key) {
                    FibonacciHeapNode temp = y;
                    y = x;
                    x = temp;
                }
                this.link(y, x);
                array.set(d, null);
                ++d;
            }
            array.set(d, x);
            x = next;
            --numRoots;
        }
        this.minNode = null;
        for (int i = 0; i < arraySize; ++i) {
            FibonacciHeapNode y = (FibonacciHeapNode)array.get(i);
            if (y == null) continue;
            if (this.minNode != null) {
                y.left.right = y.right;
                y.right.left = y.left;
                y.left = this.minNode;
                y.right = this.minNode.right;
                this.minNode.right = y;
                y.right.left = y;
                if (!(y.key < this.minNode.key)) continue;
                this.minNode = y;
                continue;
            }
            this.minNode = y;
        }
    }

    protected void cut(FibonacciHeapNode x, FibonacciHeapNode y) {
        x.left.right = x.right;
        x.right.left = x.left;
        --y.degree;
        if (y.child == x) {
            y.child = x.right;
        }
        if (y.degree == 0) {
            y.child = null;
        }
        x.left = this.minNode;
        x.right = this.minNode.right;
        this.minNode.right = x;
        x.right.left = x;
        x.parent = null;
        x.mark = false;
    }

    protected void link(FibonacciHeapNode y, FibonacciHeapNode x) {
        y.left.right = y.right;
        y.right.left = y.left;
        y.parent = x;
        if (x.child == null) {
            x.child = y;
            y.right = y;
            y.left = y;
        } else {
            y.left = x.child;
            y.right = x.child.right;
            x.child.right = y;
            y.right.left = y;
        }
        ++x.degree;
        y.mark = false;
    }
}

