/*
 * Decompiled with CFR 0.152.
 */
package edu.upc.dama.dex.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.zip.GZIPInputStream;

public abstract class IOLib {
    public static boolean isUrlString(String s) {
        return s.startsWith("http:/") || s.startsWith("ftp:/") || s.startsWith("file:/");
    }

    public static URL urlFromString(String location) {
        return IOLib.urlFromString(location, null, true);
    }

    public static URL urlFromString(String location, Class referrer, boolean includeFileSystem) {
        URL url = null;
        if (IOLib.isUrlString(location)) {
            try {
                url = new URL(location);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            url = referrer != null ? referrer.getResource(location) : IOLib.class.getResource(location);
            if (url == null && !location.startsWith("/")) {
                url = IOLib.class.getResource("/" + location);
            }
            if (includeFileSystem && url == null && new File(location).exists()) {
                try {
                    url = new URL("file:///" + location);
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }
        return url;
    }

    public static InputStream streamFromString(String location) throws IOException {
        InputStream is = null;
        URL url = IOLib.urlFromString(location, null, false);
        if (url != null) {
            is = url.openStream();
        } else {
            File f = new File(location);
            if (f.exists()) {
                is = new FileInputStream(f);
            }
        }
        if (is == null) {
            return null;
        }
        if (IOLib.isGZipFile(location)) {
            return new GZIPInputStream(is);
        }
        return is;
    }

    public static String getExtension(File f) {
        return f != null ? IOLib.getExtension(f.getName()) : null;
    }

    public static boolean isGZipFile(String file) {
        String ext = IOLib.getExtension(file);
        return "gz".equals(ext) || "z".equals(ext);
    }

    public static boolean isZipFile(String file) {
        return "zip".equals(IOLib.getExtension(file));
    }

    public static String getExtension(String filename) {
        int i = filename.lastIndexOf(46);
        if (i > 0 && i < filename.length() - 1) {
            return filename.substring(i + 1).toLowerCase();
        }
        return null;
    }
}

