/*
 * Decompiled with CFR 0.152.
 */
package edu.upc.dama.dex.algorithms;

import edu.upc.dama.dex.algorithms.SinglePairShortestPath;
import edu.upc.dama.dex.algorithms.navigation.EdgeNavigation;
import edu.upc.dama.dex.core.Graph;
import edu.upc.dama.dex.core.Objects;
import edu.upc.dama.dex.core.Value;
import edu.upc.dama.dex.tasks.ForEachTask;
import edu.upc.dama.dex.tasks.IfTask;
import edu.upc.dama.dex.tasks.ParallelTask;
import edu.upc.dama.dex.tasks.Scheduler;
import edu.upc.dama.dex.tasks.SerialTask;
import edu.upc.dama.dex.tasks.Task;
import edu.upc.dama.dex.tasks.WhileTask;
import java.util.HashSet;
import java.util.Iterator;

public class SinglePairShortestPathBFS
extends SinglePairShortestPath {
    private Objects nodesCurrentLevel;
    private Objects.Iterator nodesCurrentLevelIt;
    private Objects nodesNextLevel;
    private Objects nodesLevelSwap;
    private long currentLevel = 0L;
    private Objects nodesVisited;
    private long pred_attr;
    public static Object LOCK = new Object();

    public SinglePairShortestPathBFS(Graph graph, long source, long dest) {
        super(graph, source, dest);
        this.aEdges = new HashSet();
        this.nodesCurrentLevel = new Objects(this.gr.getSession());
        this.nodesNextLevel = new Objects(this.gr.getSession());
        this.nodesVisited = new Objects(this.gr.getSession());
        this.pred_attr = 0L;
        this.createPredecessorAttribute();
        this.init(new UnweightedEdgesTask());
    }

    public void addAllEdges(short navigation) {
        this.addAllEdges_(navigation);
    }

    public void addEdge(int edgetype, short navigation) {
        this.addEdge_(edgetype, navigation);
    }

    public void close() {
        this.assertNotClosed();
        if (this.aEdges != null) {
            this.aEdges.clear();
        }
        if (this.nodesCurrentLevelIt != null && this.nodesCurrentLevelIt.isOpen()) {
            this.nodesCurrentLevelIt.close();
        }
        if (this.nodesCurrentLevel != null && this.nodesCurrentLevel.isOpen()) {
            this.nodesCurrentLevel.close();
        }
        if (this.nodesNextLevel != null && this.nodesNextLevel.isOpen()) {
            this.nodesNextLevel.close();
        }
        if (this.nodesVisited != null && this.nodesVisited.isOpen()) {
            this.nodesVisited.close();
        }
        if (this.nodesLevelSwap != null && this.nodesLevelSwap.isOpen()) {
            this.nodesLevelSwap.close();
        }
        this.dropPredecessorAttribute();
        this.closed = true;
    }

    public int getCost() {
        this.assertNotClosed();
        this.assertComputed();
        if (this.computed && !this.existsShortestPath) {
            return -1;
        }
        return this.pathAsEdges.length;
    }

    public void run() throws Throwable {
        this.assertNotClosed();
        this.assertNotComputed();
        this.assertAddedEdges();
        Scheduler.addAndWait(new UnweightedEdgesTask());
    }

    private void createPredecessorAttribute() {
        this.pred_attr = this.gr.newTransientAttribute(1, (short)6, (short)0);
    }

    private void dropPredecessorAttribute() {
        if (this.pred_attr == 0L) {
            this.close();
            throw new IllegalStateException("Error while closing  the operation.");
        }
        this.gr.removeAttribute(this.pred_attr);
    }

    private class UnweightedEdgesTask
    extends SerialTask {
        private UnweightedEdgesTask() {
        }

        protected boolean execute() {
            this.add(new AddInfoToNodeTask(SinglePairShortestPathBFS.this.src, 0L, true));
            this.add(new BeforeExecuteUnWeigtedEdgesTask());
            this.add(new ExecuteUnweightedEdgesTask());
            this.add(new AfterUnweightedEdgesTask());
            return false;
        }
    }

    private class AddInfoToNodeInQueueTask
    extends IfTask {
        private long idNode;
        private long idNodePred;

        public AddInfoToNodeInQueueTask(long idNode, long idNodePred) {
            this.idNode = idNode;
            this.idNodePred = idNodePred;
        }

        protected boolean ifCondition() {
            boolean found;
            boolean bl = found = SinglePairShortestPathBFS.this.dst == this.idNode;
            if (SinglePairShortestPathBFS.this.MAX_HOPS == -1) {
                return false;
            }
            return found && SinglePairShortestPathBFS.this.currentLevel + 1L == (long)SinglePairShortestPathBFS.this.MAX_HOPS;
        }

        protected void thenBody() {
            this.add(new AddInfoToNodeTask(this.idNode, this.idNodePred, false));
        }
    }

    private class AddInfoToNodeNotInQueueTask
    extends IfTask {
        private long idNode;
        private long idNodePred;

        public AddInfoToNodeNotInQueueTask(long idNode, long idNodePred) {
            this.idNode = idNode;
            this.idNodePred = idNodePred;
        }

        protected boolean ifCondition() {
            boolean addInfo;
            boolean visited = SinglePairShortestPathBFS.this.nodesVisited.exists(this.idNode);
            boolean findShortestPathCycle = visited && SinglePairShortestPathBFS.this.dst == this.idNode && SinglePairShortestPathBFS.this.src == this.idNode;
            boolean bl = addInfo = !visited || findShortestPathCycle;
            if (SinglePairShortestPathBFS.this.MAX_HOPS == -1) {
                return addInfo;
            }
            return addInfo && SinglePairShortestPathBFS.this.currentLevel + 1L < (long)SinglePairShortestPathBFS.this.MAX_HOPS;
        }

        protected void thenBody() {
            this.add(new AddInfoToNodeTask(this.idNode, this.idNodePred, true));
        }
    }

    private class ExistsShortestPathTask
    extends IfTask {
        private long idNode;

        public ExistsShortestPathTask(long idNode) {
            this.idNode = idNode;
        }

        protected boolean ifCondition() {
            boolean exists;
            boolean bl = exists = SinglePairShortestPathBFS.this.dst == this.idNode;
            if (SinglePairShortestPathBFS.this.MAX_HOPS == -1) {
                return exists;
            }
            return exists && SinglePairShortestPathBFS.this.currentLevel + 1L <= (long)SinglePairShortestPathBFS.this.MAX_HOPS;
        }

        protected void thenBody() {
            SinglePairShortestPathBFS.this.existsShortestPath = true;
        }
    }

    private class AddInfoToNodeTask
    extends Task {
        private long idNode;
        private long idNodePred;
        private boolean addToQueue;

        public AddInfoToNodeTask(long idNode, long idNodePred, boolean addToQueue) {
            this.idNode = idNode;
            this.idNodePred = idNodePred;
            this.addToQueue = addToQueue;
        }

        protected boolean execute() {
            SinglePairShortestPathBFS.this.gr.setAttribute(this.idNode, SinglePairShortestPathBFS.this.pred_attr, new Value(this.idNodePred));
            if (this.addToQueue) {
                SinglePairShortestPathBFS.this.nodesNextLevel.add(this.idNode);
                SinglePairShortestPathBFS.this.nodesVisited.add(this.idNode);
            }
            return false;
        }
    }

    private class ExecuteVisitNeighborsOfATypeTask
    extends ParallelTask {
        private long idNeighbor;
        private long idNode;

        public ExecuteVisitNeighborsOfATypeTask(long idNeighbor, long idNode) {
            this.idNeighbor = idNeighbor;
            this.idNode = idNode;
        }

        protected boolean execute() {
            this.add(new AddInfoToNodeNotInQueueTask(this.idNeighbor, this.idNode));
            this.add(new AddInfoToNodeInQueueTask(this.idNeighbor, this.idNode));
            this.add(new ExistsShortestPathTask(this.idNeighbor));
            return false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class VisitNeighborsOfATypeTask
    extends ForEachTask<Long> {
        private EdgeNavigation edge;
        private Objects neighborsNodeFirst;
        private long idNodeFirst;

        public VisitNeighborsOfATypeTask(EdgeNavigation edge, long idNodeFirst) {
            this.edge = edge;
            this.idNodeFirst = idNodeFirst;
        }

        @Override
        protected void before() {
            int type = this.edge.getType();
            short direction = this.edge.getDirection();
            this.neighborsNodeFirst = SinglePairShortestPathBFS.this.gr.neighbors(this.idNodeFirst, type, direction);
            this.setIterable(this.neighborsNodeFirst);
        }

        @Override
        protected void operate(Long element) {
            this.add(new ExecuteVisitNeighborsOfATypeTask(element, this.idNodeFirst));
        }

        @Override
        protected void after() {
            this.neighborsNodeFirst.close();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class VisitFirstQueueTask
    extends ForEachTask<EdgeNavigation> {
        private long idNodeFirst;

        private VisitFirstQueueTask() {
        }

        @Override
        protected void before() {
            this.idNodeFirst = SinglePairShortestPathBFS.this.nodesCurrentLevelIt.next();
            this.setIterable(SinglePairShortestPathBFS.this.aEdges);
        }

        @Override
        protected void operate(EdgeNavigation element) {
            if (SinglePairShortestPathBFS.this.MAX_HOPS != -1 && SinglePairShortestPathBFS.this.currentLevel >= (long)SinglePairShortestPathBFS.this.MAX_HOPS) {
                this.stop();
            } else {
                this.add(new VisitNeighborsOfATypeTask(element, this.idNodeFirst));
            }
        }

        @Override
        protected void after() {
            if (!SinglePairShortestPathBFS.this.nodesCurrentLevelIt.hasNext() && !SinglePairShortestPathBFS.this.existsShortestPath) {
                SinglePairShortestPathBFS.this.currentLevel = SinglePairShortestPathBFS.this.currentLevel + 1L;
                SinglePairShortestPathBFS.this.nodesLevelSwap = SinglePairShortestPathBFS.this.nodesCurrentLevel;
                SinglePairShortestPathBFS.this.nodesCurrentLevelIt.close();
                SinglePairShortestPathBFS.this.nodesCurrentLevel = SinglePairShortestPathBFS.this.nodesNextLevel;
                SinglePairShortestPathBFS.this.nodesCurrentLevelIt = SinglePairShortestPathBFS.this.nodesCurrentLevel.iterator();
                SinglePairShortestPathBFS.this.nodesLevelSwap.clear();
                SinglePairShortestPathBFS.this.nodesNextLevel = SinglePairShortestPathBFS.this.nodesLevelSwap;
            }
        }
    }

    private class AfterUnweightedEdgesTask
    extends Task {
        private AfterUnweightedEdgesTask() {
        }

        protected boolean execute() {
            if (!SinglePairShortestPathBFS.this.existsShortestPath) {
                return false;
            }
            int sizeArray = new Long(SinglePairShortestPathBFS.this.currentLevel).intValue() + 2;
            SinglePairShortestPathBFS.this.pathAsNodes = new long[sizeArray];
            SinglePairShortestPathBFS.this.pathAsEdges = new long[sizeArray - 1];
            SinglePairShortestPathBFS.this.pathAsNodes[sizeArray - 1] = SinglePairShortestPathBFS.this.dst;
            long idNode = SinglePairShortestPathBFS.this.dst;
            long idEdge = 0L;
            for (int index = new Long(SinglePairShortestPathBFS.this.currentLevel).intValue(); index >= 0; --index) {
                long idNodePred = SinglePairShortestPathBFS.this.gr.getAttribute(idNode, SinglePairShortestPathBFS.this.pred_attr).getLong();
                idEdge = this.getEdgeShortestPath(idNode, idNodePred);
                SinglePairShortestPathBFS.this.pathAsNodes[index] = idNodePred;
                SinglePairShortestPathBFS.this.pathAsEdges[index] = idEdge;
                idNode = idNodePred;
                idEdge = 0L;
            }
            return false;
        }

        private long getEdgeShortestPath(long idNode, long idNodePred) {
            long idEdge = 0L;
            Iterator it = SinglePairShortestPathBFS.this.aEdges.iterator();
            while (it.hasNext() && idEdge == 0L) {
                EdgeNavigation edge = (EdgeNavigation)it.next();
                if (edge.getDirection() == 1) {
                    idEdge = SinglePairShortestPathBFS.this.gr.findEdge(idNode, idNodePred, edge.getType());
                    continue;
                }
                if (edge.getDirection() == 2) {
                    idEdge = SinglePairShortestPathBFS.this.gr.findEdge(idNodePred, idNode, edge.getType());
                    continue;
                }
                if (edge.getDirection() != 3 || (idEdge = SinglePairShortestPathBFS.this.gr.findEdge(idNodePred, idNode, edge.getType())) != 0L) continue;
                idEdge = SinglePairShortestPathBFS.this.gr.findEdge(idNode, idNodePred, edge.getType());
            }
            return idEdge;
        }
    }

    private class ExecuteUnweightedEdgesTask
    extends WhileTask {
        private ExecuteUnweightedEdgesTask() {
        }

        protected boolean whileCondition() {
            boolean finished;
            boolean bl = finished = !SinglePairShortestPathBFS.this.existsShortestPath && SinglePairShortestPathBFS.this.nodesCurrentLevelIt.hasNext();
            if (SinglePairShortestPathBFS.this.MAX_HOPS != -1) {
                return finished && SinglePairShortestPathBFS.this.currentLevel < (long)SinglePairShortestPathBFS.this.MAX_HOPS;
            }
            return finished;
        }

        protected void whileBody() {
            this.add(new VisitFirstQueueTask());
        }

        protected void after() {
            SinglePairShortestPathBFS.this.computed = true;
        }
    }

    private class BeforeExecuteUnWeigtedEdgesTask
    extends Task {
        private BeforeExecuteUnWeigtedEdgesTask() {
        }

        protected boolean execute() {
            SinglePairShortestPathBFS.this.nodesLevelSwap = SinglePairShortestPathBFS.this.nodesCurrentLevel;
            SinglePairShortestPathBFS.this.nodesCurrentLevel = SinglePairShortestPathBFS.this.nodesNextLevel;
            SinglePairShortestPathBFS.this.nodesCurrentLevelIt = SinglePairShortestPathBFS.this.nodesCurrentLevel.iterator();
            SinglePairShortestPathBFS.this.nodesLevelSwap.clear();
            SinglePairShortestPathBFS.this.nodesNextLevel = SinglePairShortestPathBFS.this.nodesLevelSwap;
            return false;
        }
    }
}

