/*
 * Decompiled with CFR 0.152.
 */
package edu.upc.dama.dex.algorithms;

import edu.upc.dama.dex.algorithms.Traversal;
import edu.upc.dama.dex.algorithms.navigation.EdgeNavigation;
import edu.upc.dama.dex.core.Graph;
import edu.upc.dama.dex.core.Objects;
import edu.upc.dama.dex.utils.Queue;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class TraversalBFS
extends Traversal {
    private Queue queue = new Queue(this.gr.getSession());
    private long currentLevel;
    private long idNodeFirstQueue;
    private Objects nodesVisited = new Objects(this.gr.getSession());
    private boolean addedNextLevel = false;

    public TraversalBFS(Graph graph, long source) {
        super(graph, source);
        this.initializeQueue();
    }

    public void close() {
        this.assertNotClosed();
        if (this.aEdges != null) {
            this.aEdges.clear();
        }
        if (this.aNodes != null) {
            this.aNodes.clear();
        }
        if (this.queue != null) {
            this.queue.close();
        }
        if (this.nodesVisited != null && this.nodesVisited.isOpen()) {
            this.nodesVisited.close();
        }
        this.closed = true;
    }

    public long getCurrentDepth() {
        this.assertNotClosed();
        if (this.idNodeFirstQueue == 0L) {
            this.close();
            throw new IllegalStateException("The graph traversal has not been started yet.");
        }
        return this.currentLevel;
    }

    public boolean hasNext() {
        this.assertNotClosed();
        if (!this.parametersChecked) {
            this.assertInitialized();
            this.parametersChecked = true;
        }
        return !this.queue.isEmpty();
    }

    public Long next() {
        if (!this.hasNext()) {
            this.close();
            throw new NoSuchElementException("There are no more elements.");
        }
        long idNode = this.computeNext();
        return idNode;
    }

    public void remove() {
        this.close();
        throw new UnsupportedOperationException("Operation not supported.");
    }

    protected void addInfoToAuxiliarStructure(EdgeNavigation edge) {
    }

    protected void setInfoToAuxiliarStructure() {
    }

    private void addInfoToNodeQueue(long idNode) {
        this.nodesVisited.add(idNode);
        if (!this.addedNextLevel) {
            this.addLevelToQueue(this.currentLevel + 1L);
            this.addedNextLevel = true;
        }
        this.queue.enqueue(idNode);
    }

    private void addLevelToQueue(long level) {
        this.queue.enqueue(0L);
        this.queue.enqueue(level);
    }

    private long computeNext() {
        this.idNodeFirstQueue = this.queue.dequeue();
        if (this.idNodeFirstQueue == 0L) {
            if (!this.queue.isEmpty()) {
                this.currentLevel = this.queue.dequeue();
                this.addedNextLevel = false;
            }
            if (!this.queue.isEmpty()) {
                this.idNodeFirstQueue = this.queue.dequeue();
            }
        }
        if (this.idNodeFirstQueue != 0L) {
            this.visitNeighbors();
        }
        return this.idNodeFirstQueue;
    }

    private void initializeQueue() {
        this.addLevelToQueue(0L);
        this.nodesVisited.add(this.src);
        this.queue.enqueue(this.src);
    }

    private void visitNeighbor(long idNodeNeigh) {
        boolean visited = this.nodesVisited.exists(idNodeNeigh);
        int nodetype = this.gr.getType(idNodeNeigh);
        boolean isAllowed = this.aNodes.contains(nodetype);
        if (!visited && isAllowed) {
            this.addInfoToNodeQueue(idNodeNeigh);
        }
    }

    private void visitNeighbors() {
        Iterator aEdgesIt = this.aEdges.iterator();
        while (aEdgesIt.hasNext()) {
            this.visitNeighborsOfAType((EdgeNavigation)aEdgesIt.next());
        }
    }

    private void visitNeighborsOfAType(EdgeNavigation edgeinfo) {
        Objects neighbors = this.gr.neighbors(this.idNodeFirstQueue, edgeinfo.getType(), edgeinfo.getDirection());
        Objects.Iterator neighborsFirstIt = neighbors.iterator();
        while (neighborsFirstIt.hasNext()) {
            this.visitNeighbor(neighborsFirstIt.next());
        }
        neighborsFirstIt.close();
        neighbors.close();
    }
}

