/*
 * Decompiled with CFR 0.152.
 */
package edu.upc.dama.dex.tasks;

import edu.upc.dama.dex.tasks.ListenerTask;
import edu.upc.dama.dex.tasks.Task;
import edu.upc.dama.dex.tasks.TaskListener;
import edu.upc.dama.dex.tasks.WaitTask;
import edu.upc.dama.dex.utils.DEXConfig;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.LinkedBlockingQueue;

public class Scheduler {
    private static final int WORKERS_COUNT;
    private static final BlockingQueue<Task> taskQueue;
    private static final ThreadLocal<Task> contextTask;
    private static final ConcurrentMap<Task, Task> registeredTasks;
    private static final Worker[] workers;

    static void enqueueTask(Task task) {
        try {
            taskQueue.put(task);
        }
        catch (InterruptedException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static void add(Task task) {
        if (task == null) {
            throw new NullPointerException("Illegal argument: task cannot be null");
        }
        Task currentTask = contextTask.get();
        if (currentTask == null) {
            throw new IllegalStateException("cannot add tasks now");
        }
        currentTask.add(task);
    }

    static Task setContextTask(Task context) {
        Task previous = contextTask.get();
        contextTask.set(context);
        return previous;
    }

    static boolean execute(Task task) {
        boolean result;
        try {
            while ((result = task.execute()) && taskQueue.isEmpty()) {
            }
            if (!result) {
                try {
                    task.success();
                }
                catch (Throwable th) {
                    System.err.println("task.sucess() failure!");
                    th.printStackTrace();
                }
            } else {
                Scheduler.enqueueTask(task);
            }
        }
        catch (Throwable ex) {
            result = false;
            task.fail(ex);
        }
        return result;
    }

    public static void addAndWait(Task task) throws Throwable {
        if (task == null) {
            throw new NullPointerException("Illegal argument: task cannot be null");
        }
        if (Thread.currentThread() instanceof Worker) {
            throw new IllegalStateException("cannot add tasks and wait tasks from other tasks");
        }
        WaitTask waitTask = new WaitTask(task);
        Scheduler.enqueueTask(waitTask);
        waitTask.waitTask();
    }

    public static void addAndListen(Task task, TaskListener listener) {
        if (task == null) {
            throw new NullPointerException("Illegal argument: task cannot be null");
        }
        if (Thread.currentThread() instanceof Worker) {
            throw new IllegalStateException("cannot add tasks and wait tasks from other tasks");
        }
        ListenerTask listenerTask = new ListenerTask(task, listener);
        Scheduler.enqueueTask(listenerTask);
    }

    public static boolean cancel(Task task) {
        Task parent = (Task)registeredTasks.get(task);
        if (parent != null && registeredTasks.remove(task, parent)) {
            parent.cancel();
            return true;
        }
        return false;
    }

    static void register(Task child, Task parent) {
        if (registeredTasks.putIfAbsent(child, parent) != null) {
            throw new IllegalArgumentException("illegal task: task already added");
        }
    }

    static void unregister(Task child) {
        registeredTasks.remove(child);
    }

    static int getWorkerSetSize() {
        return WORKERS_COUNT;
    }

    static {
        int i;
        WORKERS_COUNT = DEXConfig.getInt("dex.tasks.workers");
        taskQueue = new LinkedBlockingQueue<Task>();
        contextTask = new ThreadLocal();
        registeredTasks = new ConcurrentHashMap<Task, Task>();
        workers = new Worker[WORKERS_COUNT];
        for (i = 0; i < WORKERS_COUNT; ++i) {
            Scheduler.workers[i] = new Worker(i);
        }
        for (i = 0; i < WORKERS_COUNT; ++i) {
            workers[i].start();
        }
    }

    private static final class Worker
    extends Thread {
        public Worker(int i) {
            super("Worker" + i);
            this.setDaemon(true);
        }

        public void run() {
            while (true) {
                Task task = null;
                try {
                    task = (Task)taskQueue.take();
                    Scheduler.execute(task);
                    continue;
                }
                catch (InterruptedException ex) {
                    ex.printStackTrace();
                    continue;
                }
                break;
            }
        }
    }
}

