/*
 * Decompiled with CFR 0.152.
 */
package edu.upc.dama.dex.utils;

import edu.upc.dama.dex.core.GraphPool;
import java.io.IOException;
import java.io.PrintStream;

public class Monitor
implements Runnable {
    private static final long FREQ = 5000L;
    private GraphPool gpool = null;
    private PrintStream ps = null;
    private long freq = 5000L;

    public Monitor(GraphPool gpool, PrintStream ps) throws IOException {
        this(gpool, ps, 5);
    }

    public Monitor(GraphPool gpool, PrintStream ps, int freq) throws IOException {
        this.gpool = gpool;
        this.ps = ps;
        this.freq = freq * 1000;
    }

    public void run() {
        this.ps.print("TIMESTAMP;GRAPHS;IN;OUT;TEMP;CACHE;DATA");
        this.ps.println();
        long tm = System.currentTimeMillis();
        boolean exit = false;
        while (!exit) {
            GraphPool.Statistics stats = this.gpool.getStatistics();
            this.print(System.currentTimeMillis() - tm, stats);
            try {
                Thread.sleep(this.freq);
            }
            catch (InterruptedException ex) {
                exit = true;
            }
        }
    }

    private void print(long tmstmp, GraphPool.Statistics stats) {
        this.ps.printf("%8d", tmstmp);
        this.ps.printf(";%8d;%8d;%8d;%8d;%8d", stats.in, stats.out, stats.temp, stats.cache, stats.data);
        this.ps.println();
        this.ps.flush();
    }
}

