/*
 * Decompiled with CFR 0.152.
 */
package edu.upc.dama.dex.algorithms.navigation;

import edu.upc.dama.dex.algorithms.navigation.EdgeNavigation;
import edu.upc.dama.dex.core.Graph;
import java.util.Set;

public class WeightedEdgeNavigation
extends EdgeNavigation {
    private long attrtype;

    public WeightedEdgeNavigation(Graph graph, int edgetype, short edgedirection, long attributetype) {
        super(graph, edgetype, edgedirection);
        this.assertEdgeAttributeType(graph, attributetype);
        this.attrtype = attributetype;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        WeightedEdgeNavigation other = (WeightedEdgeNavigation)obj;
        if (this.eType != other.eType) {
            return false;
        }
        if (this.direction != other.direction) {
            return false;
        }
        return this.attrtype == other.attrtype;
    }

    public long getAttributeType() {
        return this.attrtype;
    }

    public int hashCode() {
        int hash = 5;
        hash = 53 * hash + this.eType;
        hash = 53 * hash + this.direction;
        hash = 53 * hash + (int)(this.attrtype ^ this.attrtype >>> 32);
        return hash;
    }

    private void assertEdgeAttributeType(Graph graph, long attributetype) {
        Set<Long> attrs = graph.getAttributesFromType(this.eType);
        if (!attrs.contains(attributetype)) {
            throw new IllegalArgumentException("The given attribute type " + attributetype + " is not " + "valid.");
        }
    }
}

