/*
 * Decompiled with CFR 0.152.
 */
package edu.upc.dama.dex.tasks;

import edu.upc.dama.dex.core.Objects;
import edu.upc.dama.dex.tasks.Scheduler;
import edu.upc.dama.dex.tasks.Task;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ForEachTask<V>
extends Task {
    private final int PHASE_BEFORE = 1;
    private final int PHASE_OPERATE = 2;
    private final int PHASE_AFTER = 3;
    private final AtomicInteger currentPhase = new AtomicInteger(1);
    private static final int CHUNK = 100;
    private Iterator<V> iterator;
    private Iterable<V> iterable;
    private int maximumSize = Integer.MAX_VALUE;
    private boolean stop = false;
    private final Object LOCK = new Object();

    protected void before() throws Throwable {
    }

    protected abstract void operate(V var1) throws Throwable;

    protected void after() throws Throwable {
    }

    public ForEachTask() {
        this.incrementDependenceCount();
        this.incrementDependenceCount();
    }

    public void setIterator(Iterator<V> iterator) {
        if (iterator == null) {
            throw new NullPointerException("invalid argument: iterator cannot be null");
        }
        if (this.iterator != null) {
            throw new IllegalStateException("iterator already set");
        }
        if (this.iterable != null) {
            throw new IllegalStateException("iterable set");
        }
        this.iterator = iterator;
    }

    public void setIterable(Iterable<V> iterable) {
        if (iterable == null) {
            throw new NullPointerException("invalid argument: iterable cannot be null");
        }
        if (this.iterable != null) {
            throw new IllegalStateException("iterable already set");
        }
        if (this.iterator != null) {
            throw new IllegalStateException("iterable set");
        }
        if (iterable instanceof Collection) {
            this.maximumSize = ((Collection)iterable).size();
        }
        if (iterable instanceof Objects) {
            this.maximumSize = (int)Math.min(Integer.MAX_VALUE, (long)((Objects)iterable).size());
        }
        this.iterable = iterable;
    }

    @Override
    protected void add(Task childTask) {
        if (!this.hasException()) {
            this.registerChild(childTask);
            Scheduler.enqueueTask(childTask);
        }
    }

    @Override
    protected final boolean execute() throws Throwable {
        if (this.currentPhase.get() == 1) {
            this.before();
            if (this.getDependenceCount() == 3) {
                this.currentPhase.set(2);
                this.decrementDependenceCount();
            }
        }
        if (this.currentPhase.get() == 2) {
            this.operate();
            if (this.getDependenceCount() == 2) {
                this.currentPhase.set(3);
                this.decrementDependenceCount();
            }
        }
        if (this.currentPhase.get() == 3) {
            if (this.iterator != null && this.iterator instanceof Closeable) {
                Closeable it = (Closeable)((Object)this.iterator);
                it.close();
            }
            this.after();
        }
        return false;
    }

    private void operate() throws Throwable {
        if (this.iterator == null) {
            if (this.iterable == null) {
                throw new IllegalStateException("Iterator or Iterable not set.");
            }
            this.iterator = this.iterable.iterator();
        }
        if (this.getDependenceCount() == 2 && this.maximumSize < 100) {
            while (this.iterator.hasNext()) {
                this.operate(this.iterator.next());
            }
        } else {
            int count = Math.min(Scheduler.getWorkerSetSize(), this.maximumSize / 100);
            for (int i = 0; i < count; ++i) {
                this.add(new Worker());
            }
        }
    }

    @Override
    boolean success() {
        boolean result = super.success();
        if (!result) {
            int dependenceCount = this.getDependenceCount();
            if (dependenceCount == 2) {
                if (this.currentPhase.compareAndSet(1, 2)) {
                    if (!this.hasException()) {
                        Scheduler.enqueueTask(this);
                    } else {
                        result = super.finish();
                    }
                }
            } else if (dependenceCount == 1 && this.currentPhase.compareAndSet(2, 3)) {
                if (!this.hasException()) {
                    Scheduler.enqueueTask(this);
                } else {
                    result = super.finish();
                }
            }
        }
        return result;
    }

    @Override
    boolean fail(Throwable th) {
        boolean result = super.fail(th);
        if (!result) {
            if (this.currentPhase.compareAndSet(1, 2)) {
                result = super.finish();
            }
            if (this.currentPhase.compareAndSet(2, 3)) {
                result = super.finish();
            }
        }
        return result;
    }

    public void stop() {
        this.stop = true;
    }

    public static void main(String[] p) throws Throwable {
        ForEachTask<Integer> simple = new ForEachTask<Integer>(){

            @Override
            protected void before() {
                System.out.println("BEFORE");
                ArrayList<Integer> list = new ArrayList<Integer>();
                for (int i = 0; i < 10; ++i) {
                    list.add(i);
                }
                this.setIterable(list);
            }

            @Override
            protected void operate(Integer element) {
                System.out.println("Element: " + element);
            }

            @Override
            protected void after() {
                System.out.println("AFTER");
            }
        };
        ForEachTask<Integer> nested = new ForEachTask<Integer>(){

            @Override
            protected void before() {
                System.out.println("BEFORE");
                final ArrayList list = new ArrayList();
                this.setIterable(list);
                this.add(new Task(){
                    private int i = 0;

                    protected boolean execute() throws Throwable {
                        list.add(this.i);
                        ++this.i;
                        return this.i < 10;
                    }
                });
            }

            @Override
            protected void operate(final Integer element) {
                this.add(new Task(){
                    List<Integer> list = new ArrayList<Integer>();
                    private int i = 0;

                    protected boolean execute() throws Throwable {
                        this.list.add(this.i);
                        ++this.i;
                        if (this.i <= element) {
                            return true;
                        }
                        this.add(new ForEachTask(){

                            protected void before() {
                                this.setIterable(list);
                            }

                            protected void operate(Object j) {
                                System.out.println("Element: " + element + "," + j);
                            }
                        });
                        return false;
                    }
                });
            }

            @Override
            protected void after() {
                System.out.println("AFTER");
            }
        };
        Scheduler.addAndWait(simple);
        Scheduler.addAndWait(nested);
    }

    private class Worker
    extends Task {
        private Worker() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected boolean execute() throws Throwable {
            boolean more = !ForEachTask.this.stop;
            Object v = null;
            for (int i = 0; i < 100 && more; ++i) {
                Object object = ForEachTask.this.LOCK;
                synchronized (object) {
                    more = ForEachTask.this.iterator.hasNext();
                    if (more) {
                        v = ForEachTask.this.iterator.next();
                    }
                }
                if (!more) continue;
                ForEachTask.this.operate(v);
            }
            return more;
        }
    }
}

