/*
 * Decompiled with CFR 0.152.
 */
package edu.upc.dama.dex.algorithms.navigation;

import edu.upc.dama.dex.core.Graph;

public abstract class EdgeNavigation {
    protected int eType;
    protected short direction;

    public EdgeNavigation(Graph graph, int edgetype, short edgedirection) {
        this.assertDirection(edgedirection);
        this.assertEdgeType(graph, edgetype);
        this.eType = edgetype;
        this.direction = edgedirection;
    }

    public int getType() {
        return this.eType;
    }

    public short getDirection() {
        return this.direction;
    }

    private void assertDirection(short edgedirection) {
        switch (edgedirection) {
            case 3: {
                break;
            }
            case 2: {
                break;
            }
            case 1: {
                break;
            }
            default: {
                throw new IllegalArgumentException("The given edge direction " + edgedirection + " is not " + "valid.");
            }
        }
    }

    private void assertEdgeType(Graph graph, int edgetype) {
        if (!graph.isTypeEdge(edgetype)) {
            throw new IllegalArgumentException("The given edge type " + edgetype + " doesn't exist " + "in the graph.");
        }
    }
}

