/*
 * Decompiled with CFR 0.152.
 */
package edu.upc.dama.dex.core;

import com.sparsity.dex.gdb.Dex;
import com.sparsity.dex.gdb.DexConfig;
import com.sparsity.dex.gdb.LogLevel;
import com.sparsity.dex.gdb.Platform;
import com.sparsity.dex.gdb.PlatformStatistics;
import edu.upc.dama.dex.core.GraphPool;
import edu.upc.dama.dex.monitor.Monitor;
import edu.upc.dama.dex.utils.DEXConfig;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DEX
implements Closeable {
    private Dex handle = null;
    private Monitor monitor = null;
    private ArrayList<GraphPool> gpools = new ArrayList();

    synchronized void register(GraphPool gp) {
        this.gpools.add(gp);
    }

    synchronized void unregister(GraphPool gp) {
        this.gpools.remove(gp);
    }

    public DEX(String license) {
        Config cfg = new Config();
        cfg.setLicense(license);
        this.init(cfg);
    }

    public DEX(Config cfg) {
        this.init(cfg);
    }

    public DEX() {
        this.init(new Config());
    }

    public Dex getHandle() {
        return this.handle;
    }

    private static long timeUnitToMicroseconds(String str, long def) {
        str = str.trim();
        long ret = 0L;
        long factor = 1L;
        try {
            char last = str.charAt(str.length() - 1);
            if ("DHMSsmu".indexOf(last) != -1) {
                ret = Long.parseLong(str.substring(0, str.length() - 1));
                switch (last) {
                    case 'D': {
                        factor *= 24L;
                    }
                    case 'H': {
                        factor *= 60L;
                    }
                    case 'M': {
                        factor *= 60L;
                    }
                    case 'S': 
                    case 's': {
                        factor *= 1000L;
                    }
                    case 'm': {
                        factor *= 1000L;
                    }
                }
            } else if (Character.isDigit(last)) {
                factor = 1000000L;
                ret = Long.parseLong(str);
            } else {
                return def;
            }
            return ret * factor;
        }
        catch (Exception e) {
            return def;
        }
    }

    void init(Config cfg) {
        DexConfig _cfg = new DexConfig();
        _cfg.setCacheMaxSize(cfg.getCacheMaxSize());
        _cfg.setPoolFrameSize(cfg.poolFrameSize);
        _cfg.setPoolPersistentMinSize(cfg.poolPersistentMinSize);
        _cfg.setPoolPersistentMaxSize(cfg.poolPersistentMaxSize);
        _cfg.setPoolTemporaryMinSize(cfg.poolTemporalMinSize);
        _cfg.setPoolTemporaryMaxSize(cfg.poolTemporalMaxSize);
        _cfg.setLicense(cfg.getLicense());
        _cfg.setExtentSize(cfg.extentSize);
        _cfg.setExtentPages(cfg.extentPages);
        _cfg.setRecoveryEnabled(cfg.recoveryEnabled);
        _cfg.setRecoveryLogFile(cfg.recoveryLogFile);
        _cfg.setRecoveryCacheMaxSize(cfg.recoveryCacheMaxSize);
        _cfg.setRecoveryCheckpointTime(DEX.timeUnitToMicroseconds(cfg.recoveryCheckpointTime, 60000000L));
        _cfg.setCacheStatisticsEnabled(cfg.statisticsEnabled);
        _cfg.setCacheStatisticsFile(cfg.statisticsFile);
        _cfg.setCacheStatisticsSnapshotTime(DEX.timeUnitToMicroseconds(cfg.statisticsSnapshotTime, 1000000L));
        _cfg.setHighAvailabilityEnabled(cfg.haEnabled);
        _cfg.setHighAvailabilityCoordinators(cfg.haCoordinators);
        _cfg.setHighAvailabilityIP(cfg.haIP);
        _cfg.setHighAvailabilitySynchronization(DEX.timeUnitToMicroseconds(cfg.haSync, 0L));
        _cfg.setHighAvailabilityMasterHistory(DEX.timeUnitToMicroseconds(cfg.haHistory, 500654080L));
        String[] logInfo = cfg.getLog().split(";");
        LogLevel logLevel = LogLevel.Off;
        boolean invalidLogLevel = false;
        if (0 == logInfo[0].compareToIgnoreCase("Off")) {
            logLevel = LogLevel.Off;
        } else if (0 == logInfo[0].compareToIgnoreCase("Severe")) {
            logLevel = LogLevel.Severe;
        } else if (0 == logInfo[0].compareToIgnoreCase("Warning")) {
            logLevel = LogLevel.Warning;
        } else if (0 == logInfo[0].compareToIgnoreCase("Info")) {
            logLevel = LogLevel.Info;
        } else if (0 == logInfo[0].compareToIgnoreCase("Config")) {
            logLevel = LogLevel.Config;
        } else if (0 == logInfo[0].compareToIgnoreCase("Fine")) {
            logLevel = LogLevel.Fine;
        } else if (0 == logInfo[0].compareToIgnoreCase("Debug")) {
            logLevel = LogLevel.Debug;
        } else {
            invalidLogLevel = true;
        }
        if (!invalidLogLevel) {
            _cfg.setLogLevel(logLevel);
            _cfg.setLogFile(cfg.getLog().substring(logInfo[0].length() + 1));
        }
        logInfo = null;
        this.handle = new Dex(_cfg);
        assert (this.handle != null);
        if (DEXConfig.getBoolean("dex.monitor.active")) {
            int port = DEXConfig.getInt("dex.monitor.port");
            this.monitor = new Monitor(this, port);
            try {
                this.monitor.start();
            }
            catch (Exception ex) {
                this.monitor = null;
            }
        }
    }

    public boolean isOpen() {
        return this.handle != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        if (this.isOpen()) {
            ArrayList<GraphPool> arrayList = this.gpools;
            synchronized (arrayList) {
                while (this.gpools.size() > 0) {
                    this.gpools.get(0).close();
                }
            }
            if (this.monitor != null && this.monitor.isActive()) {
                this.monitor.stop();
                this.monitor = null;
            }
            this.handle.close();
            this.handle = null;
        }
    }

    public GraphPool create(String img) throws FileNotFoundException {
        return this.create(img, this.extractAlias(new File(img)));
    }

    public GraphPool create(String img, String alias) throws FileNotFoundException {
        GraphPool gp = new GraphPool(this, this.handle.create(img, alias));
        this.register(gp);
        return gp;
    }

    public GraphPool create(File img) throws FileNotFoundException {
        return this.create(img.getPath(), this.extractAlias(img));
    }

    public GraphPool create(File img, String alias) throws FileNotFoundException {
        return this.create(img.getPath(), alias);
    }

    public GraphPool open(String img) throws FileNotFoundException {
        GraphPool gp = new GraphPool(this, this.handle.open(img, false));
        this.register(gp);
        return gp;
    }

    public GraphPool openReadOnly(String img) throws FileNotFoundException {
        GraphPool gp = new GraphPool(this, this.handle.open(img, true));
        this.register(gp);
        return gp;
    }

    public GraphPool open(File img) throws FileNotFoundException {
        return this.open(img.getPath());
    }

    public GraphPool openReadOnly(File img) throws FileNotFoundException {
        return this.openReadOnly(img.getPath());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<GraphPool> getGraphPools() {
        HashSet<GraphPool> hs = null;
        ArrayList<GraphPool> arrayList = this.gpools;
        synchronized (arrayList) {
            hs = new HashSet<GraphPool>(this.gpools);
        }
        return hs;
    }

    public static String getVersion() {
        return Dex.getVersion();
    }

    public static SystemStatistics getSystemStatistics() {
        PlatformStatistics sp = new PlatformStatistics();
        Platform.GetStatistics((PlatformStatistics)sp);
        SystemStatistics st = new SystemStatistics();
        st.availMem = sp.GetAvailableMem();
        st.cpu = sp.GetNumCPUs();
        st.realTime = sp.GetRealTime();
        st.sysTime = sp.GetSystemTime();
        st.totalMem = sp.GetTotalMem();
        st.userTime = sp.GetUserTime();
        return st;
    }

    private String extractAlias(File img) {
        String s = img.getName();
        int pos = s.lastIndexOf(46);
        if (pos != -1) {
            s = s.substring(0, pos);
        }
        return s;
    }

    public static class Config {
        private int poolFrameSize = DEXConfig.getInt("dex.io.pool.frame.size");
        private int poolPersistentMinSize = DEXConfig.getInt("dex.io.pool.persistent.minsize");
        private int poolPersistentMaxSize = DEXConfig.getInt("dex.io.pool.persistent.maxsize");
        private int poolTemporalMinSize = DEXConfig.getInt("dex.io.pool.temporal.minsize");
        private int poolTemporalMaxSize = DEXConfig.getInt("dex.io.pool.temporal.maxsize");
        private int cacheMaxSize = DEXConfig.getInt("dex.io.cache.maxsize");
        private String license = DEXConfig.get("dex.license");
        private String log = DEXConfig.get("dex.log");
        private int extentSize = DEXConfig.getInt("dex.storage.extentsize");
        private int extentPages = DEXConfig.getInt("dex.storage.extentpages");
        private String recoveryLogFile;
        private boolean recoveryEnabled = DEXConfig.getBoolean("dex.io.recovery");
        private int recoveryCacheMaxSize;
        private String recoveryCheckpointTime;
        private boolean statisticsEnabled;
        private String statisticsFile;
        private String statisticsSnapshotTime;
        private boolean haEnabled;
        private String haIP;
        private String haCoordinators;
        private String haSync;
        private String haHistory;

        public Config() {
            this.recoveryLogFile = DEXConfig.get("dex.io.recovery.logfile");
            this.recoveryCacheMaxSize = DEXConfig.getInt("dex.io.recovery.cachesize");
            this.recoveryCheckpointTime = DEXConfig.get("dex.io.recovery.checkpointTime");
            this.statisticsEnabled = DEXConfig.getBoolean("dex.cache.statistics");
            this.statisticsFile = DEXConfig.get("dex.cache.statisticsFile");
            this.statisticsSnapshotTime = DEXConfig.get("dex.cache.statisticsSnapshotTime");
            this.haEnabled = DEXConfig.getBoolean("dex.ha");
            this.haCoordinators = DEXConfig.get("dex.ha.coordinators");
            this.haIP = DEXConfig.get("dex.ha.ip");
            this.haSync = DEXConfig.get("dex.ha.sync");
            this.haHistory = DEXConfig.get("dex.ha.master.history");
        }

        public void setCacheMaxSize(int value) {
            this.cacheMaxSize = value;
        }

        public int getCacheMaxSize() {
            return this.cacheMaxSize;
        }

        public void setLicense(String value) {
            this.license = value;
        }

        public String getLicense() {
            return this.license;
        }

        public void setLog(String value) {
            this.log = value;
        }

        public String getLog() {
            return this.log;
        }
    }

    public static class SystemStatistics {
        public int cpu;
        public long realTime;
        public long userTime;
        public long sysTime;
        public long totalMem;
        public long availMem;

        private SystemStatistics() {
        }
    }
}

