/*
 * Decompiled with CFR 0.152.
 */
package edu.upc.dama.dex.tasks;

import edu.upc.dama.dex.tasks.Scheduler;
import edu.upc.dama.dex.tasks.SerialTask;
import edu.upc.dama.dex.tasks.Task;

public class ContextTask
extends Task {
    private final Task subtask;
    private Task previousContextTask;

    public ContextTask(Task subtask) {
        if (subtask == null) {
            throw new NullPointerException("Illegal argument: subtask cannot be null");
        }
        this.subtask = subtask;
    }

    protected final boolean execute() throws Throwable {
        this.previousContextTask = Scheduler.setContextTask(this);
        this.registerChild(this.subtask);
        Scheduler.enqueueTask(this.subtask);
        return false;
    }

    boolean finish() {
        boolean result = super.finish();
        Scheduler.setContextTask(this.previousContextTask);
        return result;
    }

    public static void main(String[] p) throws Throwable {
        ContextTask contextTask = new ContextTask(new SerialTask(){

            protected boolean execute() throws Throwable {
                int i = 0;
                while (i < 5) {
                    final int n = i++;
                    Scheduler.add(new Task(){

                        protected boolean execute() throws Throwable {
                            System.out.println("Step " + n);
                            return false;
                        }
                    });
                }
                return false;
            }
        });
        Scheduler.addAndWait(contextTask);
    }
}

