/*
 * Decompiled with CFR 0.152.
 */
package edu.upc.dama.dex.tasks;

import edu.upc.dama.dex.tasks.Scheduler;
import edu.upc.dama.dex.tasks.SerialTask;
import edu.upc.dama.dex.tasks.Task;
import java.util.concurrent.atomic.AtomicBoolean;

public class TryCatchTask
extends Task {
    private Task subtask;
    private AtomicBoolean executed = new AtomicBoolean(false);

    public TryCatchTask(Task subtask) {
        if (subtask == null) {
            throw new NullPointerException("Illegal argument: subtask cannot be null");
        }
        this.subtask = subtask;
    }

    protected void onException(Throwable th) throws Throwable {
    }

    protected void onFinally() throws Throwable {
    }

    protected final boolean execute() throws Throwable {
        this.registerChild(this.subtask);
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean finish() {
        if (!this.executed.getAndSet(true)) {
            Scheduler.enqueueTask(this.subtask);
        } else {
            try {
                try {
                    if (this.hasException()) {
                        this.onException(this.getException());
                        this.setException(null);
                    }
                }
                finally {
                    this.onFinally();
                }
            }
            catch (Throwable th) {
                this.setException(th);
            }
        }
        boolean result = super.finish();
        return result;
    }

    public static void main(String[] p) throws Throwable {
        Task throwTask = new Task(){

            protected boolean execute() throws Throwable {
                throw new RuntimeException("THROW TASK EXCEPTION");
            }
        };
        SerialTask serial = new SerialTask(){

            protected boolean execute() throws Throwable {
                this.add(new Task(){

                    protected boolean execute() throws Throwable {
                        System.out.println("Step 1");
                        return false;
                    }
                });
                this.add(new Task(){
                    int i = 2;

                    protected boolean execute() throws Throwable {
                        System.out.println("Step " + this.i);
                        ++this.i;
                        if (this.i == 4) {
                            throw new RuntimeException("Step 4 EXPECTED TEST EXCEPTION");
                        }
                        return this.i < 5;
                    }
                });
                this.add(new Task(){

                    protected boolean execute() throws Throwable {
                        System.out.println("Step 5");
                        return false;
                    }
                });
                return false;
            }
        };
        Scheduler.addAndWait(new TryCatchTask(serial){

            protected void onException(Throwable th) throws Throwable {
                th.printStackTrace(System.out);
            }
        });
    }
}

