/*
 * Decompiled with CFR 0.152.
 */
package edu.upc.dama.dex.utils;

import edu.upc.dama.dex.core.DEX;
import edu.upc.dama.dex.core.Graph;
import edu.upc.dama.dex.core.GraphPool;
import edu.upc.dama.dex.core.Objects;
import edu.upc.dama.dex.core.Session;
import edu.upc.dama.dex.core.Value;
import edu.upc.dama.dex.io.CSVWriter;
import edu.upc.dama.dex.io.RowWriter;
import edu.upc.dama.dex.utils.CmdLineArgs;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Statistics {
    private Graph graph;
    private String path = new File(".").getAbsolutePath();
    private static final String OPT_HELP = "Help";
    private static final String OPT_IMAGE = "DEX graph-db image";
    private static final String OPT_PATH = "Results path";
    private static final String OPT_STATS = "Statistics";
    private static final String OPT_STATS_FLAGS = "D";
    private static final String OPT_STATS_FLAGS_DEFAULT = "D";

    public Statistics(Graph g) {
        this.graph = g;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void getDegreeStatistics() throws IOException {
        this.getDegreeStatistics(this.graph.nodeTypes(), this.graph.edgeTypes());
    }

    public void getDegreeStatistics(Set<Integer> nodeTypes, Set<Integer> edgeTypes) throws IOException {
        for (int nodeType : nodeTypes) {
            Objects o = this.graph.select(nodeType);
            for (int edgeType : edgeTypes) {
                Graph.TypeData edgeTypeData = this.graph.getTypeData(edgeType);
                if (edgeTypeData.isRestricted()) {
                    int[] typesRestricted = edgeTypeData.getRestricted();
                    if (nodeType == typesRestricted[0] && nodeType != typesRestricted[1]) {
                        this.writeDegreeStats(o, edgeType, (short)2);
                        continue;
                    }
                    if (nodeType != typesRestricted[0] && nodeType == typesRestricted[1]) {
                        this.writeDegreeStats(o, edgeType, (short)1);
                        continue;
                    }
                    if (typesRestricted[0] != typesRestricted[1] || nodeType != typesRestricted[0]) continue;
                    this.writeDegreeStats(o, edgeType, (short)3);
                    continue;
                }
                if (edgeTypeData.isUndirected()) {
                    this.writeDegreeStats(o, edgeType, (short)1);
                    continue;
                }
                this.writeDegreeStats(o, edgeType, (short)3);
            }
            o.close();
        }
    }

    private void writeDegreeStats(Objects nodes, int edgeType, short direction) throws IOException {
        if (nodes.size() == 0) {
            return;
        }
        HashMap<Long, Long> degrees = new HashMap<Long, Long>();
        String nodeTypeName = this.graph.getTypeData(this.graph.getType(nodes.first())).getName();
        String edgeTypeName = this.graph.getTypeData(edgeType).getName();
        Value v = new Value();
        FileWriter fw = new FileWriter(new File(this.path, nodeTypeName + "_" + edgeTypeName + (direction != 1 ? "_OUT.csv" : "_IN.csv")));
        CSVWriter csw = new CSVWriter(fw, ';');
        if (direction == 3) {
            HashMap<Long, Long> inDegrees = new HashMap<Long, Long>();
            FileWriter fwIn = new FileWriter(new File(this.path, nodeTypeName + "_" + edgeTypeName + "_IN.csv"));
            CSVWriter cswIn = new CSVWriter(fwIn, ';');
            Objects.Iterator it = nodes.iterator();
            while (it.hasNext()) {
                Long l;
                Long l2;
                long l3 = it.next();
                Long degValue = new Long(this.graph.degree(l3, edgeType, (short)2));
                Long freq = (Long)degrees.get(degValue);
                if (null == freq) {
                    freq = new Long(1L);
                    degrees.put(degValue, freq);
                } else {
                    l2 = freq;
                    l = freq = Long.valueOf(freq + 1L);
                    degrees.put(degValue, freq);
                }
                degValue = new Long(this.graph.degree(l3, edgeType, (short)1));
                freq = (Long)inDegrees.get(degValue);
                if (null == freq) {
                    freq = new Long(1L);
                    inDegrees.put(degValue, freq);
                    continue;
                }
                l2 = freq;
                l = freq = Long.valueOf(freq + 1L);
                inDegrees.put(degValue, freq);
            }
            this.ExportDegree(csw, degrees);
            csw.close();
            this.ExportDegree(cswIn, inDegrees);
            cswIn.close();
        } else {
            Objects.Iterator it = nodes.iterator();
            while (it.hasNext()) {
                long l = it.next();
                Long degValue = new Long(this.graph.degree(l, edgeType, direction));
                Long freq = (Long)degrees.get(degValue);
                if (null == freq) {
                    freq = new Long(1L);
                    degrees.put(degValue, freq);
                    continue;
                }
                Long l4 = freq;
                Long l5 = freq = Long.valueOf(freq + 1L);
                degrees.put(degValue, freq);
            }
            this.ExportDegree(csw, degrees);
            csw.close();
        }
    }

    private void ExportDegree(RowWriter csw, HashMap map) throws IOException {
        Set mapEntries = map.entrySet();
        Iterator it = mapEntries.iterator();
        String[] line = new String[2];
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            Long key = (Long)entry.getKey();
            Long value = (Long)entry.getValue();
            line[0] = key.toString();
            line[1] = value.toString();
            csw.writeNext(line);
        }
    }

    public static void main(String[] args) throws FileNotFoundException, IOException {
        CmdLineArgs opt = new CmdLineArgs();
        opt.registerOption(OPT_HELP, 'h', false, ": print usage and exit", false);
        opt.registerString(OPT_IMAGE, 'i', true, ": image name", null);
        opt.registerString(OPT_PATH, 'p', false, ": results path", ".");
        opt.registerFlags(OPT_STATS, 's', "D", true, ": statistics\n\t\t(D) Degree", "D");
        try {
            opt.parse(args);
        }
        catch (Exception e) {
            System.out.println("ERROR in arguments: " + e.getMessage());
            System.out.println("USAGE: " + opt.usage());
            return;
        }
        File image = new File(opt.getOptionString(OPT_IMAGE));
        File path = new File(opt.getOptionString(OPT_PATH));
        DEX dex = new DEX();
        GraphPool gpool = dex.open(image);
        Session sess = gpool.newSession();
        Statistics stats = new Statistics(sess.getDbGraph());
        System.out.println("DEX graph database image: " + image.getAbsolutePath());
        if (opt.getOptionFlag(OPT_STATS, 'D')) {
            File degreepath = new File(path, "degree");
            if (!degreepath.mkdirs()) {
                throw new IOException("Error creating directory " + degreepath.getAbsolutePath());
            }
            System.out.println("Dump degree statistics into " + degreepath.getAbsolutePath());
            stats.setPath(degreepath.getAbsolutePath());
            stats.getDegreeStatistics();
        }
        sess.close();
        gpool.close();
        dex.close();
    }
}

