/*
 * Decompiled with CFR 0.152.
 */
package edu.upc.dama.dex.utils;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class StringLib {
    public static String objectsToString(Object[] input, String separator) {
        if (input == null) {
            return null;
        }
        StringBuffer ret = new StringBuffer();
        int length = input.length;
        for (int i = 0; i < length; ++i) {
            ret.append(input[i].toString());
            if (i == length - 1) continue;
            ret.append(separator);
        }
        return ret.toString();
    }

    public static String toString(String[] input, String separator) {
        return StringLib.objectsToString(input, separator);
    }

    public static String capitalizeFirstOnly(String s) {
        return StringLib.capitalizeFirstOnly(s, true);
    }

    public static String capitalizeFirstOnly(String s, boolean all) {
        if (s == null) {
            return null;
        }
        if (s.length() == 0) {
            return s;
        }
        StringBuffer sbuf = new StringBuffer();
        char c = s.charAt(0);
        sbuf.append(Character.toUpperCase(c));
        boolean space = Character.isWhitespace(c);
        boolean firstFound = !space;
        for (int i = 1; i < s.length(); ++i) {
            c = s.charAt(i);
            if (Character.isWhitespace(c)) {
                space = true;
            } else if (space) {
                if (all || !firstFound) {
                    c = Character.toUpperCase(c);
                    firstFound = true;
                } else {
                    c = Character.toLowerCase(c);
                }
                space = false;
            } else {
                c = Character.toLowerCase(c);
            }
            sbuf.append(c);
        }
        return sbuf.toString();
    }

    public static String escape(String label) {
        label = label.replace("&", "&amp;");
        label = label.replace("<", "&lt;");
        label = label.replace(">", "&gt;");
        label = label.replace("\\n", "\n");
        return label;
    }

    public static String getTime(long tm) {
        tm = System.currentTimeMillis() - tm;
        long sec = tm / 1000L;
        long ms = tm / 1000L;
        String s = "";
        if (sec >= 3600L) {
            s = s + sec / 3600L + "h";
            sec %= 3600L;
        }
        if (sec >= 60L) {
            s = s + sec / 60L + "m";
            sec %= 60L;
        }
        s = s + sec + "." + (int)(ms / 100L) + "s";
        s = s + " (" + tm + " ms)";
        return s;
    }

    public static String quote(String s) {
        Pattern ps = Pattern.compile("[a-zA-Z]([a-zA-Z0-9])*");
        Matcher m = ps.matcher(s);
        if (m.matches()) {
            return s;
        }
        return "'" + s + "'";
    }
}

