/*
 * Decompiled with CFR 0.152.
 */
package edu.upc.dama.dex.algorithms;

import edu.upc.dama.dex.algorithms.Algorithm;
import edu.upc.dama.dex.algorithms.navigation.EdgeNavigation;
import edu.upc.dama.dex.algorithms.navigation.UnweightedEdgeNavigation;
import edu.upc.dama.dex.algorithms.navigation.WeightedEdgeNavigation;
import edu.upc.dama.dex.core.Graph;
import edu.upc.dama.dex.tasks.CompositeTask;
import java.util.HashSet;
import java.util.NoSuchElementException;
import java.util.Set;

public abstract class ShortestPath
extends CompositeTask
implements Algorithm {
    protected Graph gr;
    protected Set<EdgeNavigation> aEdges;
    protected int MAX_HOPS;
    protected long[] pathAsNodes;
    protected long[] pathAsEdges;
    protected boolean closed = false;
    protected boolean computed = false;
    protected static final int HOPS_NO_LIMIT = -1;

    public ShortestPath(Graph graph) {
        if (graph == null) {
            throw new NullPointerException("The graph can not be null.");
        }
        if (!graph.isOpen()) {
            throw new IllegalStateException("The graph has not been opened  yet.");
        }
        this.gr = graph;
        this.aEdges = new HashSet<EdgeNavigation>();
        this.MAX_HOPS = -1;
    }

    public abstract void run() throws Throwable;

    public abstract void close();

    public void setMaximumHops(int maxhops) {
        this.assertNotClosed();
        this.assertNotComputed();
        if (maxhops < 0) {
            this.close();
            throw new IllegalArgumentException("The limit of hops must be positive");
        }
        this.MAX_HOPS = maxhops;
    }

    protected void addEdge_(int edgetype, short navigation) {
        UnweightedEdgeNavigation edge;
        this.assertNotClosed();
        this.assertNotComputed();
        this.assertNotAddedEdgeType(edgetype);
        try {
            edge = new UnweightedEdgeNavigation(this.gr, edgetype, navigation);
        }
        catch (IllegalArgumentException ex) {
            this.close();
            throw ex;
        }
        this.aEdges.add(edge);
    }

    protected void addAllEdges_(short navigation) {
        this.assertNotClosed();
        this.assertNotComputed();
        Set<Integer> edgetypes = this.gr.edgeTypes();
        if (edgetypes.size() == 0) {
            this.close();
            throw new NoSuchElementException("There are no edges in the graph.");
        }
        for (int edgetype : edgetypes) {
            this.addEdge_(edgetype, navigation);
        }
    }

    protected void addWeightedEdge_(int edgetype, short navigation, long attributetype) {
        WeightedEdgeNavigation edge;
        this.assertNotClosed();
        this.assertNotComputed();
        this.assertNotAddedEdgeType(edgetype);
        try {
            edge = new WeightedEdgeNavigation(this.gr, edgetype, navigation, attributetype);
        }
        catch (IllegalArgumentException ex) {
            this.close();
            throw ex;
        }
        this.aEdges.add(edge);
    }

    protected void assertAddedEdges() {
        if (this.aEdges.isEmpty()) {
            this.close();
            throw new IllegalStateException("It is necessary to indicate which edges are allowed to navigate through while calculating the shortest path.");
        }
    }

    protected void assertComputed() {
        if (!this.computed) {
            this.close();
            throw new IllegalStateException("Shortest path not yet computed.");
        }
    }

    protected void assertNode(long node) {
        int type = this.gr.getObjectType(node);
        if (type == 0) {
            this.close();
            throw new IllegalArgumentException("The given node identifier " + node + " doesn't exist.");
        }
    }

    protected void assertNotComputed() {
        if (this.computed) {
            this.close();
            throw new IllegalStateException("The shortest path algorithm has already been computed.");
        }
    }

    protected void assertNotClosed() {
        if (this.closed) {
            throw new IllegalStateException("The shortest path algorithm has already been closed.");
        }
    }

    private void assertNotAddedEdgeType(int edgetype) {
        for (EdgeNavigation edge : this.aEdges) {
            int etype = edge.getType();
            if (etype != edgetype) continue;
            this.close();
            throw new IllegalArgumentException("The given edge type identifier " + edgetype + " has already been added.");
        }
    }
}

