/*
 * Decompiled with CFR 0.152.
 */
package edu.upc.dama.dex.algorithms;

import edu.upc.dama.dex.algorithms.Traversal;
import edu.upc.dama.dex.algorithms.navigation.EdgeNavigation;
import edu.upc.dama.dex.core.Graph;
import edu.upc.dama.dex.core.Objects;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Stack;

public class TraversalDFS
extends Traversal {
    private Stack<NeighborsIteratorStack> stack;
    private long idNodePeekStack;
    private Objects nodesVisited;
    private long idNodePrevious;

    public TraversalDFS(Graph graph, long source) {
        super(graph, source);
        this.nodesVisited = new Objects(graph.getSession());
        this.stack = new Stack();
    }

    public void close() {
        this.assertNotClosed();
        if (this.aEdges != null) {
            this.aEdges.clear();
        }
        if (this.aNodes != null) {
            this.aNodes.clear();
        }
        if (this.stack != null) {
            while (!this.stack.isEmpty()) {
                NeighborsIteratorStack peek = this.stack.pop();
                peek.close();
            }
            this.stack.clear();
        }
        if (this.nodesVisited != null && this.nodesVisited.isOpen()) {
            this.nodesVisited.close();
        }
        this.closed = true;
    }

    public boolean hasNext() {
        this.assertNotClosed();
        if (!this.parametersChecked) {
            this.assertInitialized();
            this.parametersChecked = true;
        }
        return this.idNodePrevious != 0L;
    }

    public Long next() {
        if (!this.hasNext()) {
            this.close();
            throw new NoSuchElementException("There are no more elements.");
        }
        long idNode = this.computeNext();
        return idNode;
    }

    public void remove() {
        this.close();
        throw new UnsupportedOperationException("Operation not supported.");
    }

    protected void addInfoToAuxiliarStructure(EdgeNavigation edge) {
        this.idNodePrevious = this.src;
        this.visitNeighborsOfAType(edge);
    }

    protected void setInfoToAuxiliarStructure() {
        this.idNodePrevious = this.src;
        this.visitNeighbors();
    }

    private long computeNext() {
        this.idNodePeekStack = this.idNodePrevious;
        this.nodesVisited.add(this.idNodePeekStack);
        this.visitNeighbors();
        this.prepareStack();
        return this.idNodePeekStack;
    }

    private void prepareStack() {
        if (this.stack.isEmpty()) {
            this.idNodePrevious = 0L;
            return;
        }
        NeighborsIteratorStack peek = this.stack.peek();
        boolean found = false;
        while (!found && !this.stack.isEmpty()) {
            long idNode = peek.next();
            int nodetype = this.gr.getType(idNode);
            while (this.nodesVisited.exists(idNode) && peek.hasNext() && !this.aNodes.contains(nodetype)) {
                idNode = peek.next();
                nodetype = this.gr.getType(idNode);
            }
            if (!peek.hasNext()) {
                peek.close();
                this.stack.pop();
                if (!this.stack.isEmpty() && !found) {
                    peek = this.stack.peek();
                }
            }
            if (this.nodesVisited.exists(idNode) || !this.aNodes.contains(nodetype)) continue;
            this.idNodePrevious = idNode;
            found = true;
        }
        if (this.stack.isEmpty()) {
            this.idNodePrevious = 0L;
        }
    }

    private void visitNeighbors() {
        Iterator aEdgesIt = this.aEdges.iterator();
        while (aEdgesIt.hasNext()) {
            this.visitNeighborsOfAType((EdgeNavigation)aEdgesIt.next());
        }
    }

    private void visitNeighborsOfAType(EdgeNavigation edgeinfo) {
        short direction;
        int type = edgeinfo.getType();
        Objects neighborsPeek = this.gr.neighbors(this.idNodePrevious, type, direction = edgeinfo.getDirection());
        if (neighborsPeek.size() != 0) {
            this.stack.push(new NeighborsIteratorStack(neighborsPeek));
        } else {
            neighborsPeek.close();
        }
    }

    private class NeighborsIteratorStack {
        private Objects neigh;
        private Objects.Iterator neighIt;

        public NeighborsIteratorStack(Objects neighbors) {
            this.neigh = neighbors;
            this.neighIt = neighbors.iterator();
        }

        public boolean hasNext() {
            return this.neighIt.hasNext();
        }

        public long next() {
            return this.neighIt.next();
        }

        public void close() {
            this.neighIt.close();
            this.neigh.close();
        }
    }
}

