/*
 * Decompiled with CFR 0.152.
 */
package edu.upc.dama.dex.io;

import edu.upc.dama.dex.io.RowWriter;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Writer;

public class CSVWriter
implements RowWriter {
    private BufferedWriter bw;
    private char separator;
    private char quotecharacter;
    private boolean autoquote;
    private boolean[] selectedquotes;
    public static final char DEFAULT_SEPARATOR = ',';
    public static final char DEFAULT_QUOTE_CHARACTER = '\"';
    public static final boolean DEFAULT_AUTO_QUOTE = true;

    public CSVWriter(Writer writer) {
        this(writer, ',', '\"');
    }

    public CSVWriter(Writer writer, char separator) {
        this(writer, separator, '\"');
    }

    public CSVWriter(Writer writer, char separator, char quotechar, boolean autoquote) {
        this(writer, separator, quotechar);
        this.autoquote = autoquote;
    }

    public CSVWriter(Writer writer, char separator, char quotechar, boolean[] selectedquotes) {
        this(writer, separator, quotechar);
        this.autoquote = false;
        this.selectedquotes = selectedquotes;
    }

    public CSVWriter(Writer writer, char separator, char quotechar) {
        this.bw = new BufferedWriter(writer);
        this.separator = separator;
        this.quotecharacter = quotechar;
        this.autoquote = true;
        this.selectedquotes = null;
    }

    public void writeNext(String[] row) throws IOException {
        for (int i = 0; i < row.length - 1; ++i) {
            if (row[i] != null && row[i].length() != 0) {
                this.writeCSVString(row[i], i);
            }
            this.bw.write(this.separator);
        }
        if (row.length != 0) {
            if (row[row.length - 1] != null && row[row.length - 1].length() != 0) {
                this.writeCSVString(row[row.length - 1], row.length - 1);
            }
            this.bw.write("\n");
        }
    }

    private void writeCSVString(String s, int pos) throws IOException {
        boolean quote = this.autoquote ? s.indexOf(this.separator) != -1 || s.indexOf(this.quotecharacter) != -1 : this.selectedquotes[pos];
        if (quote) {
            this.bw.write(this.quotecharacter);
        }
        for (int i = 0; i < s.length(); ++i) {
            if (s.charAt(i) == this.quotecharacter) {
                this.bw.write(this.quotecharacter);
                this.bw.write(this.quotecharacter);
                continue;
            }
            this.bw.write(s.charAt(i));
        }
        if (quote) {
            this.bw.write(this.quotecharacter);
        }
    }

    public void close() throws IOException {
        this.bw.flush();
        this.bw.close();
    }
}

