/*
 * Decompiled with CFR 0.152.
 */
package edu.upc.dama.dex.monitor;

import edu.upc.dama.dex.core.DEX;
import edu.upc.dama.dex.monitor.Administration;
import edu.upc.dama.dex.monitor.Query;
import edu.upc.dama.dex.monitor.Statistics;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import javax.management.JMException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.remote.JMXConnectorServer;
import javax.management.remote.JMXConnectorServerFactory;
import javax.management.remote.JMXServiceURL;

public class Monitor {
    private int port = 0;
    private JMXConnectorServer connector = null;
    private DEX dex;
    private boolean active = false;

    public Monitor(DEX dex, int port) {
        this.dex = dex;
        this.port = port;
    }

    public synchronized void start() throws JMException, IOException {
        MBeanServer mbserver = ManagementFactory.getPlatformMBeanServer();
        String name = "edu.upc.dama.dex.monitor:type=Statistics";
        Statistics edb = new Statistics(this.dex);
        this.registerMBean(mbserver, edb, name);
        name = "edu.upc.dama.dex.monitor:type=Query";
        Query shell = new Query(this.dex);
        this.registerMBean(mbserver, shell, name);
        name = "edu.upc.dama.dex.monitor:type=Administration";
        Administration admin = new Administration(this.dex);
        this.registerMBean(mbserver, admin, name);
        JMXServiceURL url = new JMXServiceURL("jmxmp", "localhost", this.port);
        this.connector = JMXConnectorServerFactory.newJMXConnectorServer(url, null, mbserver);
        this.connector.start();
        this.active = true;
        System.out.println("Remote DEX monitor successfully initialized.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void stop() {
        assert (this.connector != null);
        if (this.active) {
            try {
                this.connector.stop();
            }
            catch (IOException iOException) {
            }
            finally {
                this.active = false;
                System.out.println("Canceled remote DEX monitor.");
            }
        }
    }

    public synchronized boolean isActive() {
        assert (this.connector != null);
        return this.active;
    }

    private void registerMBean(MBeanServer mbserver, Object mbean, String name) throws JMException {
        ObjectName objName = new ObjectName(name);
        if (mbserver.isRegistered(objName)) {
            mbserver.unregisterMBean(objName);
        }
        mbserver.registerMBean(mbean, objName);
    }
}

