/*
 * Decompiled with CFR 0.152.
 */
package edu.upc.dama.dex.monitor;

import edu.upc.dama.dex.core.DEX;
import edu.upc.dama.dex.core.DbGraph;
import edu.upc.dama.dex.core.Objects;
import edu.upc.dama.dex.core.Session;
import edu.upc.dama.dex.monitor.MBeanUtils;
import edu.upc.dama.dex.monitor.QueryMBean;
import edu.upc.dama.dex.monitor.proxy.AttributeDataProxy;
import edu.upc.dama.dex.monitor.proxy.TypeDataProxy;
import edu.upc.dama.dex.monitor.proxy.ValueProxy;
import java.util.ArrayList;
import java.util.Set;
import javax.management.NotificationBroadcasterSupport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Query
extends NotificationBroadcasterSupport
implements QueryMBean {
    private DEX dex;
    private MBeanUtils utils;

    public Query(DEX dex) {
        this.dex = dex;
        this.utils = new MBeanUtils(dex);
    }

    @Override
    public ArrayList<TypeDataProxy> getNodeTypes(String graph) {
        Session sess = this.utils.getGraphPool(graph).newSession();
        DbGraph dbgraph = sess.getDbGraph();
        ArrayList<TypeDataProxy> types = new ArrayList<TypeDataProxy>();
        for (Integer type : dbgraph.nodeTypes()) {
            types.add(new TypeDataProxy(dbgraph, type));
        }
        sess.close();
        return types;
    }

    @Override
    public ArrayList<TypeDataProxy> getEdgeTypes(String graph) {
        Session sess = this.utils.getGraphPool(graph).newSession();
        DbGraph dbgraph = sess.getDbGraph();
        ArrayList<TypeDataProxy> types = new ArrayList<TypeDataProxy>();
        for (Integer type : dbgraph.edgeTypes()) {
            types.add(new TypeDataProxy(dbgraph, type));
        }
        sess.close();
        return types;
    }

    @Override
    public AttributeDataProxy getAttributeData(String graph, long attr) {
        Session sess = this.utils.getGraphPool(graph).newSession();
        DbGraph dbgraph = sess.getDbGraph();
        AttributeDataProxy adp = new AttributeDataProxy(dbgraph.getAttributeData(attr));
        sess.close();
        return adp;
    }

    @Override
    public ArrayList<ArrayList<Object>> getTypeInstanceData(String graph, int type, long min, long max) {
        ArrayList<ArrayList<Object>> data = new ArrayList<ArrayList<Object>>();
        Session sess = this.utils.getGraphPool(graph).newSession();
        DbGraph dbgraph = sess.getDbGraph();
        Objects objs = dbgraph.select(type);
        if ((long)objs.size() < max) {
            max = objs.size();
        }
        boolean isEdge = dbgraph.getTypeData(type).isEdgeType();
        Objects objects = dbgraph.select(type);
        if ((long)objects.size() < max) {
            max = objects.size();
        }
        Objects.Iterator it = objects.iterator();
        for (long iCount = 0L; it.hasNext() && iCount < max; ++iCount) {
            long obj = it.next();
            if (iCount <= min || iCount >= max) continue;
            ArrayList<Object> row = new ArrayList<Object>();
            row.add(obj);
            if (isEdge) {
                long[] st = dbgraph.getEdge(obj);
                row.add(st[0]);
                row.add(dbgraph.getTypeData(dbgraph.getType(st[0])).getName());
                row.add(st[1]);
                row.add(dbgraph.getTypeData(dbgraph.getType(st[1])).getName());
            }
            for (Long attr : dbgraph.getAttributesFromType(type)) {
                row.add(new ValueProxy(dbgraph.getAttribute(obj, attr)));
            }
            data.add(row);
        }
        it.close();
        objects.close();
        sess.close();
        return data;
    }

    @Override
    public ArrayList<Long> getAttributes(String graph, int type) {
        Session sess = this.utils.getGraphPool(graph).newSession();
        DbGraph dbgraph = sess.getDbGraph();
        ArrayList<Long> aa = new ArrayList<Long>(dbgraph.getAttributesFromType(type));
        sess.close();
        return aa;
    }

    @Override
    public Long getTypeCount(String graph, int type) {
        Long count = 0L;
        Session sess = this.utils.getGraphPool(graph).newSession();
        DbGraph dbgraph = sess.getDbGraph();
        Objects elems = dbgraph.select(type);
        try {
            count = elems.sizeLong();
        }
        catch (Exception ex) {
            count = 0L;
        }
        elems.close();
        sess.close();
        return count;
    }

    @Override
    public TypeDataProxy getTypeData(String graph, int type) {
        Session sess = this.utils.getGraphPool(graph).newSession();
        DbGraph dbgraph = sess.getDbGraph();
        TypeDataProxy tdp = new TypeDataProxy(dbgraph, type);
        sess.close();
        return tdp;
    }

    @Override
    public TypeDataProxy findType(String graph, String type) {
        Session sess = this.utils.getGraphPool(graph).newSession();
        DbGraph dbgraph = sess.getDbGraph();
        TypeDataProxy tdp = new TypeDataProxy(dbgraph, dbgraph.findType(type));
        sess.close();
        return tdp;
    }

    @Override
    public TypeDataProxy findType(String graph, long oid) {
        Session sess = this.utils.getGraphPool(graph).newSession();
        DbGraph dbgraph = sess.getDbGraph();
        TypeDataProxy tdp = new TypeDataProxy(dbgraph, dbgraph.getObjectType(oid));
        sess.close();
        return tdp;
    }

    @Override
    public ArrayList<Long> findNeighbours(String graph, long oid, int type, short direction, long low, long up) {
        Session sess = this.utils.getGraphPool(graph).newSession();
        DbGraph dbgraph = sess.getDbGraph();
        ArrayList<Long> data = new ArrayList<Long>();
        Objects objs = dbgraph.neighbors(oid, type, direction);
        Objects.Iterator it = objs.iterator();
        long i = 0L;
        while (it.hasNext()) {
            if (i < low || i > up) continue;
            data.add(it.next());
        }
        it.close();
        objs.close();
        sess.close();
        return data;
    }

    @Override
    public long neighboursSize(String graph, long oid, int type, short direction) {
        long size = 0L;
        Session sess = this.utils.getGraphPool(graph).newSession();
        DbGraph dbgraph = sess.getDbGraph();
        Objects objs = dbgraph.neighbors(oid, type, direction);
        size = objs.size();
        objs.close();
        sess.close();
        return size;
    }

    @Override
    public long findEdge(String graph, long tail, long head, int type) {
        Session sess = this.utils.getGraphPool(graph).newSession();
        DbGraph dbgraph = sess.getDbGraph();
        long e = dbgraph.findEdge(tail, head, type);
        sess.close();
        return e;
    }

    @Override
    public Object[] getAttributes(String graph, long oid) {
        Session sess = this.utils.getGraphPool(graph).newSession();
        DbGraph dbgraph = sess.getDbGraph();
        Set<Long> attrsIds = dbgraph.getAttributes(oid);
        ArrayList<Object> attrs = new ArrayList<Object>();
        for (Long attr : attrsIds) {
            attrs.add(dbgraph.getAttribute(oid, attr).get());
        }
        sess.close();
        return attrs.toArray(new Object[attrs.size()]);
    }
}

