/*
 * Decompiled with CFR 0.152.
 */
package edu.knowitall.collection.immutable;

import edu.knowitall.collection.immutable.Interval;
import edu.knowitall.collection.immutable.Interval$Empty$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.IterableLike;
import scala.collection.LinearSeqOptimized;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.SortedSet;
import scala.collection.immutable.SortedSet$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.math.Ordering;
import scala.math.Ordering$;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.util.matching.Regex;

public final class Interval$ {
    public static final Interval$ MODULE$;
    private final Interval$Empty$ empty;
    private final Regex emptyRegex;
    private final Regex singletonRegex;
    private final Regex openIntervalRegex;
    private final Regex closedIntervalRegex;

    static {
        new Interval$();
    }

    public Interval$Empty$ empty() {
        return this.empty;
    }

    public Interval.Singleton singleton(int x) {
        return new Interval.SingletonImpl(x);
    }

    public Interval open(int start, int end) {
        Predef$.MODULE$.require(end >= start, (Function0)new Serializable(start, end){
            public static final long serialVersionUID = 0L;
            private final int start$1;
            private final int end$1;

            public final String apply() {
                return new StringBuilder().append((Object)"end < start: ").append((Object)BoxesRunTime.boxToInteger((int)this.end$1)).append((Object)" < ").append((Object)BoxesRunTime.boxToInteger((int)this.start$1)).toString();
            }
            {
                this.start$1 = start$1;
                this.end$1 = end$1;
            }
        });
        return start == end ? this.empty() : (end - start == 1 ? this.singleton(start) : new Interval(start, end));
    }

    public Interval closed(int start, int end) {
        Predef$.MODULE$.require(end < Integer.MAX_VALUE, (Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "end must be < Int.MaxValue";
            }
        });
        Predef$.MODULE$.require(end >= start, (Function0)new Serializable(start, end){
            public static final long serialVersionUID = 0L;
            private final int start$2;
            private final int end$2;

            public final String apply() {
                return new StringBuilder().append((Object)"end < start: ").append((Object)BoxesRunTime.boxToInteger((int)this.end$2)).append((Object)" < ").append((Object)BoxesRunTime.boxToInteger((int)this.start$2)).toString();
            }
            {
                this.start$2 = start$2;
                this.end$2 = end$2;
            }
        });
        return end == start ? this.singleton(start) : new Interval.Closed(start, end);
    }

    public Interval ofLength(int start, int length) {
        return this.open(start, start + length);
    }

    public Regex emptyRegex() {
        return this.emptyRegex;
    }

    public Regex singletonRegex() {
        return this.singletonRegex;
    }

    public Regex openIntervalRegex() {
        return this.openIntervalRegex;
    }

    public Regex closedIntervalRegex() {
        return this.closedIntervalRegex;
    }

    public Interval deserialize(String pickled) {
        String string;
        block6: {
            Interval interval;
            block3: {
                block5: {
                    block4: {
                        block2: {
                            string = pickled;
                            Option option = this.emptyRegex().unapplySeq((Object)string);
                            if (option.isEmpty() || option.get() == null || ((LinearSeqOptimized)option.get()).lengthCompare(0) != 0) break block2;
                            interval = this.empty();
                            break block3;
                        }
                        Option option = this.singletonRegex().unapplySeq((Object)string);
                        if (option.isEmpty() || option.get() == null || ((LinearSeqOptimized)option.get()).lengthCompare(1) != 0) break block4;
                        String value = (String)((LinearSeqOptimized)option.get()).apply(0);
                        interval = this.singleton(new StringOps(Predef$.MODULE$.augmentString(value)).toInt());
                        break block3;
                    }
                    Option option = this.openIntervalRegex().unapplySeq((Object)string);
                    if (option.isEmpty() || option.get() == null || ((LinearSeqOptimized)option.get()).lengthCompare(2) != 0) break block5;
                    String a = (String)((LinearSeqOptimized)option.get()).apply(0);
                    String b = (String)((LinearSeqOptimized)option.get()).apply(1);
                    interval = this.open(new StringOps(Predef$.MODULE$.augmentString(a)).toInt(), new StringOps(Predef$.MODULE$.augmentString(b)).toInt());
                    break block3;
                }
                Option option = this.closedIntervalRegex().unapplySeq((Object)string);
                if (option.isEmpty() || option.get() == null || ((LinearSeqOptimized)option.get()).lengthCompare(2) != 0) break block6;
                String a = (String)((LinearSeqOptimized)option.get()).apply(0);
                String b = (String)((LinearSeqOptimized)option.get()).apply(1);
                interval = this.closed(new StringOps(Predef$.MODULE$.augmentString(a)).toInt(), new StringOps(Predef$.MODULE$.augmentString(b)).toInt());
            }
            return interval;
        }
        throw new MatchError((Object)string);
    }

    public Interval between(Interval x, Interval y) {
        Predef$.MODULE$.require(!x.intersects(y), (Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "intervals may not intersect";
            }
        });
        return this.open(RichInt$.MODULE$.min$extension(Predef$.MODULE$.intWrapper(x.end()), y.end()), RichInt$.MODULE$.max$extension(Predef$.MODULE$.intWrapper(x.start()), y.start()));
    }

    public Interval from(Seq<Object> col) {
        Interval interval;
        if (col.isEmpty()) {
            interval = this.empty();
        } else {
            Seq sorted = (Seq)col.sorted((Ordering)Ordering.Int$.MODULE$);
            int min = BoxesRunTime.unboxToInt((Object)sorted.head());
            Predef$.MODULE$.require(((IterableLike)sorted.zipWithIndex(Seq$.MODULE$.canBuildFrom())).forall((Function1)new Serializable(min){
                public static final long serialVersionUID = 0L;
                private final int min$1;

                public final boolean apply(Tuple2<Object, Object> x0$1) {
                    Tuple2<Object, Object> tuple2 = x0$1;
                    if (tuple2 != null) {
                        int i;
                        int x = tuple2._1$mcI$sp();
                        boolean bl = x == this.min$1 + (i = tuple2._2$mcI$sp());
                        return bl;
                    }
                    throw new MatchError(tuple2);
                }
                {
                    this.min$1 = min$1;
                }
            }), (Function0)new Serializable(col){
                public static final long serialVersionUID = 0L;
                private final Seq col$1;

                public final String apply() {
                    return new StringBuilder().append((Object)"missing elements in collection: ").append((Object)this.col$1).toString();
                }
                {
                    this.col$1 = col$1;
                }
            });
            interval = this.closed(min, BoxesRunTime.unboxToInt((Object)sorted.last()));
        }
        return interval;
    }

    public Interval union(Seq<Interval> col) {
        Seq sorted = (Seq)col.sorted(Ordering$.MODULE$.ordered((Function1)Predef$.MODULE$.conforms()));
        try {
            return (Interval)sorted.reduceRight((Function2)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final Interval apply(Interval x$1, Interval x$2) {
                    return x$1.union(x$2);
                }
            });
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new IllegalArgumentException(new StringBuilder().append((Object)"gap in intervals: ").append((Object)sorted).toString());
        }
    }

    public Interval span(Iterable<Interval> col) {
        return col.isEmpty() ? this.empty() : this.open(BoxesRunTime.unboxToInt((Object)((TraversableOnce)col.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final int apply(Interval x$3) {
                return x$3.min();
            }
        }, Iterable$.MODULE$.canBuildFrom())).min((Ordering)Ordering.Int$.MODULE$)), BoxesRunTime.unboxToInt((Object)((TraversableOnce)col.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final int apply(Interval x$4) {
                return x$4.max();
            }
        }, Iterable$.MODULE$.canBuildFrom())).max((Ordering)Ordering.Int$.MODULE$)) + 1);
    }

    public List<Interval> minimal(Iterable<Interval> intervals) {
        SortedSet set = (SortedSet)SortedSet$.MODULE$.empty((Ordering)Ordering.Int$.MODULE$).$plus$plus((GenTraversableOnce)intervals.flatten((Function1)Predef$.MODULE$.conforms()));
        return ((List)set.foldLeft((Object)List$.MODULE$.empty(), (Function2)new Serializable(){
            public static final long serialVersionUID = 0L;

            /*
             * Unable to fully structure code
             */
            public final List<Interval> apply(List<Interval> x0$2, int x1$1) {
                block2: {
                    block4: {
                        block3: {
                            var3_3 = new Tuple2(x0$2, (Object)BoxesRunTime.boxToInteger((int)x1$1));
                            if (var3_3 == null) break block2;
                            list = (List)var3_3._1();
                            i = var3_3._2$mcI$sp();
                            singleton = Interval$.MODULE$.singleton(i);
                            var8_7 = list;
                            v0 = Nil$.MODULE$;
                            var9_8 = var8_7;
                            if (v0 != null ? v0.equals(var9_8) == false : var9_8 != null) break block3;
                            var10_9 = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Interval.Singleton[]{singleton}));
                            break block4;
                        }
                        if (!(var8_7 instanceof .colon.colon)) ** GOTO lbl-1000
                        var11_10 = (.colon.colon)var8_7;
                        x = (Interval)var11_10.hd$1();
                        xs = var11_10.tl$1();
                        if (x.borders(i)) {
                            var14_13 = x.union(singleton);
                            var10_9 = xs.$colon$colon((Object)var14_13);
                        } else lbl-1000:
                        // 2 sources

                        {
                            var15_14 = singleton;
                            var10_9 = var8_7.$colon$colon((Object)var15_14);
                        }
                    }
                    var6_15 = var10_9;
                    return var6_15;
                }
                throw new MatchError((Object)var3_3);
            }
        })).reverse();
    }

    private Interval$() {
        MODULE$ = this;
        this.empty = Interval$Empty$.MODULE$;
        this.emptyRegex = new Regex("\\{\\}", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0]));
        this.singletonRegex = new Regex("\\{([+-]?\\d+)\\}", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0]));
        this.openIntervalRegex = new Regex("\\[([+-]?\\d+), ([+-]?\\d+)\\)", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0]));
        this.closedIntervalRegex = new Regex("\\[([+-]?\\d+), ([+-]?\\d+)\\]", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0]));
    }
}

