/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.parser.maltparser;

import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.parser.maltparser.MaltDependency;
import edu.stanford.nlp.trees.EnglishGrammaticalStructure;
import java.util.ArrayList;
import java.util.List;
import org.maltparser.MaltParserService;
import org.maltparser.core.exception.MaltChainedException;
import org.maltparser.core.symbol.SymbolTable;
import org.maltparser.core.syntaxgraph.DependencyStructure;
import org.maltparser.core.syntaxgraph.edge.Edge;
import org.maltparser.core.syntaxgraph.edge.GraphEdge;

public class MaltParserInterface {
    MaltParserService service = new MaltParserService();
    final String modelDirectory;
    final String modelFile;

    public MaltParserInterface(String model, String logFile) throws MaltChainedException {
        int forwardSlashIndex = model.lastIndexOf("/");
        int backwardSlashIndex = model.lastIndexOf("\\");
        int index = Math.max(backwardSlashIndex, forwardSlashIndex);
        if (index < 0) {
            this.modelDirectory = null;
            this.modelFile = model;
        } else {
            if (index == model.length()) {
                throw new IllegalArgumentException("Parser path must be a file, not a directory");
            }
            this.modelDirectory = model.substring(0, index + 1);
            this.modelFile = model.substring(index + 1);
        }
        String command = "-c " + this.modelFile + (this.modelDirectory != null ? " -w " + this.modelDirectory : "") + " -m parse" + (logFile != null ? " -lfi parser.log" : " -cl off");
        System.err.println("Initializing malt: " + command);
        this.service.initializeParserModel(command);
    }

    public DependencyStructure parse(String[] tokens) throws MaltChainedException {
        return this.service.parse(tokens);
    }

    public DependencyStructure parse(List<? extends CoreLabel> sentence) throws MaltChainedException {
        String[] tokens = new String[sentence.size()];
        int index = 0;
        for (CoreLabel coreLabel : sentence) {
            StringBuilder token = new StringBuilder();
            token.append(index + 1 + "\t");
            token.append(coreLabel.word() + "\t");
            if (!coreLabel.has(CoreAnnotations.LemmaAnnotation.class)) {
                throw new IllegalArgumentException("Words must be morphaed first");
            }
            token.append((String)coreLabel.get(CoreAnnotations.LemmaAnnotation.class) + "\t");
            if (coreLabel.tag() == null) {
                throw new IllegalArgumentException("Words must be tagged first");
            }
            token.append(coreLabel.tag() + "\t");
            token.append(coreLabel.tag() + "\t-");
            tokens[index] = token.toString();
            ++index;
        }
        return this.parse(tokens);
    }

    public static List<List<String>> buildConnlStructure(List<? extends CoreLabel> sentence) {
        ArrayList<List<String>> tokens = new ArrayList<List<String>>();
        int index = 0;
        for (CoreLabel coreLabel : sentence) {
            ArrayList<Object> token = new ArrayList<Object>();
            token.add(Integer.toString(++index));
            token.add(coreLabel.word());
            if (!coreLabel.has(CoreAnnotations.LemmaAnnotation.class)) {
                throw new IllegalArgumentException("Words must be morphaed first");
            }
            token.add(coreLabel.get(CoreAnnotations.LemmaAnnotation.class));
            if (coreLabel.tag() == null) {
                throw new IllegalArgumentException("Words must be tagged first");
            }
            token.add(coreLabel.tag());
            token.add(coreLabel.tag());
            token.add("_");
            token.add("_");
            token.add("_");
            token.add("_");
            token.add("_");
            tokens.add(token);
        }
        return tokens;
    }

    public static List<MaltDependency> extractDependencies(DependencyStructure structure) throws MaltChainedException {
        ArrayList<MaltDependency> dependencies = new ArrayList<MaltDependency>();
        for (Edge e : structure.getEdges()) {
            if (!(e instanceof GraphEdge)) {
                throw new RuntimeException("Expected all the dependency edges to be of type GraphEdge");
            }
            GraphEdge ge = (GraphEdge)e;
            int governor = ge.getSource().getIndex();
            int dependent = ge.getTarget().getIndex();
            String label = null;
            if (ge.getLabelSet() == null && governor == 0) {
                label = "root";
                System.err.println(" --- Warning: Unlabeled root from " + governor + " to " + dependent);
            } else {
                if (ge.getLabelSet() == null) {
                    throw new RuntimeException("No label set at all with a non-root governor; don't know what label to use");
                }
                if (ge.getLabelSet().size() != 1) {
                    throw new RuntimeException("Expected the dependency edges to have exactly one label");
                }
                for (SymbolTable table : ge.getLabelSet().keySet()) {
                    label = ge.getLabelSymbol(table);
                }
            }
            if (governor != 0 && label.equals("root")) {
                label = "dep";
                System.err.println(" --- Warning: Unexpected root label changed to 'dep' for an edge " + governor + "->" + dependent);
            }
            dependencies.add(new MaltDependency(governor, dependent, label));
        }
        return dependencies;
    }

    public EnglishGrammaticalStructure parseToGrammaticalStructure(List<? extends CoreLabel> sentence) throws MaltChainedException {
        DependencyStructure structure = this.parse(sentence);
        List<List<String>> tokens = MaltParserInterface.buildConnlStructure(sentence);
        List<MaltDependency> dependencies = MaltParserInterface.extractDependencies(structure);
        for (MaltDependency dependency : dependencies) {
            List<String> token = tokens.get(dependency.dependent - 1);
            token.set(6, Integer.toString(dependency.governor));
            token.set(7, dependency.label);
        }
        return EnglishGrammaticalStructure.buildCoNNLXGrammaticStructure(tokens);
    }

    public EnglishGrammaticalStructure parseToGrammaticalStructure(List<? extends CoreLabel> sentence, boolean splitUnderscores) throws MaltChainedException {
        if (!splitUnderscores) {
            return this.parseToGrammaticalStructure(sentence);
        }
        ArrayList<Boolean> wasSplitWord = new ArrayList<Boolean>();
        ArrayList<Integer> splitIndex = new ArrayList<Integer>();
        ArrayList<CoreLabel> splitSentence = new ArrayList<CoreLabel>();
        for (CoreLabel coreLabel : sentence) {
            String label = coreLabel.word();
            String[] pieces = label.split("_");
            if (pieces.length <= 1) {
                splitSentence.add(coreLabel);
                wasSplitWord.add(false);
                splitIndex.add(wasSplitWord.size());
                continue;
            }
            wasSplitWord.add(true);
            for (String piece : pieces) {
                CoreLabel fakeWord = new CoreLabel(coreLabel);
                fakeWord.setWord(piece);
                fakeWord.set(CoreAnnotations.LemmaAnnotation.class, (Object)piece);
                fakeWord.set(CoreAnnotations.StemAnnotation.class, (Object)piece);
                fakeWord.setTag(coreLabel.tag());
                splitSentence.add(fakeWord);
                splitIndex.add(wasSplitWord.size());
            }
        }
        DependencyStructure structure = this.parse(splitSentence);
        List<MaltDependency> list = MaltParserInterface.extractDependencies(structure);
        List<List<String>> tokens = MaltParserInterface.buildConnlStructure(sentence);
        boolean[] dependencySet = new boolean[sentence.size()];
        for (MaltDependency dependency : list) {
            int governor;
            int dependent = (Integer)splitIndex.get(dependency.dependent - 1);
            if (dependent == (governor = dependency.governor == 0 ? 0 : (Integer)splitIndex.get(dependency.governor - 1)) || dependencySet[dependent - 1]) continue;
            List<String> token = tokens.get(dependent - 1);
            token.set(6, Integer.toString(governor));
            token.set(7, dependency.label);
            dependencySet[dependent - 1] = true;
        }
        return EnglishGrammaticalStructure.buildCoNNLXGrammaticStructure(tokens);
    }

    public void output(List<CoreLabel> words) throws MaltChainedException {
        System.out.println("===============================");
        System.out.println("===============================");
        DependencyStructure dependencies = this.parse(words);
        List<MaltDependency> md = MaltParserInterface.extractDependencies(dependencies);
        System.out.println("-------------------------------");
        System.out.println(words);
        System.out.println("-------------------------------");
        System.out.println(dependencies);
        System.out.println("-------------------------------");
        System.out.println(dependencies.getEdges());
        System.out.println("-------------------------------");
        System.out.println(md);
        System.out.println("-------------------------------");
        System.out.println(this.parseToGrammaticalStructure(words, false));
        System.out.println("-------------------------------");
        System.out.println(this.parseToGrammaticalStructure(words, true));
        System.out.println("-------------------------------");
    }

    public static CoreLabel fakeWord(String word, String tag, String lemma) {
        CoreLabel coreLabel = new CoreLabel();
        coreLabel.setWord(word);
        coreLabel.setTag(tag);
        coreLabel.set(CoreAnnotations.LemmaAnnotation.class, (Object)lemma);
        return coreLabel;
    }

    public static void main(String[] args) throws MaltChainedException {
        ArrayList<CoreLabel> words = new ArrayList<CoreLabel>();
        words.add(MaltParserInterface.fakeWord("Ms.", "NNP", "ms."));
        words.add(MaltParserInterface.fakeWord("Haag", "NNP", "haag"));
        words.add(MaltParserInterface.fakeWord("plays", "VBZ", "play"));
        words.add(MaltParserInterface.fakeWord("Elianti", "NNP", "ms."));
        words.add(MaltParserInterface.fakeWord(".", ".", "elianti"));
        ArrayList<CoreLabel> words2 = new ArrayList<CoreLabel>();
        words2.add(MaltParserInterface.fakeWord("Ms._Haag", "NNP", "Ms._Haag"));
        words2.add(MaltParserInterface.fakeWord("plays", "VBZ", "play"));
        words2.add(MaltParserInterface.fakeWord("Elianti", "NNP", "ms."));
        words2.add(MaltParserInterface.fakeWord(".", ".", "elianti"));
        ArrayList<CoreLabel> words3 = new ArrayList<CoreLabel>();
        words3.add(MaltParserInterface.fakeWord("Some", "DT", "some"));
        words3.add(MaltParserInterface.fakeWord("reptiles", "NNS", "reptile"));
        words3.add(MaltParserInterface.fakeWord("do", "VBP", "do"));
        words3.add(MaltParserInterface.fakeWord("n't", "RB", "n't"));
        words3.add(MaltParserInterface.fakeWord("like", "IN", "like"));
        words3.add(MaltParserInterface.fakeWord("people", "NNS", "people"));
        words3.add(MaltParserInterface.fakeWord(".", ".", "."));
        ArrayList<CoreLabel> words4 = new ArrayList<CoreLabel>();
        words4.add(MaltParserInterface.fakeWord("David_Tennant", "NNP", "David_Tennant"));
        words4.add(MaltParserInterface.fakeWord("plays", "VBZ", "play"));
        words4.add(MaltParserInterface.fakeWord("Doctor_Who", "NNP", "Doctor_Who"));
        words4.add(MaltParserInterface.fakeWord(".", ".", "."));
        MaltParserInterface mpi = new MaltParserInterface(args[0], "log.txt");
        mpi.output(words);
        mpi.output(words2);
        mpi.output(words3);
        mpi.output(words4);
    }
}

