/*
 * Decompiled with CFR 0.152.
 */
package edu.washington.cs.knowitall.logic;

import com.google.common.base.Predicate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Expression<E> {

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Paren<E>
    extends Expression<E> {

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static class R<E>
        extends Paren<E> {
            public String toString() {
                return ")";
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static class L<E>
        extends Paren<E> {
            public String toString() {
                return "(";
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class Arg<E>
    extends Apply<E>
    implements Predicate<E> {

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static class Value<E>
        extends Arg<E> {
            private boolean value;

            public Value(boolean value) {
                this.value = value;
            }

            @Override
            public boolean apply(E entity) {
                return this.apply();
            }

            public boolean apply() {
                return this.value;
            }

            public String toString() {
                return Boolean.toString(this.value);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static abstract class Pred<E>
        extends Arg<E> {
            private String description;

            public Pred(String description) {
                this.description = description;
            }

            @Override
            public abstract boolean apply(E var1);

            public String getDescription() {
                return this.description;
            }

            public String toString() {
                return this.getDescription();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class Op<E>
    extends Apply<E> {
        public boolean preceeds(Op<?> that) {
            return this.precedence() < that.precedence();
        }

        public abstract int precedence();

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static abstract class Bin<E>
        extends Op<E> {
            public Apply<E> left;
            public Apply<E> right;

            public String toString(String symbol) {
                if (this.left == null || this.right == null) {
                    return symbol;
                }
                return "(" + this.left.toString() + " " + symbol + " " + this.right.toString() + ")";
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public static class Or<E>
            extends Bin<E> {
                public String toString() {
                    return super.toString("|");
                }

                @Override
                public boolean apply(E entity) {
                    return this.left.apply(entity) || this.right.apply(entity);
                }

                @Override
                public int precedence() {
                    return 2;
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public static class And<E>
            extends Bin<E> {
                public String toString() {
                    return super.toString("&");
                }

                @Override
                public boolean apply(E entity) {
                    return this.left.apply(entity) && this.right.apply(entity);
                }

                @Override
                public int precedence() {
                    return 1;
                }
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static abstract class Mon<E>
        extends Op<E> {
            public Apply<E> sub;

            public String toString(String symbol) {
                if (this.sub == null) {
                    return symbol;
                }
                return symbol + "(" + this.sub.toString() + ")";
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public static class Not<E>
            extends Mon<E> {
                public String toString() {
                    return super.toString("!");
                }

                @Override
                public boolean apply(E entity) {
                    return !this.sub.apply(entity);
                }

                @Override
                public int precedence() {
                    return 0;
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class Apply<E>
    extends Expression<E> {
        public abstract boolean apply(E var1);
    }
}

