/*
 * Decompiled with CFR 0.152.
 */
package edu.washington.cs.knowitall.logic;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import edu.washington.cs.knowitall.logic.Expression;
import edu.washington.cs.knowitall.logic.LogicException;
import edu.washington.cs.knowitall.logic.LogicExpressions;
import java.util.ArrayList;
import java.util.EmptyStackException;
import java.util.LinkedList;
import java.util.List;
import java.util.Scanner;
import java.util.Stack;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LogicExpression<E>
implements Predicate<E> {
    private final Expression.Apply<E> expression;

    protected LogicExpression(String input, Function<String, Expression.Arg<E>> factory) throws LogicException.TokenizeLogicException, LogicException.CompileLogicException {
        List<Expression<E>> tokens = this.tokenize(input, factory);
        List<Expression<E>> rpn = this.rpn(tokens);
        this.expression = this.compile(rpn);
    }

    public static <E> LogicExpression<E> compile(String input, Function<String, Expression.Arg<E>> factory) {
        return new LogicExpression<E>(input, factory);
    }

    public String toString() {
        if (this.isEmpty()) {
            return "(empty)";
        }
        return this.expression.toString();
    }

    public boolean isEmpty() {
        return this.expression == null;
    }

    public boolean apply(E entity) {
        if (this.isEmpty()) {
            return true;
        }
        return this.expression.apply(entity);
    }

    public Expression.Apply<E> compile(List<Expression<E>> rpn) {
        if (rpn.isEmpty()) {
            return null;
        }
        Stack<Expression.Apply> stack = new Stack<Expression.Apply>();
        for (Expression<E> tok : rpn) {
            if (tok instanceof Expression.Arg) {
                stack.push((Expression.Arg)tok);
                continue;
            }
            if (!(tok instanceof Expression.Op)) continue;
            try {
                if (tok instanceof Expression.Op.Mon) {
                    Expression.Apply sub = (Expression.Apply)stack.pop();
                    Expression.Op.Mon mon = (Expression.Op.Mon)tok;
                    mon.sub = sub;
                    stack.push(mon);
                }
                if (!(tok instanceof Expression.Op.Bin)) continue;
                Expression.Apply arg2 = (Expression.Apply)stack.pop();
                Expression.Apply arg1 = (Expression.Apply)stack.pop();
                Expression.Op.Bin bin = (Expression.Op.Bin)tok;
                bin.left = arg1;
                bin.right = arg2;
                stack.push(bin);
            }
            catch (EmptyStackException e) {
                throw new LogicException.CompileLogicException("No argument for operator (stack empty): " + tok.toString());
            }
        }
        if (stack.size() > 1) {
            throw new LogicException.ApplyLogicException("Stack has multiple elements after apply: " + stack.toString());
        }
        if (stack.size() == 0) {
            throw new LogicException.ApplyLogicException("Stack has zero elements after apply.");
        }
        if (!(stack.peek() instanceof Expression.Apply)) {
            throw new LogicException.ApplyLogicException("Stack contains non-appliable tokens after apply: " + stack.toString());
        }
        return (Expression.Apply)stack.pop();
    }

    public List<String> getArgs() {
        ArrayList<String> args = new ArrayList<String>();
        this.getArgs(this.expression, args);
        return args;
    }

    private void getArgs(Expression.Apply<?> apply, List<String> args) {
        if (apply instanceof Expression.Op.Bin) {
            Expression.Op.Bin bin = (Expression.Op.Bin)apply;
            this.getArgs(bin.left, args);
            this.getArgs(bin.right, args);
        } else if (apply instanceof Expression.Arg.Pred) {
            args.add(((Expression.Arg.Pred)apply).getDescription());
        }
    }

    public List<Expression<E>> tokenize(String input, Function<String, Expression.Arg<E>> factory) throws LogicException.TokenizeLogicException {
        ArrayList<Expression<Object>> tokens = new ArrayList<Expression<Object>>();
        int i = 0;
        while (i < input.length()) {
            String token;
            int nextExpressionen;
            String substring = input.substring(i);
            char firstChar = substring.charAt(0);
            if (firstChar == ' ') {
                ++i;
                continue;
            }
            if (firstChar == '(') {
                tokens.add(new Expression.Paren.L());
                ++i;
                continue;
            }
            if (firstChar == ')') {
                tokens.add(new Expression.Paren.R());
                ++i;
                continue;
            }
            if (firstChar == '!') {
                tokens.add(new Expression.Op.Mon.Not());
                ++i;
                continue;
            }
            if (firstChar == '&') {
                tokens.add(new Expression.Op.Bin.And());
                ++i;
                continue;
            }
            if (firstChar == '|') {
                tokens.add(new Expression.Op.Bin.Or());
                ++i;
                continue;
            }
            Stack<Character> parens = new Stack<Character>();
            boolean quoted = false;
            int quote = 32;
            for (nextExpressionen = 1; nextExpressionen < substring.length(); ++nextExpressionen) {
                char c = substring.charAt(nextExpressionen);
                if (!(c != '\"' || quoted && quote != 34)) {
                    quoted = !quoted;
                    quote = 34;
                }
                if (c == '\'' & (!quoted || quote == 39)) {
                    quoted = !quoted;
                    quote = 39;
                    continue;
                }
                if (quoted) continue;
                if (c == '(') {
                    parens.push(Character.valueOf(c));
                    continue;
                }
                if (c == ')') {
                    if (parens.isEmpty()) break;
                    parens.pop();
                    continue;
                }
                if (c == '&' || c == '|') break;
            }
            if ((token = substring.substring(0, nextExpressionen).trim()).isEmpty()) {
                throw new LogicException.TokenizeLogicException("zero-length token found.");
            }
            tokens.add((Expression<Object>)factory.apply((Object)token));
            i += token.length();
        }
        return tokens;
    }

    public List<Expression<E>> rpn(List<Expression<E>> tokens) throws LogicException.CompileLogicException {
        Stack<Expression<E>> stack = new Stack<Expression<E>>();
        LinkedList<Expression<Expression>> output = new LinkedList<Expression<Expression>>();
        for (Expression<E> tok : tokens) {
            if (tok instanceof Expression.Paren.L) {
                stack.push(tok);
                continue;
            }
            if (tok instanceof Expression.Paren.R) {
                Expression top;
                do {
                    if ((top = (Expression)stack.pop()) instanceof Expression.Paren.L) continue;
                    output.offer(top);
                } while (!(top instanceof Expression.Paren.L));
                continue;
            }
            if (tok instanceof Expression.Op.Mon) {
                stack.push(tok);
                continue;
            }
            if (tok instanceof Expression.Op.Bin) {
                while (!stack.isEmpty() && stack.peek() instanceof Expression.Op && ((Expression.Op)stack.peek()).preceeds((Expression.Op)tok)) {
                    output.offer((Expression<Expression>)stack.pop());
                }
                stack.push(tok);
                continue;
            }
            if (!(tok instanceof Expression.Arg)) continue;
            output.offer(tok);
        }
        while (!stack.isEmpty()) {
            Expression top = (Expression)stack.pop();
            if (top instanceof Expression.Paren.L || top instanceof Expression.Paren.R) {
                throw new LogicException.CompileLogicException("Unbalanced parentheses.");
            }
            output.offer(top);
        }
        return output;
    }

    public static void main(String[] args) {
        Scanner scan = new Scanner(System.in);
        while (scan.hasNextLine()) {
            String line = scan.nextLine();
            LogicExpression<String> expr = LogicExpressions.trivial(line);
            System.out.println("string: " + expr.toString());
            System.out.println("value:  " + expr.apply(null));
            System.out.println();
        }
    }
}

