/*
 * Decompiled with CFR 0.152.
 */
package edu.washington.cs.knowitall.regex;

import com.google.common.base.Joiner;
import com.google.common.base.Predicate;
import edu.washington.cs.knowitall.regex.FiniteAutomaton;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface Expression<E>
extends Predicate<E> {
    public FiniteAutomaton.Automaton<E> build();

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class EndAssertion<E>
    extends AssertionExpression<E> {
        @Override
        public boolean apply(boolean hasStart, List<E> tokens, int count) {
            return tokens.isEmpty();
        }

        public String toString() {
            return "$";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class StartAssertion<E>
    extends AssertionExpression<E> {
        @Override
        public boolean apply(boolean hasStart, List<E> tokens, int count) {
            return hasStart && tokens.size() == count;
        }

        public String toString() {
            return "^";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class AssertionExpression<E>
    implements Expression<E> {
        public boolean apply(E entity) {
            return false;
        }

        public abstract boolean apply(boolean var1, List<E> var2, int var3);

        @Override
        public FiniteAutomaton.Automaton<E> build() {
            FiniteAutomaton.Automaton auto = new FiniteAutomaton.Automaton(this);
            auto.start.connect(auto.end, this);
            return auto;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class BaseExpression<E>
    implements Expression<E> {
        public final String source;

        public BaseExpression(String source) {
            this.source = source;
        }

        public abstract boolean apply(E var1);

        public String toString() {
            return "<" + this.source + ">";
        }

        @Override
        public FiniteAutomaton.Automaton<E> build() {
            FiniteAutomaton.Automaton auto = new FiniteAutomaton.Automaton(this);
            auto.start.connect(auto.end, this);
            return auto;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Option<E>
    implements Expression<E> {
        Expression<E> expr;

        public Option(Expression<E> expr) {
            this.expr = expr;
        }

        public boolean apply(E entity) {
            return this.expr.apply(entity);
        }

        public String toString() {
            return this.expr.toString() + "?";
        }

        @Override
        public FiniteAutomaton.Automaton<E> build() {
            FiniteAutomaton.Automaton auto = new FiniteAutomaton.Automaton(this);
            FiniteAutomaton.Automaton<E> sub = this.expr.build();
            auto.start.connect(sub.start);
            sub.end.connect(auto.end);
            auto.start.connect(auto.end);
            return auto;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Plus<E>
    implements Expression<E> {
        public final Expression<E> expr;

        public Plus(Expression<E> expr) {
            this.expr = expr;
        }

        public boolean apply(E entity) {
            return this.expr.apply(entity);
        }

        public String toString() {
            return this.expr.toString() + "+";
        }

        @Override
        public FiniteAutomaton.Automaton<E> build() {
            FiniteAutomaton.Automaton auto = new FiniteAutomaton.Automaton(this);
            FiniteAutomaton.Automaton<E> sub = this.expr.build();
            sub.end.connect(sub.start);
            auto.start.connect(sub.start);
            sub.end.connect(auto.end);
            return auto;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Star<E>
    implements Expression<E> {
        public final Expression<E> expr;

        public Star(Expression<E> expr) {
            this.expr = expr;
        }

        public boolean apply(E entity) {
            return this.expr.apply(entity);
        }

        public String toString() {
            return this.expr.toString() + "*";
        }

        @Override
        public FiniteAutomaton.Automaton<E> build() {
            FiniteAutomaton.Automaton auto = new FiniteAutomaton.Automaton(this);
            FiniteAutomaton.Automaton<E> sub = this.expr.build();
            sub.end.connect(sub.start);
            auto.start.connect(sub.start);
            sub.end.connect(auto.end);
            auto.start.connect(auto.end);
            return auto;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Or<E>
    implements Expression<E> {
        public final Expression<E> expr1;
        public final Expression<E> expr2;

        public Or(Expression<E> expr1, Expression<E> expr2) {
            this.expr1 = expr1;
            this.expr2 = expr2;
        }

        public boolean apply(E entity) {
            return true;
        }

        public String toString() {
            return this.expr1.toString() + " | " + this.expr2.toString();
        }

        @Override
        public FiniteAutomaton.Automaton<E> build() {
            FiniteAutomaton.Automaton auto = new FiniteAutomaton.Automaton(this);
            FiniteAutomaton.Automaton<E> sub1 = this.expr1.build();
            FiniteAutomaton.Automaton<E> sub2 = this.expr2.build();
            auto.start.connect(sub1.start);
            auto.start.connect(sub2.start);
            sub1.end.connect(auto.end);
            sub2.end.connect(auto.end);
            return auto;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class NonMatchingGroup<E>
    extends MatchingGroup<E> {
        public NonMatchingGroup(List<Expression<E>> expressions) {
            super(expressions);
        }

        @Override
        public String toString() {
            return "(?:" + super.subexpString() + ")";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class NamedGroup<E>
    extends MatchingGroup<E> {
        public final String name;

        public NamedGroup(String name, List<Expression<E>> expressions) {
            super(expressions);
            this.name = name;
        }

        @Override
        public String toString() {
            return "(<" + this.name + ">:" + super.subexpString() + ")";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class MatchingGroup<E>
    implements Expression<E> {
        public final List<Expression<E>> expressions;

        public MatchingGroup(List<Expression<E>> expressions) {
            this.expressions = expressions;
        }

        public boolean apply(E entity) {
            throw new UnsupportedOperationException();
        }

        public String subexpString() {
            ArrayList<String> subs = new ArrayList<String>(this.expressions.size());
            for (Expression<E> expr : this.expressions) {
                subs.add(expr.toString());
            }
            return Joiner.on((String)" ").join(subs);
        }

        public String toString() {
            return "(" + this.subexpString() + ")";
        }

        @Override
        public FiniteAutomaton.Automaton<E> build() {
            FiniteAutomaton.Automaton<E> sub;
            FiniteAutomaton.Automaton auto = new FiniteAutomaton.Automaton(this);
            Iterator<Expression<E>> exprIterator = this.expressions.iterator();
            FiniteAutomaton.TerminusState prev = auto.start;
            if (exprIterator.hasNext()) {
                sub = exprIterator.next().build();
                auto.start.connect(sub.start);
                prev = sub.end;
            }
            while (exprIterator.hasNext()) {
                Expression<E> expr = exprIterator.next();
                sub = expr.build();
                FiniteAutomaton.State connector = new FiniteAutomaton.State();
                prev.connect(connector);
                connector.connect(sub.start);
                prev = sub.end;
            }
            prev.connect(auto.end);
            return auto;
        }
    }
}

