/*
 * Decompiled with CFR 0.152.
 */
package edu.washington.cs.knowitall.regex;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Predicate;
import edu.washington.cs.knowitall.regex.Expression;
import edu.washington.cs.knowitall.regex.FiniteAutomaton;
import edu.washington.cs.knowitall.regex.Match;
import edu.washington.cs.knowitall.regex.RegexException;
import edu.washington.cs.knowitall.regex.RegularExpressions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Scanner;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RegularExpression<E>
implements Predicate<List<E>> {
    public final List<Expression<E>> expressions;
    public final FiniteAutomaton.Automaton<E> auto;

    protected RegularExpression(String expression, Function<String, Expression.BaseExpression<E>> factory) {
        this.expressions = this.tokenize(expression, factory);
        this.auto = this.build(this.expressions);
    }

    public static <E> RegularExpression<E> compile(String expression, Function<String, Expression.BaseExpression<E>> factory) {
        return new RegularExpression<E>(expression, factory);
    }

    public boolean equals(Object other) {
        if (!(other instanceof RegularExpression)) {
            return false;
        }
        RegularExpression expression = (RegularExpression)other;
        return this.toString().equals(expression.toString());
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public String toString() {
        ArrayList<String> expressions = new ArrayList<String>(this.expressions.size());
        for (Expression<E> expr : this.expressions) {
            expressions.add(expr.toString());
        }
        return Joiner.on((String)" ").join(expressions);
    }

    protected FiniteAutomaton.Automaton<E> build(List<Expression<E>> exprs) {
        Expression.MatchingGroup<E> group = new Expression.MatchingGroup<E>(exprs);
        return group.build();
    }

    public boolean apply(List<E> tokens) {
        return this.find(tokens) != null;
    }

    public boolean matches(List<E> tokens) {
        Match<E> match = this.lookingAt(tokens, 0);
        return match != null && match.endIndex() == tokens.size();
    }

    public Match<E> find(List<E> tokens) {
        return this.find(tokens, 0);
    }

    public Match<E> find(List<E> tokens, int start) {
        for (int i = start; i < tokens.size(); ++i) {
            Match<E> match = this.lookingAt(tokens, i);
            if (match == null) continue;
            return match;
        }
        return null;
    }

    public Match<E> lookingAt(List<E> tokens) {
        return this.lookingAt(tokens, 0);
    }

    public Match<E> lookingAt(List<E> tokens, int start) {
        return this.auto.lookingAt(tokens, start);
    }

    public Match<E> match(List<E> tokens) {
        Match<E> match = this.lookingAt(tokens);
        if (match != null && match.endIndex() == tokens.size()) {
            return match;
        }
        return null;
    }

    public List<Match<E>> findAll(List<E> tokens) {
        Match<E> match;
        ArrayList<Match<Match<E>>> results = new ArrayList<Match<Match<E>>>();
        int start = 0;
        do {
            if ((match = this.find(tokens, start)) == null) continue;
            start = match.endIndex();
            if (match.isEmpty()) continue;
            results.add(match);
        } while (match != null);
        return results;
    }

    public List<Expression<E>> tokenize(String string, Function<String, Expression.BaseExpression<E>> factory) {
        ArrayList<Expression<Expression<E>>> expressions = new ArrayList<Expression<Expression<E>>>();
        Pattern whitespacePattern = Pattern.compile("\\s+");
        Pattern unaryPattern = Pattern.compile("[*?+]");
        Pattern binaryPattern = Pattern.compile("[|]");
        ArrayList<String> tokens = new ArrayList<String>();
        int stack = 32;
        int start = 0;
        while (start < string.length()) {
            Matcher matcher = whitespacePattern.matcher(string);
            if (matcher.region(start, string.length()).lookingAt()) {
                start = matcher.end();
                continue;
            }
            char c = string.charAt(start);
            if (c == '(' || c == '<' || c == '[' || c == '$' || c == '^') {
                int end;
                if (string.charAt(start) == '(') {
                    end = RegularExpression.indexOfClose(string, start, '(', ')');
                    if (end == -1) {
                        throw new RegexException.TokenizationRegexException("unclosed parenthesis: " + start + ":\"" + string.substring(start) + ")\"");
                    }
                    String group = string.substring(start + 1, end);
                    start = end + 1;
                    Pattern namedPattern = Pattern.compile("<(\\w*)>:(.*)");
                    Pattern unnamedPattern = Pattern.compile("\\?:(.*)");
                    matcher = namedPattern.matcher(group);
                    if (matcher.matches()) {
                        String groupName = matcher.group(1);
                        group = matcher.group(2);
                        List<Expression<E>> groupExpressions = this.tokenize(group, factory);
                        expressions.add(new Expression.NamedGroup<E>(groupName, groupExpressions));
                    } else {
                        List<Expression<E>> groupExpressions;
                        matcher = unnamedPattern.matcher(group);
                        if (matcher.matches()) {
                            group = matcher.group(1);
                            groupExpressions = this.tokenize(group, factory);
                            expressions.add(new Expression.NonMatchingGroup<E>(groupExpressions));
                        } else {
                            groupExpressions = this.tokenize(group, factory);
                            expressions.add(new Expression.MatchingGroup<E>(groupExpressions));
                        }
                    }
                } else if (c == '<' || c == '[') {
                    if (c == '<') {
                        end = RegularExpression.indexOfClose(string, start, '<', '>');
                    } else if (c == '[') {
                        end = RegularExpression.indexOfClose(string, start, '[', ']');
                    } else {
                        throw new IllegalStateException();
                    }
                    if (end == -1) {
                        throw new RegexException.TokenizationRegexException("bad token. Non-matching brackets (<> or []): " + start + ":\"" + string.substring(start) + "\"");
                    }
                    String token = string.substring(start + 1, end);
                    try {
                        Expression.BaseExpression base = (Expression.BaseExpression)factory.apply((Object)token);
                        expressions.add(base);
                        start = end + 1;
                    }
                    catch (Exception e) {
                        throw new RegexException.TokenizationRegexException("error parsing token: " + token, e);
                    }
                } else if (c == '^') {
                    expressions.add(new Expression.StartAssertion());
                    ++start;
                } else if (c == '$') {
                    expressions.add(new Expression.EndAssertion());
                    ++start;
                }
                if (stack != 124) continue;
                try {
                    stack = 32;
                    if (expressions.size() < 2) {
                        throw new IllegalStateException("OR operator is applied to fewer than 2 elements.");
                    }
                    Expression expr1 = (Expression)expressions.remove(expressions.size() - 1);
                    Expression expr2 = (Expression)expressions.remove(expressions.size() - 1);
                    expressions.add(new Expression.Or(expr1, expr2));
                    continue;
                }
                catch (Exception e) {
                    throw new RegexException.TokenizationRegexException("error parsing OR (|) operator.", e);
                }
            }
            matcher = unaryPattern.matcher(string);
            if (matcher.region(start, string.length()).lookingAt()) {
                Expression expr;
                char operator = matcher.group(0).charAt(0);
                Expression base = (Expression)expressions.remove(expressions.size() - 1);
                if (operator == '?') {
                    expr = new Expression.Option(base);
                } else if (operator == '*') {
                    expr = new Expression.Star(base);
                } else if (operator == '+') {
                    expr = new Expression.Plus(base);
                } else {
                    throw new IllegalStateException();
                }
                expressions.add(expr);
                start = matcher.end();
                continue;
            }
            matcher = binaryPattern.matcher(string);
            if (matcher.region(start, string.length()).lookingAt()) {
                tokens.add(matcher.group(0));
                stack = 124;
                start = matcher.end();
                continue;
            }
            throw new RegexException.TokenizationRegexException("unknown symbol: " + string.substring(start));
        }
        if (stack == 124) {
            throw new RegexException.TokenizationRegexException("OR remains on the stack.");
        }
        return expressions;
    }

    public List<String> split(String expression) {
        Pattern tokenPattern = Pattern.compile("\\(?<.*?>\\)?[*?+]?");
        return RegularExpression.splitInto(expression, tokenPattern);
    }

    public static void main(String[] args) {
        Scanner scan = new Scanner(System.in);
        RegularExpression<String> regex = RegularExpressions.word(args[0]);
        System.out.println("regex: " + regex);
        System.out.println();
        while (scan.hasNextLine()) {
            String line = scan.nextLine();
            System.out.println("contains: " + regex.apply(Arrays.asList(line.split("\\s+"))));
            System.out.println("matches:  " + regex.matches(Arrays.asList(line.split("\\s+"))));
            System.out.println();
        }
    }

    private static List<String> splitInto(String string, Pattern pattern) {
        Matcher matcher = pattern.matcher(string);
        ArrayList<String> parts = new ArrayList<String>();
        int i = 0;
        while (matcher.find(i)) {
            if (i < matcher.start()) {
                throw new IllegalArgumentException("Could not split string into specified pattern.  Found matches '" + Joiner.on((String)", ").join(parts) + "' and then '" + string.charAt(i) + "' found between matches.");
            }
            if (matcher.groupCount() > 0) {
                parts.add(matcher.group(1));
            } else {
                parts.add(matcher.group(0));
            }
            i = matcher.end();
        }
        if (i != string.length()) {
            throw new IllegalArgumentException("Pattern does not extend to end of string: " + i + "/" + string.length());
        }
        return parts;
    }

    private static int indexOfClose(String string, int start, char open, char close) {
        --start;
        int count = 0;
        do {
            if (++start >= string.length()) {
                return -1;
            }
            char c = string.charAt(start);
            if (c == open) {
                ++count;
                continue;
            }
            if (c != close) continue;
            --count;
        } while (count > 0);
        return start;
    }
}

