/*
 * Decompiled with CFR 0.152.
 */
package edu.washington.cs.knowitall.argumentidentifier;

import edu.washington.cs.knowitall.argumentidentifier.ArgLocationClassifier;
import edu.washington.cs.knowitall.argumentidentifier.ArgSubstructureClassifier;
import edu.washington.cs.knowitall.argumentidentifier.ArgSubstructureFeatureGenerator;
import edu.washington.cs.knowitall.argumentidentifier.PatternExtractor;
import edu.washington.cs.knowitall.commonlib.Range;
import edu.washington.cs.knowitall.extractor.Extractor;
import edu.washington.cs.knowitall.extractor.ExtractorException;
import edu.washington.cs.knowitall.nlp.extraction.ChunkedArgumentExtraction;
import edu.washington.cs.knowitall.nlp.extraction.ChunkedExtraction;
import java.io.IOException;
import java.util.ArrayList;

public class ArgLearner
extends Extractor<ChunkedExtraction, ChunkedArgumentExtraction> {
    private Mode mode;
    private PatternExtractor patternextractor;
    public ArgLocationClassifier arg1rightboundclassifier;
    public ArgLocationClassifier arg2leftboundclassifier;
    public ArgSubstructureClassifier arg1leftboundclassifier;
    public ArgSubstructureClassifier arg2rightboundclassifier;

    public ArgLearner(Mode mode) {
        this.mode = mode;
        this.patternextractor = new PatternExtractor();
        try {
            if (mode == Mode.LEFT) {
                ArgSubstructureFeatureGenerator featuregeneratorsub = new ArgSubstructureFeatureGenerator(mode);
                this.arg1rightboundclassifier = new ArgLocationClassifier(mode);
                this.arg1leftboundclassifier = new ArgSubstructureClassifier(mode, featuregeneratorsub);
            } else {
                ArgSubstructureFeatureGenerator featuregeneratorsub = new ArgSubstructureFeatureGenerator(mode);
                this.arg2leftboundclassifier = new ArgLocationClassifier(mode);
                this.arg2rightboundclassifier = new ArgSubstructureClassifier(mode, featuregeneratorsub);
            }
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    protected Iterable<ChunkedArgumentExtraction> extractCandidates(ChunkedExtraction predicate) throws ExtractorException {
        ArrayList<ChunkedArgumentExtraction> args = new ArrayList<ChunkedArgumentExtraction>();
        ChunkedArgumentExtraction arg = null;
        arg = this.mode == Mode.LEFT ? this.getArg1(predicate) : this.getArg2(predicate);
        if (arg != null) {
            ArrayList<ChunkedArgumentExtraction> splitargs = this.splitArg(arg);
            args.addAll(splitargs);
        }
        return args;
    }

    private ArrayList<ChunkedArgumentExtraction> splitArg(ChunkedArgumentExtraction arg) {
        ArrayList<ChunkedArgumentExtraction> args = new ArrayList<ChunkedArgumentExtraction>();
        if (this.patternextractor.matchesListStrict(arg)) {
            int start = arg.getStart();
            int length = 0;
            for (int i = arg.getStart(); i < arg.getStart() + arg.getLength(); ++i) {
                if (arg.getSentence().getToken(i).equals(",") && (i >= arg.getSentence().getLength() || !arg.getSentence().getToken(i + 1).equals("and") && !arg.getSentence().getToken(i + 1).equals("or")) || arg.getSentence().getToken(i).equals("and") || arg.getSentence().getToken(i).equals("or")) {
                    args.add(new ChunkedArgumentExtraction(arg.getSentence(), new Range(start, length), arg.getRelation()));
                    start = i + 1;
                    length = 0;
                    continue;
                }
                if (arg.getSentence().getToken(i).equals(",")) continue;
                ++length;
            }
            args.add(new ChunkedArgumentExtraction(arg.getSentence(), new Range(start, length), arg.getRelation()));
        } else if (this.patternextractor.matchesAppositiveStrict(arg)) {
            int start = arg.getStart();
            int length = 0;
            for (int i = arg.getStart(); i < arg.getStart() + arg.getLength(); ++i) {
                if (arg.getSentence().getToken(i).equals(",")) {
                    args.add(new ChunkedArgumentExtraction(arg.getSentence(), new Range(start, length), arg.getRelation()));
                    start = i + 1;
                    length = 0;
                    continue;
                }
                ++length;
            }
            args.add(new ChunkedArgumentExtraction(arg.getSentence(), new Range(start, length), arg.getRelation()));
        } else {
            args.add(arg);
        }
        return args;
    }

    private ChunkedArgumentExtraction getArg1(ChunkedExtraction predicate) {
        if (predicate.getStart() < 1) {
            return null;
        }
        double[] classifierresults = this.arg1rightboundclassifier.getArgBound(predicate);
        int rightbound = (int)classifierresults[0];
        if (rightbound > 0) {
            double[] leftbound_conf = this.getArg1LeftBound(predicate, rightbound);
            int leftbound = (int)leftbound_conf[0];
            double conf = leftbound_conf[1];
            ChunkedArgumentExtraction arg1 = new ChunkedArgumentExtraction(predicate.getSentence(), new Range(leftbound, rightbound - leftbound), predicate, conf);
            return arg1;
        }
        return null;
    }

    private double[] getArg1LeftBound(ChunkedExtraction predicate, int rightbound) {
        double[] resultsclassifier = this.arg1leftboundclassifier.getArgBound(predicate, rightbound);
        if (resultsclassifier[0] == -1.0) {
            resultsclassifier[0] = this.getNPStart(predicate, rightbound - 1);
        }
        return resultsclassifier;
    }

    private ChunkedArgumentExtraction getArg2(ChunkedExtraction predicate) {
        int leftbound;
        int rightbound = leftbound = this.getArg2LeftBound(predicate);
        double conf = 0.0;
        if (leftbound > -1) {
            double[] confloc = this.getArg2RightBound(predicate, leftbound);
            rightbound = (int)confloc[0];
            conf = confloc[1];
        }
        if (rightbound <= leftbound || leftbound < 0 || leftbound > predicate.getSentence().getLength() - 1) {
            leftbound = 0;
            rightbound = 0;
        }
        Range newrange = new Range(leftbound, rightbound - leftbound);
        if (rightbound == 0) {
            return null;
        }
        ChunkedArgumentExtraction argument2 = new ChunkedArgumentExtraction(predicate.getSentence(), newrange, predicate, conf);
        if (!argument2.getChunkTagsAsString().contains("NP")) {
            return null;
        }
        return argument2;
    }

    private int getArg2LeftBound(ChunkedExtraction predicate) {
        return (int)this.arg2leftboundclassifier.getArgBound(predicate)[0];
    }

    private double[] getArg2RightBound(ChunkedExtraction predicate, int leftbound) {
        double[] resultsclassifier = this.arg2rightboundclassifier.getArgBound(predicate, leftbound);
        return resultsclassifier;
    }

    private int getNPStart(ChunkedExtraction extr, int end) {
        for (int i = end; i > -1; --i) {
            if (i == extr.getRange().getStart()) {
                return i;
            }
            if (!((String)extr.getSentence().getChunkTags().get(i)).equals("B-NP")) continue;
            return i;
        }
        return -1;
    }

    public static enum Mode {
        LEFT,
        RIGHT;

    }
}

