/*
 * Decompiled with CFR 0.152.
 */
package edu.washington.cs.knowitall.argumentidentifier;

import cc.mallet.fst.CRF;
import cc.mallet.fst.Transducer;
import cc.mallet.fst.confidence.ViterbiConfidenceEstimator;
import cc.mallet.pipe.Pipe;
import cc.mallet.pipe.iterator.LineGroupIterator;
import cc.mallet.types.Instance;
import cc.mallet.types.InstanceList;
import cc.mallet.types.Sequence;
import com.google.common.collect.ImmutableList;
import edu.washington.cs.knowitall.argumentidentifier.ArgLearner;
import edu.washington.cs.knowitall.argumentidentifier.ArgSubstructureFeatureGenerator;
import edu.washington.cs.knowitall.argumentidentifier.Pair;
import edu.washington.cs.knowitall.commonlib.ResourceUtils;
import edu.washington.cs.knowitall.nlp.extraction.ChunkedExtraction;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.Iterator;
import java.util.regex.Pattern;

public class ArgSubstructureClassifier {
    private ArgLearner.Mode mode;
    private static final String ARG1_FILE = "arg1substructure-model";
    private static final String ARG2_FILE = "arg2substructure-model";
    private CRF crf = null;
    private Pipe crf_pipe = null;
    private ViterbiConfidenceEstimator crf_estimator;
    private ObjectInputStream crf_input;
    private String[] startTags = new String[]{"B-ARG"};
    private String[] inTags = new String[]{"I-ARG"};
    private ArgSubstructureFeatureGenerator featuregenerator;

    public ArgSubstructureClassifier(ArgLearner.Mode mode, ArgSubstructureFeatureGenerator featuregenerator) {
        this.mode = mode;
        this.featuregenerator = featuregenerator;
        if (mode == ArgLearner.Mode.LEFT) {
            this.setupClassifier(ARG1_FILE);
        } else {
            this.setupClassifier(ARG2_FILE);
        }
    }

    private Pair<Double, Sequence<?>> applyCRF(String testingdata) {
        Sequence input = null;
        Sequence output = null;
        InstanceList testSequence = null;
        this.crf_pipe.setTargetProcessing(true);
        testSequence = new InstanceList(this.crf_pipe);
        testSequence.addThruPipe((Iterator)new LineGroupIterator((Reader)new StringReader(testingdata), Pattern.compile("^\\s*$"), true));
        if (testSequence.size() < 1) {
            return new Pair<Double, Object>(-1.0, null);
        }
        Instance inst = (Instance)testSequence.get(0);
        input = (Sequence)inst.getData();
        output = this.crf.transduce(input);
        Double conf = this.crf_estimator.estimateConfidenceFor(inst, (Object[])this.startTags, (Object[])this.inTags);
        return new Pair(conf, output);
    }

    private int readCRFOutputLeft(ChunkedExtraction extr, int start, Sequence<?> output) {
        int s = 0;
        int predstart = extr.getStart();
        int lastnp = -1;
        boolean foundo = false;
        boolean foundarg = false;
        ImmutableList<String> chunkLabels = extr.getSentence().getChunkTags();
        for (int i = predstart; i > -1; --i) {
            if (((String)chunkLabels.get(i)).equals("I-NP") || i >= start && i != predstart) continue;
            String crflabel = "";
            crflabel = output.get(s).toString();
            if (i != predstart && !crflabel.contains("O")) {
                foundarg = true;
                lastnp = i;
            } else {
                if (i != predstart && crflabel.equals("O")) break;
                if (i != predstart && crflabel.contains("O")) {
                    foundo = true;
                }
            }
            ++s;
        }
        if (foundo && foundarg) {
            lastnp = -1;
        }
        return lastnp;
    }

    private int readCRFOutputRight(ChunkedExtraction extr, int start, Sequence<?> output) {
        int s = 1;
        int lastnp = -1;
        ImmutableList<String> chunkLabels = extr.getSentence().getChunkTags();
        for (int i = start; i < extr.getSentence().getLength(); ++i) {
            if (i > start && ((String)chunkLabels.get(i)).equals("I-NP")) continue;
            String crflabel = "";
            crflabel = output.get(s).toString();
            if (crflabel.equals("O")) {
                lastnp = i;
                break;
            }
            ++s;
        }
        if (lastnp < 0) {
            lastnp = extr.getSentence().getLength();
        }
        return lastnp;
    }

    private double[] classifyData(String testingdata, ChunkedExtraction extr, int start) {
        double[] toreturn = new double[]{-1.0, -1.0};
        if (testingdata == null || testingdata.equals("")) {
            return toreturn;
        }
        Pair<Double, Sequence<?>> pair = this.applyCRF(testingdata);
        Double conf = pair.getFirst();
        Sequence<?> output = pair.getSecond();
        if (conf == -1.0) {
            return toreturn;
        }
        int lastnp = -1;
        lastnp = this.mode == ArgLearner.Mode.LEFT ? this.readCRFOutputLeft(extr, start, output) : this.readCRFOutputRight(extr, start, output);
        toreturn[0] = lastnp;
        toreturn[1] = conf;
        return toreturn;
    }

    private void setupClassifier(String trainingdata) {
        try {
            this.crf_input = new ObjectInputStream(ResourceUtils.loadResource((String)trainingdata, this.getClass()));
            this.crf = (CRF)this.crf_input.readObject();
            this.crf_input.close();
        }
        catch (FileNotFoundException e1) {
            e1.printStackTrace();
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        this.crf.getInputAlphabet().stopGrowth();
        this.crf.getOutputAlphabet().stopGrowth();
        this.crf_pipe = this.crf.getInputPipe();
        this.crf_pipe.setTargetProcessing(false);
        this.crf_estimator = new ViterbiConfidenceEstimator((Transducer)this.crf);
    }

    private String extractFeatures(ChunkedExtraction extr, int argstart, int argend, boolean train) {
        String features = this.featuregenerator.extractCRFFeatures(extr, argstart, argend, train);
        return features;
    }

    public double[] getArgBound(ChunkedExtraction predicate, int other_bound) {
        String features = this.extractFeatures(predicate, other_bound, other_bound, false);
        double[] resultsclassifier = this.classifyData(features, predicate, other_bound);
        return resultsclassifier;
    }
}

