/*
 * Decompiled with CFR 0.152.
 */
package edu.washington.cs.knowitall.argumentidentifier;

import com.google.common.collect.ImmutableList;
import edu.washington.cs.knowitall.argumentidentifier.ArgLearner;
import edu.washington.cs.knowitall.argumentidentifier.ExtractionParameters;
import edu.washington.cs.knowitall.argumentidentifier.PatternExtractor;
import edu.washington.cs.knowitall.argumentidentifier.PositionInstance;
import edu.washington.cs.knowitall.nlp.extraction.ChunkedExtraction;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import java.util.regex.Pattern;

public class ArgSubstructureFeatureGenerator {
    private ArgLearner.Mode mode;
    static int CHUNK_FEATURE = 0;
    static int TAG_FEATURE = 1;
    static int LEX_FEATURE = 2;
    static int PARSE_FEATURE = 3;
    static String B_ARG = "B-ARG";
    static String I_ARG = "I-ARG";
    static String O = "O";
    private static String CAPS = "[A-Z\u00e7\u00ea\u00f2\u00e9\u00f1\u0082\u00ec]";
    private static String ALPHA = "[A-Z\u00e7\u00ea\u00f2\u00e9\u00f1\u0082\u00eca-z\u0088\u0093\u009d\u008e\u0097\u008d\u0095]";
    private static String ALPHANUM = "[A-Z\u00e7\u00ea\u00f2\u00e9\u00f1\u0082\u00eca-z\u0088\u0093\u009d\u008e\u0097\u008d\u00950-9]";
    private static String PUNT = "[,\\.;:?!()]";
    private Vector<Pattern> patterns = null;
    private Vector<String> featureNames = null;
    private static HashSet<String> lexicalizeIfTag = null;
    private static HashSet<String> lexicalizeIfWord = null;
    private static HashSet<String> stopWord = null;
    private PatternExtractor pattern_extractor;

    public ArgSubstructureFeatureGenerator(ArgLearner.Mode mode) {
        this.mode = mode;
        this.pattern_extractor = new PatternExtractor();
        this.init();
    }

    private void init() {
        lexicalizeIfTag = new HashSet();
        lexicalizeIfTag.add("IN");
        lexicalizeIfTag.add("MD");
        lexicalizeIfTag.add("DT");
        lexicalizeIfTag.add("WDT");
        lexicalizeIfTag.add("WP");
        lexicalizeIfTag.add("RP");
        lexicalizeIfTag.add("PRT");
        lexicalizeIfTag.add("WRB");
        lexicalizeIfTag.add("WRB");
        lexicalizeIfTag.add("CC");
        lexicalizeIfWord = new HashSet();
        lexicalizeIfWord.add("be");
        lexicalizeIfWord.add("been");
        lexicalizeIfWord.add("is");
        lexicalizeIfWord.add("was");
        lexicalizeIfWord.add("are");
        lexicalizeIfWord.add("were");
        lexicalizeIfWord.add("has");
        lexicalizeIfWord.add("had");
        lexicalizeIfWord.add("have");
        lexicalizeIfWord.add("n't");
        lexicalizeIfWord.add("not");
        lexicalizeIfWord.add("that");
        lexicalizeIfWord.add("which");
        lexicalizeIfWord.add("as");
        lexicalizeIfWord.add("but");
        lexicalizeIfWord.add("and");
        lexicalizeIfWord.add("or");
        lexicalizeIfWord.add("said");
        lexicalizeIfWord.add("say");
        lexicalizeIfWord.add("says");
        stopWord = new HashSet();
        stopWord.add("said");
        stopWord.add("say");
        stopWord.add("says");
        this.patterns = new Vector();
        this.featureNames = new Vector();
        this.featureNames.add("INITCAP");
        this.patterns.add(Pattern.compile(CAPS + ".*"));
        this.featureNames.add("ALLDIGITS");
        this.patterns.add(Pattern.compile("[0-9]*"));
        this.featureNames.add("ALLCAPS");
        this.patterns.add(Pattern.compile(CAPS + "+"));
        this.featureNames.add("CONTAINSDIGITS");
        this.patterns.add(Pattern.compile(".*[0-9].*"));
        this.featureNames.add("ALLDIGITS");
        this.patterns.add(Pattern.compile("[0-9]+"));
        this.featureNames.add("CONTAINSDOTS");
        this.patterns.add(Pattern.compile("[^\\.]*\\..*"));
        this.featureNames.add("CONTAINSDASH");
        this.patterns.add(Pattern.compile(ALPHANUM + "+-" + ALPHANUM + "*"));
        this.featureNames.add("ACRO");
        this.patterns.add(Pattern.compile("[A-Z][A-Z\\.]*\\.[A-Z\\.]*"));
        this.featureNames.add("LONELYINITIAL");
        this.patterns.add(Pattern.compile(CAPS + "\\."));
        this.featureNames.add("SINGLECHAR");
        this.patterns.add(Pattern.compile(ALPHA));
        this.featureNames.add("CAPLETTER");
        this.patterns.add(Pattern.compile(CAPS));
        this.featureNames.add("PUNC");
        this.patterns.add(Pattern.compile(PUNT));
    }

    private String convertInstancesToFeatures(Vector<Vector<String>> instances, Boolean train) {
        if (instances == null) {
            return "";
        }
        StringBuilder features = new StringBuilder();
        for (Vector<String> instance : instances) {
            String label = instance.lastElement();
            for (String feature : instance) {
                if (!train.booleanValue() && feature.equals(label)) continue;
                features.append(feature + " ");
            }
            features.append("\n");
        }
        return features.toString();
    }

    private ArrayList<String> getSetFeatures(ChunkedExtraction extr, int argend, boolean train) {
        ArrayList<String> setfeatures = new ArrayList<String>();
        boolean rel = false;
        boolean nest1 = false;
        boolean adj = false;
        boolean comp = false;
        boolean nest2 = false;
        boolean npinf = false;
        boolean inf = false;
        boolean doublenp = false;
        boolean list = false;
        boolean ifclause = false;
        boolean compoundverb = false;
        boolean nextIsThat = false;
        boolean comma = false;
        boolean pp = false;
        boolean npvp = false;
        boolean quotes = false;
        boolean statement = false;
        if (this.mode != ArgLearner.Mode.LEFT) {
            adj = this.pattern_extractor.adjRelation(extr);
            comp = this.pattern_extractor.complementClause(extr);
            nest2 = this.pattern_extractor.nestedRelation2(extr);
            npinf = this.pattern_extractor.npInfinitiveClause(extr);
            inf = this.pattern_extractor.infinitiveClause(extr);
            doublenp = this.pattern_extractor.doubleNP(extr);
            list = this.pattern_extractor.startsList(extr);
            ifclause = this.pattern_extractor.ifClause(extr);
            compoundverb = this.pattern_extractor.compoundVerb(extr);
            rel = this.pattern_extractor.npRelativeClause(extr);
            nest1 = this.pattern_extractor.nestedRelation1(extr);
        } else {
            nextIsThat = this.pattern_extractor.nextIsThat(extr, argend - 1);
            comma = this.pattern_extractor.matchesCommaBeforeVerb(extr);
            pp = this.pattern_extractor.matchesPPBeforeVerb(extr);
            npvp = this.pattern_extractor.matchesNPVerb(extr);
            quotes = this.pattern_extractor.matchesQuotes(extr);
            rel = this.pattern_extractor.matchesRelativeClause(extr, argend);
        }
        if (rel) {
            setfeatures.add("REL");
        } else if (nest2) {
            setfeatures.add("NEST2");
        }
        if (nest1) {
            setfeatures.add("NEST1");
        }
        if (adj) {
            setfeatures.add("ADJ");
        }
        if (comp) {
            setfeatures.add("COMP");
        }
        if (npinf) {
            setfeatures.add("NPINF");
        }
        if (doublenp) {
            setfeatures.add("DOUBLENP");
        }
        if (inf) {
            setfeatures.add("INF");
        }
        if (nextIsThat) {
            setfeatures.add("NEXT_THAT");
        }
        if (list) {
            setfeatures.add("LIST");
        }
        if (compoundverb) {
            setfeatures.add("COMPOUND");
        }
        if (ifclause) {
            setfeatures.add("IFCLAUSE");
        }
        if (comma) {
            setfeatures.add("COMMA");
        }
        if (pp) {
            setfeatures.add("PP");
        }
        if (npvp) {
            setfeatures.add("NPVP");
        }
        if (quotes) {
            setfeatures.add("QUOTES");
        }
        if (statement) {
            setfeatures.add("STATEMENT");
        }
        return setfeatures;
    }

    private PositionInstance addRegexPatternFeatures(ChunkedExtraction extr, PositionInstance instance, int argstart, int argend, int current, boolean train) {
        boolean relnext = false;
        boolean list = false;
        boolean vbg = false;
        boolean app = false;
        boolean app2 = false;
        boolean prev_stop = false;
        if (this.mode != ArgLearner.Mode.LEFT) {
            vbg = this.pattern_extractor.vbgIsNext(extr, current + 1);
            app = this.pattern_extractor.appClause(extr, current + 1);
            relnext = this.pattern_extractor.relClause(extr, current + 1);
        } else {
            app = this.pattern_extractor.matchesAppositiveClause(extr, current);
            list = this.pattern_extractor.matchesList(extr, argend, current);
            prev_stop = this.pattern_extractor.prevStop(extr, current);
        }
        if (app) {
            instance.addFeature("APP");
        }
        if (app2) {
            instance.addFeature("APP2");
        }
        if (prev_stop) {
            instance.addFeature("END");
        }
        if (list) {
            instance.addFeature("LIST");
        }
        if (relnext) {
            instance.addFeature("RELNEXT");
        }
        if (vbg) {
            instance.addFeature("NEXTVBG");
        }
        return instance;
    }

    private int getCountToEnd(List<String> chunkLabels, int start) {
        int counttoend = 0;
        if (this.mode == ArgLearner.Mode.LEFT) {
            for (int j = start - 1; j > -1; --j) {
                if (chunkLabels.get(j).equals("I-NP")) continue;
                ++counttoend;
            }
        } else {
            for (int j = start + 1; j < chunkLabels.size(); ++j) {
                if (chunkLabels.get(j).equals("I-NP")) continue;
                ++counttoend;
            }
        }
        return counttoend;
    }

    private PositionInstance addBasicFeatures(PositionInstance instance, String word, String chunkLabel, String tag) {
        instance.addFeature("CHUNK_" + chunkLabel);
        instance.addFeature("TAG_" + tag);
        if (ExtractionParameters.USE_LEX_FEATURES && (lexicalizeIfTag.contains(tag) || lexicalizeIfWord.contains(word.toLowerCase()))) {
            instance.addFeature("WD_" + word.toLowerCase());
        }
        if (ExtractionParameters.USE_PATTERN_FEATURES) {
            Iterator<String> nameIt = this.featureNames.iterator();
            for (Pattern regex : this.patterns) {
                String feature = nameIt.next();
                if (!regex.matcher(word).matches()) continue;
                instance.addFeature(feature);
            }
        }
        return instance;
    }

    private PositionInstance addPatternFeatures(PositionInstance instance, ChunkedExtraction extr, List<String> setfeatures, List<String> chunkLabels, int i, int argstart, int argend, boolean train) {
        instance.addFeature("C_" + this.getCountToEnd(chunkLabels, i));
        if (instance.isMidInstance()) {
            for (int j = 0; j < setfeatures.size(); ++j) {
                instance.addFeature(setfeatures.get(j));
            }
            instance = this.addRegexPatternFeatures(extr, instance, argstart, argend, i, train);
        }
        return instance;
    }

    private Vector<PositionInstance> createBaseInstances(ChunkedExtraction extr, int argstart, int argend, Boolean train) {
        Vector<PositionInstance> instances = new Vector<PositionInstance>();
        int predstart = extr.getStart();
        int predend = extr.getLength() + predstart;
        ImmutableList<String> chunkLabelsOld = extr.getSentence().getChunkTags();
        ArrayList<String> chunkLabels = new ArrayList<String>();
        for (int i = 0; i < chunkLabelsOld.size(); ++i) {
            chunkLabels.add((String)chunkLabelsOld.get(i));
        }
        if (predend < chunkLabels.size() - 1 && ((String)chunkLabels.get(predend)).equals("I-NP")) {
            chunkLabels.set(predend, "B-NP");
        }
        ImmutableList<String> words = extr.getSentence().getTokens();
        ImmutableList<String> tags = extr.getSentence().getPosTags();
        ArrayList<String> setfeatures = this.getSetFeatures(extr, argend, train);
        String class_i = "O";
        boolean foundpred = false;
        int lastnparg1 = -1;
        for (int i = 0; i < extr.getSentence().getLength(); ++i) {
            if (((String)chunkLabels.get(i)).equals("I-NP")) continue;
            PositionInstance instance = new PositionInstance(i);
            if (this.mode == ArgLearner.Mode.LEFT && i < predstart && i < argend || train == false && this.mode != ArgLearner.Mode.LEFT && i >= predend && i >= argend || train.booleanValue() && this.mode != ArgLearner.Mode.LEFT && i >= argstart) {
                instance.setIsMidInstance(true);
            } else {
                instance.setIsMidInstance(false);
            }
            if (i >= predstart && i < predend) {
                instance.setIsRelInstance(true);
                foundpred = true;
            } else if (i == argstart && this.mode != ArgLearner.Mode.LEFT) {
                class_i = B_ARG;
            } else if (i >= argstart && i < argend) {
                class_i = I_ARG;
                lastnparg1 = instances.size();
            } else {
                class_i = O;
            }
            instance = this.addBasicFeatures(instance, (String)words.get(i), (String)chunkLabels.get(i), (String)tags.get(i));
            instance = this.addPatternFeatures(instance, extr, setfeatures, chunkLabels, i, argstart, argend, train);
            instance.addFeature(class_i);
            instances.add(instance);
        }
        if (train.booleanValue() && this.mode == ArgLearner.Mode.LEFT && lastnparg1 > -1) {
            instances.get(lastnparg1).setFeature(instances.get(lastnparg1).size() - 1, "B-ARG");
        }
        if (!foundpred || this.mode == ArgLearner.Mode.LEFT && train.booleanValue() && lastnparg1 < 0) {
            return null;
        }
        return instances;
    }

    private PositionInstance addConjunctionFeatures(PositionInstance inst_i) {
        if (ExtractionParameters.USE_CONJUNCTIVE_FEATURES) {
            String f_str = "";
            for (int k = 0; k < 3 && k < inst_i.size(); ++k) {
                if (inst_i.get(k).contains("^")) continue;
                for (int m = k + 1; m < 3 && m < inst_i.size(); ++m) {
                    if (inst_i.get(m).contains("^")) continue;
                    f_str = inst_i.get(k) + "^" + inst_i.get(m);
                    inst_i.addFeature(inst_i.size() - 1, f_str);
                }
            }
        }
        return inst_i;
    }

    private PositionInstance addLeftWindowFeatures(Vector<PositionInstance> instances, int i) {
        PositionInstance inst_i = instances.get(i);
        String f_str = "";
        for (int j = Math.max(0, i - ExtractionParameters.WINDOW); j < i; ++j) {
            int d = i - j;
            PositionInstance inst_j = instances.get(j);
            if (!inst_j.isMidInstance() || !ExtractionParameters.USE_CONTEXTUAL_FEATURES && !inst_j.isMidInstance()) continue;
            String label_j = inst_j.label();
            for (int k = 0; k < 3 && k < inst_j.size(); ++k) {
                String f_jk = inst_j.get(k);
                if (k == CHUNK_FEATURE) {
                    f_str = "L" + Integer.toString(d) + "-" + f_jk;
                    inst_i.addFeature(inst_i.size() - 1, f_str);
                    if (!ExtractionParameters.USE_CONJUNCTIVE_FEATURES || j != i - 1) continue;
                    f_str = f_str + "^L0-" + inst_i.get(k);
                    inst_i.addFeature(inst_i.size() - 1, f_str);
                    continue;
                }
                if (k == TAG_FEATURE && !label_j.equals("O-NP")) {
                    f_str = "L" + Integer.toString(d) + "-" + f_jk;
                    inst_i.addFeature(inst_i.size() - 1, f_str);
                    if (!ExtractionParameters.USE_CONJUNCTIVE_FEATURES || j != i - 1) continue;
                    f_str = f_str + "^L0-" + inst_i.get(k);
                    inst_i.addFeature(inst_i.size() - 1, f_str);
                    continue;
                }
                if (k != LEX_FEATURE || f_jk.charAt(0) != 'W') continue;
                f_str = "L" + Integer.toString(d) + "-" + f_jk;
                inst_i.addFeature(inst_i.size() - 1, f_str);
                if (!ExtractionParameters.USE_CONJUNCTIVE_FEATURES || j != i - 1 || inst_i.get(k).charAt(0) != 'W') continue;
                f_str = f_str + "^L0-" + inst_i.get(k);
                inst_i.addFeature(inst_i.size() - 1, f_str);
            }
        }
        return inst_i;
    }

    private PositionInstance addRightWindowFeatures(Vector<PositionInstance> instances, int i) {
        PositionInstance inst_i = instances.get(i);
        String f_str = "";
        PositionInstance prev_inst = null;
        String prev_label = null;
        for (int j = i + 1; j < instances.size() && j <= i + ExtractionParameters.WINDOW; ++j) {
            int d = j - i;
            PositionInstance inst_j = instances.get(j);
            String label_j = inst_j.label();
            if (!inst_j.isMidInstance()) continue;
            if (ExtractionParameters.USE_CONTEXTUAL_FEATURES || inst_j.isMidInstance()) {
                for (int k = 0; k < 3 && k < inst_j.size(); ++k) {
                    String f_jk = inst_j.get(k);
                    if (k == CHUNK_FEATURE) {
                        f_str = "R" + Integer.toString(d) + "-" + f_jk;
                        inst_i.addFeature(inst_i.size() - 1, f_str);
                        if (!ExtractionParameters.USE_CONJUNCTIVE_FEATURES || j != i + 2) continue;
                        f_str = f_str + "^R1-" + prev_inst.get(k);
                        f_str = f_str + "^R0-" + inst_i.get(k);
                        inst_i.addFeature(inst_i.size() - 1, f_str);
                        continue;
                    }
                    if (k == TAG_FEATURE && !label_j.equals("O-NP")) {
                        f_str = "R" + Integer.toString(d) + "-" + f_jk;
                        inst_i.addFeature(inst_i.size() - 1, f_str);
                        if (!ExtractionParameters.USE_CONJUNCTIVE_FEATURES || j != i + 2 || prev_label.equals("O-NP")) continue;
                        f_str = f_str + "^R1-" + prev_inst.get(k);
                        f_str = f_str + "^R0-" + inst_i.get(k);
                        inst_i.addFeature(inst_i.size() - 1, f_str);
                        continue;
                    }
                    if (k != LEX_FEATURE || f_jk.charAt(0) != 'W') continue;
                    f_str = "R" + Integer.toString(d) + "-" + f_jk;
                    inst_i.addFeature(inst_i.size() - 1, f_str);
                    if (!ExtractionParameters.USE_CONJUNCTIVE_FEATURES || j != i + 2 || prev_label.equals("O-NP") || inst_i.get(k).charAt(0) != 'W' || prev_inst.get(k).charAt(0) != 'W') continue;
                    f_str = f_str + "^R1-" + prev_inst.get(k);
                    f_str = f_str + "^R0-" + inst_i.get(k);
                    inst_i.addFeature(inst_i.size() - 1, f_str);
                }
            }
            prev_label = label_j;
            prev_inst = inst_j;
        }
        return inst_i;
    }

    private Vector<Vector<String>> addWindowFeatures(Vector<PositionInstance> instances) {
        Vector<Vector<String>> features = new Vector<Vector<String>>();
        for (int i = 0; i < instances.size(); ++i) {
            PositionInstance inst_i = instances.get(i);
            if (!inst_i.isMidInstance()) continue;
            inst_i = this.addConjunctionFeatures(inst_i);
            inst_i = this.addLeftWindowFeatures(instances, i);
            inst_i = this.addRightWindowFeatures(instances, i);
            if (this.mode == ArgLearner.Mode.LEFT) {
                features.add(0, inst_i.features());
                continue;
            }
            features.add(inst_i.features());
        }
        return features;
    }

    private Vector<Vector<String>> addPredicateFeatures(Vector<PositionInstance> instances, Vector<Vector<String>> features) {
        Vector<String> rel_inst = new Vector<String>();
        String relchunks = "";
        String reltags = "";
        String relwds = "";
        for (int i = 0; i < instances.size(); ++i) {
            PositionInstance inst_i = instances.get(i);
            if (!inst_i.isRelInstance()) continue;
            Vector<String> inst_i_features = inst_i.features();
            for (int j = 0; j < inst_i_features.size(); ++j) {
                if (inst_i_features.get(j).split("_").length <= 1) continue;
                String curtype = inst_i_features.get(j).split("_")[0].trim();
                String curfeature = inst_i_features.get(j).split("_")[1].trim();
                if (curtype.equals("TAG")) {
                    reltags = reltags + "TAG_" + curfeature + "^";
                    continue;
                }
                if (curtype.equals("CHUNK")) {
                    relchunks = relchunks + "CHUNK_" + curfeature + "^";
                    continue;
                }
                if (!curtype.equals("WD")) continue;
                relwds = relwds + "WD_" + curfeature + "^";
            }
        }
        if (relwds.length() > 0) {
            relwds = relwds.substring(0, relwds.length() - 1);
            rel_inst.add(0, relwds);
        }
        if (reltags.length() > 0) {
            reltags = reltags.substring(0, reltags.length() - 1);
            rel_inst.add(0, reltags);
        }
        if (relchunks.length() > 0) {
            relchunks = relchunks.substring(0, relchunks.length() - 1);
            rel_inst.add(0, relchunks);
        }
        rel_inst.add("ENTITY1");
        rel_inst.add("O");
        features.add(0, rel_inst);
        return features;
    }

    public String extractCRFFeatures(ChunkedExtraction extr, int argstart, int argend, Boolean train) {
        Vector<PositionInstance> instances = this.createBaseInstances(extr, argstart, argend, train);
        if (instances == null) {
            return null;
        }
        Vector<Vector<String>> features = this.addWindowFeatures(instances);
        if (features.size() == 0) {
            return null;
        }
        features = this.addPredicateFeatures(instances, features);
        String featureString = this.convertInstancesToFeatures(features, train);
        return featureString;
    }
}

