/*
 * Decompiled with CFR 0.152.
 */
package edu.washington.cs.knowitall.extractor;

import edu.washington.cs.knowitall.extractor.Extractor;
import edu.washington.cs.knowitall.extractor.ExtractorException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ExtractorUnion<S, T>
extends Extractor<S, T> {
    private List<Extractor<S, T>> extractors;

    public ExtractorUnion() {
        this.extractors = new ArrayList<Extractor<S, T>>();
    }

    public ExtractorUnion(List<Extractor<S, T>> extractors) {
        this.extractors = new ArrayList<Extractor<S, T>>(extractors.size());
        for (Extractor<S, T> extr : extractors) {
            this.extractors.add(extr);
        }
    }

    public void addExtractor(Extractor<S, T> extractor) {
        this.extractors.add(extractor);
    }

    @Override
    protected Collection<T> extractCandidates(S source) throws ExtractorException {
        if (this.extractors == null || this.extractors.size() == 0) {
            return new ArrayList();
        }
        ArrayList<T> results = new ArrayList<T>(this.extractors.size());
        for (Extractor<S, T> e : this.extractors) {
            for (T extr : e.extract(source)) {
                results.add(extr);
            }
        }
        return results;
    }
}

