/*
 * Decompiled with CFR 0.152.
 */
package edu.washington.cs.knowitall.extractor;

import com.google.common.collect.Iterables;
import edu.washington.cs.knowitall.extractor.ExtractorException;
import edu.washington.cs.knowitall.extractor.ExtractorUnion;
import edu.washington.cs.knowitall.extractor.RegexExtractor;
import edu.washington.cs.knowitall.extractor.RelationFirstNpChunkExtractor;
import edu.washington.cs.knowitall.extractor.mapper.ReVerbRelationMappers;
import edu.washington.cs.knowitall.nlp.ChunkedSentence;
import edu.washington.cs.knowitall.nlp.ChunkedSentenceReader;
import edu.washington.cs.knowitall.nlp.extraction.ChunkedBinaryExtraction;
import edu.washington.cs.knowitall.nlp.extraction.ChunkedExtraction;
import edu.washington.cs.knowitall.sequence.SequenceException;
import edu.washington.cs.knowitall.util.DefaultObjects;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;

public abstract class ReVerbRelationExtractor
extends RelationFirstNpChunkExtractor {
    public static final String VERB = "RB_pos? [MD_pos VB_pos VBD_pos VBP_pos VBZ_pos VBG_pos VBN_pos] RP_pos? RB_pos?";
    public static final String WORD = "[$_pos PRP$_pos CD_pos DT_pos JJ_pos JJS_pos JJR_pos NN_pos NNS_pos NNP_pos NNPS_pos POS_pos PRP_pos RB_pos RBR_pos RBS_pos VBN_pos VBG_pos]";
    public static final String PREP = "RB_pos? [IN_pos TO_pos RP_pos] RB_pos?";
    public static final String LONG_RELATION_PATTERN = String.format("(%s (%s* (%s)+)?)+", "RB_pos? [MD_pos VB_pos VBD_pos VBP_pos VBZ_pos VBG_pos VBN_pos] RP_pos? RB_pos?", "[$_pos PRP$_pos CD_pos DT_pos JJ_pos JJS_pos JJR_pos NN_pos NNS_pos NNP_pos NNPS_pos POS_pos PRP_pos RB_pos RBR_pos RBS_pos VBN_pos VBG_pos]", "RB_pos? [IN_pos TO_pos RP_pos] RB_pos?");
    public static final String SHORT_RELATION_PATTERN = String.format("(%s (%s)?)+", "RB_pos? [MD_pos VB_pos VBD_pos VBP_pos VBZ_pos VBG_pos VBN_pos] RP_pos? RB_pos?", "RB_pos? [IN_pos TO_pos RP_pos] RB_pos?");

    public ReVerbRelationExtractor() throws ExtractorException {
        this.initializeRelationExtractor();
        this.initializeArgumentExtractors();
    }

    public ReVerbRelationExtractor(int minFreq, boolean useLexSynConstraints, boolean mergeOverlapRels, boolean allowUnary) throws ExtractorException {
        this.initializeRelationExtractor(minFreq, useLexSynConstraints, mergeOverlapRels, allowUnary);
        this.initializeArgumentExtractors();
    }

    protected abstract void initializeArgumentExtractors();

    protected void initializeRelationExtractor() throws ExtractorException {
        this.initializeRelationExtractor(20, true, true, false);
    }

    protected void initializeRelationExtractor(int minFreq, boolean useLexSynConstraints, boolean mergeOverlapRels, boolean allowUnary) throws ExtractorException {
        ExtractorUnion<ChunkedSentence, ChunkedExtraction> relExtractor = new ExtractorUnion<ChunkedSentence, ChunkedExtraction>();
        try {
            relExtractor.addExtractor(new RegexExtractor(SHORT_RELATION_PATTERN));
        }
        catch (SequenceException e) {
            throw new ExtractorException("Unable to initialize short pattern extractor", e);
        }
        try {
            relExtractor.addExtractor(new RegexExtractor(LONG_RELATION_PATTERN));
        }
        catch (SequenceException e) {
            throw new ExtractorException("Unable to initialize long pattern extractor", e);
        }
        try {
            relExtractor.addMapper(new ReVerbRelationMappers(minFreq, useLexSynConstraints, mergeOverlapRels));
        }
        catch (IOException e) {
            throw new ExtractorException("Unable to initialize relation mappers", e);
        }
        super.setAllowUnary(allowUnary);
        this.setRelationExtractor(relExtractor);
    }

    public Iterable<ChunkedBinaryExtraction> extractFromString(String text) throws ExtractorException {
        try {
            StringReader in = new StringReader(text);
            return this.extractUsingReader(DefaultObjects.getDefaultSentenceReader(in));
        }
        catch (IOException e) {
            throw new ExtractorException(e);
        }
    }

    public Iterable<ChunkedBinaryExtraction> extractFromHtml(String html) throws ExtractorException {
        StringReader in = new StringReader(html);
        try {
            return this.extractUsingReader(DefaultObjects.getDefaultSentenceReaderHtml(in));
        }
        catch (IOException e) {
            throw new ExtractorException(e);
        }
    }

    private Iterable<ChunkedBinaryExtraction> extractUsingReader(ChunkedSentenceReader reader) throws ExtractorException {
        ArrayList<ChunkedBinaryExtraction> results = new ArrayList<ChunkedBinaryExtraction>();
        Iterable<ChunkedSentence> sents = reader.getSentences();
        for (ChunkedSentence sent : sents) {
            Iterables.addAll(results, this.extract(sent));
        }
        return results;
    }
}

